/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ts_plugin;

import com.devexperts.logging.Logging;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ts_plugin.TsPluginBodyFetcher;
import com.rusefi.ts_plugin.TsPluginUi;
import com.rusefi.util.SwingUtilities2;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.putgemin.VerticalFlowLayout;

public class Updater {
    private static final Logging log = Logging.getLogging(Updater.class);
    private final JPanel content = new JPanel(new VerticalFlowLayout());
    private static final ImageIcon LOGO = AutoupdateUtil.loadIcon("/rusefi_online_color_300.png");
    private final Object lock = new Object();
    private TsPluginUi pluginUiInstance;

    public Updater() {
        this.content.add(new JLabel("2025.alpha.7"));
        this.content.add(new JLabel(LOGO));
        Thread t = new Thread(() -> {
            try {
                this.startPluginUi();
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | InvocationTargetException | MalformedURLException e) {
                log.error("Error launching " + e, e);
            }
        });
        t.setName("RE Plugin Fetcher");
        t.setDaemon(true);
        t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPluginUi() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, InterruptedException, InvocationTargetException {
        log.info("Starting plugin " + this);
        Class clazz = Updater.getPluginClass("com.rusefi.ts_plugin.TsPluginUiImpl");
        Object object = this.lock;
        synchronized (object) {
            if (this.pluginUiInstance != null) {
                log.info("Not starting second instance");
                return;
            }
            SwingUtilities2.invokeAndWait(() -> {
                try {
                    this.pluginUiInstance = (TsPluginUi)clazz.newInstance();
                    this.replaceWith(this.pluginUiInstance);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    public static Class getPluginClass(String className) throws MalformedURLException, ClassNotFoundException {
        log.info("Using " + TsPluginBodyFetcher.LOCAL_JAR_FILE_NAME);
        URLClassLoader jarClassLoader = AutoupdateUtil.getClassLoaderByJar(TsPluginBodyFetcher.LOCAL_JAR_FILE_NAME);
        return Class.forName(className, true, jarClassLoader);
    }

    private void replaceWith(TsPluginUi instance) {
        this.content.removeAll();
        this.content.add(instance.getContent());
        AutoupdateUtil.trueLayoutAndRepaint(this.content.getParent());
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.content);
        AutoupdateUtil.pack(windowAncestor);
    }

    public JPanel getContent() {
        return this.content;
    }
}

