/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.serial;

import com.devexperts.logging.Logging;
import com.opensr5.io.DataListener;
import com.rusefi.Callable;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.ConnectionStateListener;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.util.IoUtils;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.util.Objects;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class PortHolder {
    private static final Logging log = Logging.getLogging(PortHolder.class);
    private final DataListener dataListener;
    private final Callable<IoStream> ioStreamFactory;
    private final LinkManager linkManager;
    public ConnectionStateListener listener;
    private final Object portLock = new Object();
    @Nullable
    private BinaryProtocol bp;

    protected PortHolder(LinkManager linkManager, Callable<IoStream> ioStreamFactory) {
        this.linkManager = linkManager;
        this.dataListener = freshData -> linkManager.getEngineState().processNewData(new String(freshData), LinkManager.ENCODER);
        this.ioStreamFactory = ioStreamFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectAndReadConfiguration(BinaryProtocol.Arguments arguments) {
        Objects.requireNonNull(arguments);
        IoStream stream = this.ioStreamFactory.call();
        if (stream == null) {
            return;
        }
        Object object = this.portLock;
        synchronized (object) {
            this.bp = new BinaryProtocol(this.linkManager, stream);
            this.portLock.notifyAll();
        }
        String errorMessage = this.bp.connectAndReadConfiguration(arguments, this.dataListener);
        if (this.listener != null) {
            if (errorMessage == null) {
                this.listener.onConnectionEstablished();
            } else {
                this.listener.onConnectionFailed(errorMessage);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.portLock;
        synchronized (object) {
            if (this.bp != null) {
                try {
                    this.bp.close();
                    this.bp = null;
                }
                finally {
                    this.portLock.notifyAll();
                }
            }
        }
    }

    @Nullable
    public BinaryProtocol getBp() {
        return this.bp;
    }

    public void packAndSend(String command, boolean fireEvent) throws InterruptedException {
        if (this.bp == null) {
            if (GraphicsEnvironment.isHeadless()) {
                IoUtils.exit("No connectivity, will close", -1);
            } else {
                SwingUtilities.invokeLater(() -> {
                    Window[] windows = JDialog.getWindows();
                    Window window = windows.length == 0 ? null : windows[0];
                    JOptionPane.showMessageDialog(window, "No connectivity, will close", "Error", 0);
                    IoUtils.exit("No connectivity, will close", -1);
                });
            }
            return;
        }
        this.bp.doSend(command, fireEvent);
    }
}

