/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.waves;

import com.rusefi.models.Utils;
import java.util.ArrayList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;

public class RevolutionLog {
    private final TreeMap<Integer, Integer> time2rpm;

    public RevolutionLog(TreeMap<Integer, Integer> time2rpm) {
        this.time2rpm = time2rpm;
    }

    public static RevolutionLog parseRevolutions(CharSequence revolutions) {
        TreeMap<Integer, Integer> time2rpm = new TreeMap<Integer, Integer>();
        if (revolutions == null) {
            return new RevolutionLog(time2rpm);
        }
        String[] r = revolutions.toString().split("!");
        for (int i = 0; i < r.length - 1; i += 2) {
            int rpm = Utils.parseIntWithReason(r[i], "RL rpm");
            int time = Utils.parseIntWithReason(r[i + 1], "RL time");
            time2rpm.put(time, rpm);
        }
        return new RevolutionLog(time2rpm);
    }

    public int getSize() {
        return this.time2rpm.size();
    }

    public String getCrankAngleByTimeString(double time) {
        return RevolutionLog.angle2string(this.getCrankAngleByTime(time));
    }

    public static String angle2string(double angle) {
        return Double.isNaN(angle) ? "n/a" : String.format("%.1f", angle);
    }

    public double getCrankAngleByTime(double time) {
        return this.doGetAngle(time, true);
    }

    private double doGetAngle(double time, boolean tryNextRevolution) {
        Map.Entry<Integer, Integer> entry = this.getTimeAndRpm(time);
        if (entry == null) {
            if (tryNextRevolution && this.time2rpm.size() >= 2) {
                ArrayList<Map.Entry<Integer, Integer>> element = new ArrayList<Map.Entry<Integer, Integer>>(this.time2rpm.entrySet());
                Map.Entry first = (Map.Entry)element.get(0);
                Map.Entry second = (Map.Entry)element.get(1);
                int oneRevolutionDuration = (Integer)second.getKey() - (Integer)first.getKey();
                return this.doGetAngle(time + (double)oneRevolutionDuration, false);
            }
            return Double.NaN;
        }
        double diff = time - (double)entry.getKey().intValue();
        Integer rpm = entry.getValue();
        double timeForRevolution = 6000000.0 / (double)rpm.intValue();
        return 360.0 * diff / timeForRevolution;
    }

    public Map.Entry<Integer, Integer> getTimeAndRpm(double time) {
        return this.time2rpm.floorEntry((int)time);
    }

    public Set<Integer> keySet() {
        return this.time2rpm.keySet();
    }
}

