/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan;

import java.net.SocketAddress;
import java.util.Objects;
import tel.schich.javacan.CanId;
import tel.schich.javacan.IsotpAddress;

public class IsotpSocketAddress
extends SocketAddress {
    private final int id;

    private IsotpSocketAddress(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public IsotpSocketAddress returnAddress() {
        return new IsotpSocketAddress(IsotpAddress.returnAddress(this.id));
    }

    public boolean isExtended() {
        return CanId.isExtended(this.id);
    }

    public boolean isFunctional() {
        return IsotpAddress.isFunctional(this.id);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IsotpSocketAddress that = (IsotpSocketAddress)o;
        return this.id == that.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public String toString() {
        return "IsotpSocketAddress(id=" + this.id + ')';
    }

    public static IsotpSocketAddress isotpAddress(int id) {
        return new IsotpSocketAddress(id);
    }
}

