/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.autoupdate;

import com.devexperts.logging.Logging;
import com.rusefi.core.net.JarFileUtil;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.Properties;

public class ConsoleExeFileLocator {
    private static final Logging log = Logging.getLogging(ConsoleExeFileLocator.class);
    private static final String INSTALLATION_PROPERTIES_FILE_NAME = "installation.properties";
    private static final String CONSOLE_EXE_FILE_NAME_PROPERTY_NAME = "console-exe-file";

    String getConsoleExeFileName() {
        Optional<Properties> installationProperties = ConsoleExeFileLocator.loadInstallationProperties();
        if (installationProperties.isPresent()) {
            String consoleExeFileName = installationProperties.get().getProperty(CONSOLE_EXE_FILE_NAME_PROPERTY_NAME);
            if (consoleExeFileName != null) {
                return consoleExeFileName;
            }
            log.info(String.format("`%s` property is not found", CONSOLE_EXE_FILE_NAME_PROPERTY_NAME));
        } else {
            log.info(String.format("It looks like `%s` file is missed", INSTALLATION_PROPERTIES_FILE_NAME));
        }
        String defaultConsoleExeFileName = JarFileUtil.getJarFileNamePrefix() + "_console.exe";
        log.info(String.format("We are using default console exe file name: `%s`", defaultConsoleExeFileName));
        return defaultConsoleExeFileName;
    }

    private static Optional<Properties> loadInstallationProperties() {
        Optional<Properties> optional;
        block8: {
            Properties result = new Properties();
            InputStream is = Files.newInputStream(Paths.get(INSTALLATION_PROPERTIES_FILE_NAME, new String[0]), new OpenOption[0]);
            try {
                result.load(is);
                optional = Optional.of(result);
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable e) {
                    log.error(String.format("Failed to load properties from `%s` file.", INSTALLATION_PROPERTIES_FILE_NAME), e);
                    return Optional.empty();
                }
            }
            is.close();
        }
        return optional;
    }
}

