/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageMeta;
import com.opensr5.ConfigurationImageMetaVersion0_0;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.OrdinalOutOfRangeException;
import com.opensr5.io.ConfigurationImageFile;
import com.opensr5.io.DataListener;
import com.rusefi.ConfigurationImageDiff;
import com.rusefi.NamedThreadFactory;
import com.rusefi.Timeouts;
import com.rusefi.binaryprotocol.BinaryProtocolLocalCache;
import com.rusefi.binaryprotocol.BinaryProtocolLogger;
import com.rusefi.binaryprotocol.BinaryProtocolState;
import com.rusefi.binaryprotocol.IniFileProvider;
import com.rusefi.binaryprotocol.IoHelper;
import com.rusefi.binaryprotocol.MsqFactory;
import com.rusefi.binaryprotocol.RealIniFileProvider;
import com.rusefi.core.Pair;
import com.rusefi.core.SensorCentral;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.io.CommunicationLoggingListener;
import com.rusefi.io.ConnectionStatusLogic;
import com.rusefi.io.ConnectionStatusValue;
import com.rusefi.io.HeartBeatListeners;
import com.rusefi.io.IoStream;
import com.rusefi.io.LinkManager;
import com.rusefi.io.commands.BurnCommand;
import com.rusefi.io.commands.ByteRange;
import com.rusefi.io.commands.GetOutputsCommand;
import com.rusefi.io.commands.HelloCommand;
import com.rusefi.io.commands.WriteCommand;
import com.rusefi.tune.xml.Msq;
import com.rusefi.ui.livedocs.LiveDocsRegistry;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BinaryProtocol {
    private static final Logging log = Logging.getLogging(BinaryProtocol.class);
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("ECU text pull", true);
    private final LinkManager linkManager;
    private final IoStream stream;
    private boolean isBurnPending;
    public String signature;
    public boolean isGoodOutputChannels;
    private IniFileModel iniFile;
    private final BinaryProtocolState state = new BinaryProtocolState();
    private final BinaryProtocolLogger binaryProtocolLogger;
    public static IniFileProvider iniFileProvider;
    public final CommunicationLoggingListener communicationLoggingListener;

    @NotNull
    public IniFileModel getIniFile() {
        return Objects.requireNonNull(this.iniFile);
    }

    public static String findCommand(byte command) {
        switch (command) {
            case 70: {
                return "PROTOCOL";
            }
            case 107: {
                return "CRC_CHECK";
            }
            case 66: {
                return "BURN";
            }
            case 83: {
                return "HELLO";
            }
            case 82: {
                return "READ";
            }
            case 71: {
                return "TS_GET_TEXT";
            }
            case 86: {
                return "GET_FW_VERSION";
            }
            case 67: {
                return "WRITE_CHUNK";
            }
            case 79: {
                return "TS_OUTPUT_COMMAND";
            }
            case 0: {
                return "TS_RESPONSE_OK";
            }
        }
        return "command " + (char)command + "/" + command;
    }

    public IoStream getStream() {
        return this.stream;
    }

    public BinaryProtocol(LinkManager linkManager, IoStream stream) {
        this.linkManager = linkManager;
        this.stream = Objects.requireNonNull(stream);
        this.communicationLoggingListener = linkManager.messageListener::postMessage;
        this.binaryProtocolLogger = new BinaryProtocolLogger(linkManager);
        stream.addCloseListener(this.binaryProtocolLogger::close);
    }

    public boolean isClosed() {
        return this.stream.isClosed();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new IllegalStateException(e);
        }
    }

    public void doSend(final String command, boolean fireEvent) throws InterruptedException {
        log.info("Sending [" + command + "]");
        if (fireEvent && LinkManager.LOG_LEVEL.isDebugEnabled()) {
            this.communicationLoggingListener.onPortHolderMessage(BinaryProtocol.class, "Sending [" + command + "]");
        }
        Future f = this.linkManager.submit(new Runnable(){

            @Override
            public void run() {
                BinaryProtocol.this.sendTextCommand(command);
            }

            public String toString() {
                return "Runnable for " + command;
            }
        });
        try {
            f.get(10L, TimeUnit.SECONDS);
        }
        catch (ExecutionException e) {
            throw new IllegalStateException(e);
        }
        catch (TimeoutException e) {
            log.error("timeout sending [" + command + "] giving up: " + e);
            return;
        }
        this.linkManager.getCommandQueue().handleConfirmationMessage("confirmation_" + command);
    }

    @Nullable
    public static String getSignature(IoStream stream) throws IOException {
        HelloCommand.send(stream);
        return HelloCommand.getHelloResponse(stream.getDataBuffer());
    }

    public String connectAndReadConfiguration(Arguments arguments, DataListener listener) {
        try {
            this.signature = BinaryProtocol.getSignature(this.stream);
            if (this.signature == null) {
                String msg = "No signature returned by " + this.stream;
                log.info(msg);
                return msg;
            }
            log.info(this.stream + ": Got [" + this.signature + "] signature");
        }
        catch (IOException e) {
            return "Failed to read signature " + e;
        }
        this.iniFile = Objects.requireNonNull(iniFileProvider.provide(this.signature));
        int pageSize = this.iniFile.getMetaInfo().getPageSize(0);
        log.info("pageSize=" + pageSize);
        this.readImage(arguments, new ConfigurationImageMetaVersion0_0(pageSize, this.signature));
        if (this.stream.isClosed()) {
            return "Failed to read calibration";
        }
        this.startPullThread(listener);
        this.binaryProtocolLogger.start();
        return null;
    }

    private void startPullThread(final DataListener textListener) {
        if (!this.linkManager.COMMUNICATION_QUEUE.isEmpty()) {
            log.info("Current queue size: " + this.linkManager.COMMUNICATION_QUEUE.size());
        }
        Runnable textPull = new Runnable(){

            @Override
            public void run() {
                while (!BinaryProtocol.this.stream.isClosed()) {
                    if (((BinaryProtocol)BinaryProtocol.this).linkManager.COMMUNICATION_QUEUE.isEmpty() && BinaryProtocol.this.linkManager.getNeedPullData()) {
                        BinaryProtocol.this.linkManager.submit(new Runnable(){

                            @Override
                            public void run() {
                                String text;
                                BinaryProtocol.this.isGoodOutputChannels = BinaryProtocol.this.requestOutputChannels();
                                log.debug("requestOutputChannels " + BinaryProtocol.this.isGoodOutputChannels);
                                if (BinaryProtocol.this.isGoodOutputChannels) {
                                    HeartBeatListeners.onDataArrived();
                                }
                                BinaryProtocol.this.binaryProtocolLogger.compositeLogic(BinaryProtocol.this);
                                if (BinaryProtocol.this.linkManager.isNeedPullText() && (text = BinaryProtocol.this.requestPendingTextMessages()) != null) {
                                    textListener.onDataArrived((text + "\r\n").getBytes());
                                    log.debug("textListener");
                                }
                                if (BinaryProtocol.this.linkManager.isNeedPullLiveData()) {
                                    LiveDocsRegistry.LiveDataProvider liveDataProvider = LiveDocsRegistry.getLiveDataProvider();
                                    LiveDocsRegistry.INSTANCE.refresh(liveDataProvider);
                                    log.info(BinaryProtocol.this.stream + ": Got livedata");
                                }
                            }
                        });
                    }
                    BinaryProtocol.sleep(100L);
                }
                log.info("Port shutdown: Stopping text pull");
            }
        };
        Thread tr = THREAD_FACTORY.newThread(textPull);
        tr.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void dropPending(IoStream stream) {
        Object object = stream.getIoLock();
        synchronized (object) {
            if (stream.isClosed()) {
                return;
            }
            stream.getDataBuffer().dropPending();
        }
    }

    public void uploadChanges(ConfigurationImage newVersion) {
        Pair<Integer, Integer> range;
        ConfigurationImage current = this.getControllerConfiguration();
        newVersion = newVersion.clone();
        int offset = 0;
        while (offset < current.getSize() && (range = ConfigurationImageDiff.findDifferences(current, newVersion, offset)) != null) {
            int size = (Integer)range.second - (Integer)range.first;
            log.info("Need to patch: " + range + ", size=" + size);
            byte[] oldBytes = current.getRange((Integer)range.first, size);
            log.info("old " + Arrays.toString(oldBytes));
            byte[] newBytes = newVersion.getRange((Integer)range.first, size);
            log.info("new " + Arrays.toString(newBytes));
            this.writeData(newVersion.getContent(), (Integer)range.first, (Integer)range.first, size);
            offset = (Integer)range.second;
        }
        this.burn();
        this.setConfigurationImage(newVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static byte[] receivePacket(String msg, IoStream stream) throws IOException {
        long start = System.currentTimeMillis();
        Object object = stream.getIoLock();
        synchronized (object) {
            return stream.getDataBuffer().getPacket(Timeouts.BINARY_IO_TIMEOUT, msg, start);
        }
    }

    public void readImage(Arguments arguments, ConfigurationImageMeta meta) {
        ConfigurationImageWithMeta image = BinaryProtocolLocalCache.getAndValidateLocallyCached(this);
        if (image.isEmpty() && (image = this.readFullImageFromController(arguments, meta)).isEmpty()) {
            return;
        }
        this.setConfigurationImage(image.getConfigurationImage());
        log.info(this.stream + ": Got configuration from controller " + meta.getImageSize() + " byte(s)");
        ConnectionStatusLogic.INSTANCE.setValue(ConnectionStatusValue.CONNECTED);
    }

    @NotNull
    public ConfigurationImageWithMeta readFullImageFromController(ConfigurationImageMeta meta) {
        log.info("Reading from controller " + meta.getEcuSignature());
        ConfigurationImageWithMeta imageWithMeta = new ConfigurationImageWithMeta(meta);
        ConfigurationImage image = imageWithMeta.getConfigurationImage();
        int offset = 0;
        long start = System.currentTimeMillis();
        while (offset < image.getSize() && System.currentTimeMillis() - start < 60000L) {
            byte[] packet;
            if (this.stream.isClosed()) {
                return ConfigurationImageWithMeta.VOID;
            }
            int remainingSize = image.getSize() - offset;
            int requestSize = Math.min(remainingSize, this.iniFile.getBlockingFactor());
            String pageReadCommand = this.iniFile.getMetaInfo().getPageReadCommand(0);
            if (pageReadCommand.length() == 7) {
                packet = new byte[4];
                ByteRange.packOffsetAndSize(offset, requestSize, packet);
            } else {
                packet = new byte[6];
                ByteRange.packPageOffsetAndSize(offset, requestSize, packet);
            }
            byte[] response = this.executeCommand('R', packet, "load image offset=" + offset);
            if (!IoHelper.checkResponseCode(response) || response.length != requestSize + 1) {
                if (BinaryProtocol.extractCode(response) == 132) {
                    throw new IllegalStateException("TS_RESPONSE_OUT_OF_RANGE ECU/console version mismatch? " + offset + "/" + requestSize);
                }
                String code = response == null || response.length == 0 ? "empty" : "ERROR_CODE=" + BinaryProtocol.getCode(response);
                String info = response == null ? "NO RESPONSE" : code + " length=" + response.length;
                log.info(this.stream + ": readImage: ERROR UNEXPECTED Something is wrong, retrying... " + info);
                continue;
            }
            HeartBeatListeners.onDataArrived();
            ConnectionStatusLogic.INSTANCE.markConnected();
            System.arraycopy(response, 1, image.getContent(), offset, requestSize);
            offset += requestSize;
        }
        return imageWithMeta;
    }

    @NotNull
    private ConfigurationImageWithMeta readFullImageFromController(Arguments arguments, ConfigurationImageMeta meta) {
        Objects.requireNonNull(arguments);
        ConfigurationImageWithMeta imageWithMeta = this.readFullImageFromController(meta);
        if (arguments.saveFile) {
            try {
                BinaryProtocol.saveConfigurationImageToFiles(imageWithMeta, this.iniFile, ConnectionAndMeta.saveSettingsToFile() ? "state/current_configuration.zip" : null, "state/current_configuration.msq");
            }
            catch (JAXBException e) {
                log.error("JAXBException", e);
            }
            catch (IOException e) {
                log.info("Ignoring " + e, e);
            }
            catch (Exception e) {
                log.error("Unexpected exception:" + e, e);
                throw e;
            }
        }
        return imageWithMeta;
    }

    public static void saveConfigurationImageToFiles(ConfigurationImageWithMeta imageWithMeta, IniFileModel ini, @Nullable String binaryFileName, @Nullable String xmlFileName) throws JAXBException, IOException {
        if (binaryFileName != null) {
            ConfigurationImageFile.saveToFile(imageWithMeta, binaryFileName);
        }
        if (xmlFileName != null) {
            BinaryProtocol.saveXmlFile(imageWithMeta, ini, xmlFileName);
        }
    }

    public static void saveXmlFile(ConfigurationImageWithMeta imageWithMeta, IniFileModel ini, @NotNull String xmlFileName) throws JAXBException, IOException {
        ConfigurationImage image = imageWithMeta.getConfigurationImage();
        if (image == null) {
            log.warn("No image for saveConfigurationImageToFiles");
            return;
        }
        try {
            Msq tune = MsqFactory.valueOf(image, ini);
            tune.writeXmlFile(xmlFileName);
        }
        catch (OrdinalOutOfRangeException e) {
            log.warn("Unexpected " + e, e);
        }
    }

    private static String getCode(byte[] response) {
        int b = BinaryProtocol.extractCode(response);
        switch (b) {
            case 130: {
                return "CRC_FAILURE";
            }
            case 131: {
                return "UNRECOGNIZED_COMMAND";
            }
            case 132: {
                return "OUT_OF_RANGE";
            }
            case 141: {
                return "FRAMING_ERROR";
            }
            case 128: {
                return "TS_RESPONSE_UNDERRUN";
            }
        }
        return Integer.toString(b);
    }

    private static int extractCode(byte[] response) {
        if (response == null || response.length < 1) {
            return -1;
        }
        return response[0] & 0xFF;
    }

    public int getCrcFromController(int configSize) {
        byte[] packet = BinaryProtocol.createRequestCrcPayload(configSize);
        byte[] response = this.executeCommand('k', packet, "get CRC32");
        if (IoHelper.checkResponseCode(response) && response.length == 5) {
            ByteBuffer bb = ByteBuffer.wrap(response, 1, 4);
            bb.order(ByteOrder.BIG_ENDIAN);
            int crc32FromController = bb.getInt();
            short crc16FromController = (short)crc32FromController;
            log.info(String.format("rusEFI says tune CRC32 0x%x %d\n", crc32FromController, crc32FromController));
            log.info(String.format("rusEFI says tune CRC16 0x%x %d\n", crc16FromController, crc16FromController));
            return crc32FromController;
        }
        return -1;
    }

    private static byte[] createRequestCrcPayload(int size) {
        byte[] packet = new byte[6];
        ByteRange.packPageOffsetAndSize(0, size, packet);
        return packet;
    }

    public byte[] executeCommand(char opcode, String msg) {
        return this.executeCommand(opcode, null, msg);
    }

    public byte[] executeCommand(char opcode, byte[] packet, String msg) {
        this.linkManager.assertCommunicationThread();
        return BinaryProtocol.doExecute(opcode, packet, msg, this.stream);
    }

    private static byte @Nullable [] doExecute(char opcode, byte[] packet, String msg, IoStream stream) {
        if (stream.isClosed()) {
            return null;
        }
        byte[] fullRequest = BinaryProtocol.getFullRequest((byte)opcode, packet);
        try {
            BinaryProtocol.dropPending(stream);
            stream.sendPacket(fullRequest);
            return BinaryProtocol.receivePacket(msg, stream);
        }
        catch (IOException e) {
            log.error(msg + ": executeCommand failed: " + e);
            stream.close();
            return null;
        }
    }

    @NotNull
    public static byte[] getFullRequest(byte opcode, byte[] packet) {
        byte[] fullRequest;
        if (packet != null) {
            fullRequest = new byte[packet.length + 1];
            System.arraycopy(packet, 0, fullRequest, 1, packet.length);
        } else {
            fullRequest = new byte[]{opcode};
        }
        return fullRequest;
    }

    public void close() {
        this.stream.close();
    }

    public void writeData(byte[] content, int contentOffset, int ecuOffset, int size) {
        byte[] response;
        this.isBurnPending = true;
        byte[] packet = WriteCommand.getWritePacket(content, contentOffset, ecuOffset, size);
        long start = System.currentTimeMillis();
        while (!(this.stream.isClosed() || System.currentTimeMillis() - start >= (long)Timeouts.BINARY_IO_TIMEOUT || IoHelper.checkResponseCode(response = this.executeCommand('C', packet, "writeImage")) && response.length == 1)) {
            if (response == null) {
                log.error("writeData: null response Something is wrong, retrying...");
                continue;
            }
            if (response.length == 0) {
                log.error("writeData: empty response Something is wrong, retrying...");
                continue;
            }
            log.error("writeData: Something is wrong, retrying... code = " + response[0]);
        }
    }

    public void burn() {
        if (!this.isBurnPending) {
            return;
        }
        log.info("Need to burn");
        while (true) {
            if (this.stream.isClosed()) {
                return;
            }
            boolean isGoodBurn = BurnCommand.execute(this);
            if (isGoodBurn) break;
            log.warn("BURN HAS FAILED?! Will retry");
        }
        log.info("BURN OK");
        log.info("DONE");
        this.isBurnPending = false;
    }

    public void setConfigurationImage(ConfigurationImage configurationImage) {
        this.state.setConfigurationImage(configurationImage);
    }

    public ConfigurationImage getControllerConfiguration() {
        return this.state.getConfigurationImage();
    }

    private boolean sendTextCommand(String text) {
        byte[] command = BinaryProtocol.getTextCommandBytesOnlyText(text);
        long start = System.currentTimeMillis();
        while (!this.stream.isClosed() && System.currentTimeMillis() - start < (long)Timeouts.BINARY_IO_TIMEOUT) {
            byte[] response = this.executeCommand('E', command, "execute");
            if (!IoHelper.checkResponseCode(response, (byte)0) || response.length != 1) continue;
            return false;
        }
        return true;
    }

    public static byte[] getTextCommandBytes(String text) {
        byte[] asBytes = text.getBytes();
        byte[] command = new byte[asBytes.length + 1];
        command[0] = 69;
        System.arraycopy(asBytes, 0, command, 1, asBytes.length);
        return command;
    }

    public static byte[] getTextCommandBytesOnlyText(String text) {
        return text.getBytes();
    }

    public String requestPendingTextMessages() {
        if (this.stream.isClosed()) {
            return null;
        }
        try {
            byte[] response = this.executeCommand('G', "text");
            if (response == null) {
                log.error("ERROR: TS_GET_TEXT failed");
                return null;
            }
            if (response != null && response.length == 1) {
                Thread.sleep(100L);
            }
            return new String(response, 1, response.length - 1);
        }
        catch (InterruptedException e) {
            log.error(e.toString());
            return null;
        }
    }

    public boolean requestOutputChannels() {
        int chunkSize;
        if (this.stream.isClosed()) {
            return false;
        }
        int ochBlockSize = this.iniFile.getMetaInfo().getOchBlockSize();
        byte[] reassemblyBuffer = new byte[ochBlockSize + 1];
        reassemblyBuffer[0] = 0;
        int reassemblyIdx = 0;
        for (int remaining = ochBlockSize; remaining > 0; remaining -= chunkSize) {
            chunkSize = Math.min(remaining, this.iniFile.getBlockingFactor());
            byte[] response = this.executeCommand('O', GetOutputsCommand.createRequest(reassemblyIdx, chunkSize), "output channels");
            if (response == null || response.length != chunkSize + 1 || response[0] != 0) {
                return false;
            }
            System.arraycopy(response, 1, reassemblyBuffer, reassemblyIdx + 1, chunkSize);
            reassemblyIdx += chunkSize;
        }
        this.state.setCurrentOutputs(reassemblyBuffer);
        SensorCentral.getInstance().grabSensorValues(reassemblyBuffer, this.getIniFile());
        return true;
    }

    public BinaryProtocolState getBinaryProtocolState() {
        return this.state;
    }

    static {
        log.info("BINARY_IO_TIMEOUT=" + Timeouts.BINARY_IO_TIMEOUT);
        log.info("CONNECTION_RESTART_DELAY=" + Timeouts.CONNECTION_RESTART_DELAY);
        iniFileProvider = new RealIniFileProvider();
    }

    public static class Arguments {
        final boolean saveFile;

        public Arguments(boolean saveFile) {
            this.saveFile = saveFile;
        }
    }
}

