/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.IniField;
import com.rusefi.CompatibilitySet;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.DefaultIniFieldMigrator;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public enum DefaultTuneMigrator implements TuneMigrator
{
    INSTANCE;

    private static final Logging log;
    private static final Set<String> INI_FIELDS_TO_IGNORE;
    private static final Set<String> boardSpecificIniFieldsToIgnore;

    @Override
    public void migrateTune(TuneMigrationContext context) {
        IniFileModel prevIni = context.getPrevIniFile();
        Map<String, Constant> prevValues = context.getPrevTune().getConstantsAsMap();
        IniFileModel newIni = context.getUpdatedIniFile();
        Map<String, Constant> newValues = context.getUpdatedTune().getConstantsAsMap();
        UpdateOperationCallbacks callbacks = context.getCallbacks();
        Map<String, IniField> prevIniFields = prevIni.getAllIniFields();
        Map<String, IniField> newIniFields = newIni.getAllIniFields();
        for (Map.Entry<String, IniField> prevFieldEntry : prevIniFields.entrySet()) {
            String prevFieldName = prevFieldEntry.getKey();
            if (INI_FIELDS_TO_IGNORE.contains(prevFieldName) || boardSpecificIniFieldsToIgnore.contains(prevFieldName) || DefaultTuneMigrator.isUnusedField(prevFieldName) || context.isFieldAlreadyMigrated(prevFieldName) || context.getMigratedConstants().containsKey(prevFieldEntry)) continue;
            IniField newField = newIniFields.get(prevFieldName);
            Constant prevValue = prevValues.get(prevFieldName);
            if (newField != null) {
                Constant newValue = newValues.get(prevFieldName);
                if (prevValue == null) continue;
                if (newValue == null) {
                    log.info(String.format("Field `%s` is going to be restored: <none> -> `%s`", prevFieldName, prevValue.getValue()));
                    context.addMigration(prevFieldName, prevValue);
                    continue;
                }
                if (Objects.equals(prevValue.getValue(), newValue.getValue())) continue;
                if (!Objects.equals(prevValue.getName(), newValue.getName())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its name is updated: `%s` -> `%s`", prevFieldName, prevValue.getName(), newValue.getName()));
                    continue;
                }
                if (!Objects.equals(prevValue.getUnits(), newValue.getUnits())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its units are updated: `%s` -> `%s`", prevFieldName, prevValue.getUnits(), newValue.getUnits()));
                    continue;
                }
                if (!Objects.equals(prevValue.getDigits(), newValue.getDigits())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its digits are updated: `%s` -> `%s`", prevFieldName, prevValue.getDigits(), newValue.getDigits()));
                    continue;
                }
                if (!Objects.equals(prevValue.getCols(), newValue.getCols())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its column count is updated: `%s` -> `%s`", prevFieldName, prevValue.getCols(), newValue.getCols()));
                    continue;
                }
                if (!Objects.equals(prevValue.getRows(), newValue.getRows())) {
                    callbacks.logLine(String.format("WARNING! Field `%s` cannot be updated because its row count is updated: `%s` -> `%s`", prevFieldName, prevValue.getRows(), newValue.getRows()));
                    continue;
                }
                Optional<String> migratedValue = DefaultIniFieldMigrator.INSTANCE.tryMigrateValue(prevFieldEntry.getValue(), newField, prevValue.getValue(), callbacks);
                if (migratedValue.isPresent()) {
                    String valueToRestore = migratedValue.get();
                    if (!valueToRestore.equals(newValue.getValue())) {
                        log.info(String.format("Field `%s` is going to be restored: `%s` -> `%s`", prevFieldName, newValue.getValue(), prevValue.getValue()));
                        context.addMigration(prevFieldName, newValue.cloneWithValue(valueToRestore));
                        continue;
                    }
                    callbacks.logLine(String.format("We aren't going to restore field `%s`: it looks like its value is just renamed: `%s` -> `%s`", prevFieldName, prevValue.getValue(), newValue.getValue()));
                    continue;
                }
                log.warn(String.format("Field `%s` cannot be updated: `%s` -> `%s`", prevFieldName, prevFieldEntry.getValue(), newField));
                continue;
            }
            if (prevValue == null) continue;
            callbacks.logLine(String.format("We aren't going to restore field `%s`: it is missed in new .ini file", prevFieldName));
        }
    }

    private static boolean isUnusedField(String fieldName) {
        return fieldName.startsWith("unused");
    }

    static {
        log = Logging.getLogging(DefaultTuneMigrator.class);
        INI_FIELDS_TO_IGNORE = CompatibilitySet.of("byFirmwareVersion");
        boardSpecificIniFieldsToIgnore = ConnectionAndMeta.getNonMigratableIniFields();
    }
}

