/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageMetaVersion0_0;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniFileModelImpl;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.CalibrationsInfo;
import com.rusefi.maintenance.TestCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.tune.xml.Constant;
import com.rusefi.tune.xml.Msq;
import javax.xml.bind.JAXBException;

public class TestTuneMigrationContext
extends TuneMigrationContext {
    public static TestTuneMigrationContext load(String testDataFolder) throws JAXBException {
        TestTuneMigrationContext result = new TestTuneMigrationContext(Msq.readTune(String.format("%s/prev_calibrations.msq", testDataFolder)), IniFileModelImpl.readIniFile(String.format("%s/prev_calibrations.ini", testDataFolder)), Msq.readTune(String.format("%s/updated_calibrations.msq", testDataFolder)), IniFileModelImpl.readIniFile(String.format("%s/updated_calibrations.ini", testDataFolder)), (UpdateOperationCallbacks)new TestCallbacks());
        return result;
    }

    public TestCallbacks getTestCallbacks() {
        return (TestCallbacks)this.getCallbacks();
    }

    public CalibrationsInfo getPrevCalibrationsInfo() {
        return TestTuneMigrationContext.getCalibrationsInfo(this.getPrevTune(), this.getPrevIniFile());
    }

    public CalibrationsInfo getUpdatedCalibrationsInfo() {
        return TestTuneMigrationContext.getCalibrationsInfo(this.getUpdatedTune(), this.getUpdatedIniFile());
    }

    public Constant getPrevValue(String fieldName) {
        return this.getValue(this.getPrevTune(), fieldName);
    }

    public Constant getUpdatedValue(String fieldName) {
        return this.getValue(this.getUpdatedTune(), fieldName);
    }

    private static CalibrationsInfo getCalibrationsInfo(Msq msq, IniFileModel ini) {
        ConfigurationImage image = msq.asImage(ini);
        ConfigurationImageMetaVersion0_0 meta = new ConfigurationImageMetaVersion0_0(image.getSize(), ini.getSignature());
        ConfigurationImageWithMeta imageWithMeta = new ConfigurationImageWithMeta(meta, image.getContent());
        return new CalibrationsInfo(ini, imageWithMeta);
    }

    private Constant getValue(Msq msq, String fieldName) {
        return msq.getConstantsAsMap().get(fieldName);
    }

    public TestTuneMigrationContext(Msq prevMsq, IniFileModel prevIni, Msq updatedMsq, IniFileModel updatedIni, UpdateOperationCallbacks callbacks) {
        super(prevIni, prevMsq, updatedIni, updatedMsq, callbacks);
    }
}

