/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration;

import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.config.FieldType;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Map;
import java.util.Optional;

public enum CltIdleCorrMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String MAN_IDLE_POSITION_FIELD_NAME = "manIdlePosition";
    public static final String CLT_IDLE_CORR_BINS_FIELD_NAME = "cltIdleCorrBins";
    public static final String CLT_IDLE_CORR_FIELD_NAME = "cltIdleCorr";
    public static final String OVERRIDE_CRANKING_IAC_SETTING_FIELD_NAME = "overrideCrankingIacSetting";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        CltIdleCorrMigrator.checkIfOverrideCrankingIacSettingHasDisappeared(context);
        IniFileModel updatedIniFile = context.getUpdatedIniFile();
        if (!updatedIniFile.findIniField(MAN_IDLE_POSITION_FIELD_NAME).isPresent()) {
            Map<String, Constant> prevTune = context.getPrevTune().getConstantsAsMap();
            Constant prevManIdlePositionValue = prevTune.get(MAN_IDLE_POSITION_FIELD_NAME);
            if (prevManIdlePositionValue == null) {
                return;
            }
            Constant prevCltIdleCorrValue = prevTune.get(CLT_IDLE_CORR_FIELD_NAME);
            if (prevCltIdleCorrValue == null) {
                return;
            }
            IniFileModel prevIniFile = context.getPrevIniFile();
            Optional<IniField> prevCltIdleCorrIniField = prevIniFile.findIniField(CLT_IDLE_CORR_FIELD_NAME);
            if (!prevCltIdleCorrIniField.isPresent()) {
                return;
            }
            Optional<ArrayIniField> prevCltIdleCorrArrayIniField = CltIdleCorrMigrator.getValidatedCltIdleCorrIniField(prevCltIdleCorrIniField.get(), context.getCallbacks());
            if (!prevCltIdleCorrArrayIniField.isPresent()) {
                return;
            }
            Optional<IniField> updatedCltIdleCorrIniField = updatedIniFile.findIniField(CLT_IDLE_CORR_FIELD_NAME);
            if (!updatedCltIdleCorrIniField.isPresent()) {
                return;
            }
            Optional<ArrayIniField> updatedCltIdleCorrArrayIniField = CltIdleCorrMigrator.getValidatedCltIdleCorrIniField(updatedCltIdleCorrIniField.get(), context.getCallbacks());
            if (!updatedCltIdleCorrArrayIniField.isPresent()) {
                return;
            }
            Optional<IniField> prevManIdlePositionIniField = prevIniFile.findIniField(MAN_IDLE_POSITION_FIELD_NAME);
            if (!prevManIdlePositionIniField.isPresent()) {
                return;
            }
            Optional<ScalarIniField> prevManIdlePositionScalarIniField = CltIdleCorrMigrator.getValidatedManIdlePositionIniField(prevManIdlePositionIniField.get(), context.getCallbacks());
            if (!prevManIdlePositionScalarIniField.isPresent()) {
                return;
            }
            String[][] prevValues = prevCltIdleCorrArrayIniField.get().getValues(prevCltIdleCorrValue.getValue());
            String[][] migratedValues = CltIdleCorrMigrator.migrateCltIdleCorrValue(prevManIdlePositionValue.getValue(), prevValues);
            ArrayIniField updatedCltIdleCorrField = updatedCltIdleCorrArrayIniField.get();
            context.addMigration(CLT_IDLE_CORR_FIELD_NAME, new Constant(CLT_IDLE_CORR_FIELD_NAME, updatedCltIdleCorrField.getUnits(), updatedCltIdleCorrField.formatValue(migratedValues), updatedCltIdleCorrField.getDigits(), Integer.toString(updatedCltIdleCorrField.getRows()), Integer.toString(updatedCltIdleCorrField.getCols())));
            context.addMigration(MAN_IDLE_POSITION_FIELD_NAME, null);
        }
    }

    private static String[][] migrateCltIdleCorrValue(String prevManIdlePositionValue, String[][] prevCltIdleCorrValues) {
        String[][] result = new String[prevCltIdleCorrValues.length][];
        double manIdlePositionRatio = Double.parseDouble(prevManIdlePositionValue);
        for (int row = 0; row < prevCltIdleCorrValues.length; ++row) {
            String[] prevCltIdleCorrRow = prevCltIdleCorrValues[row];
            String[] updatedCltIdleCorrRow = new String[prevCltIdleCorrRow.length];
            for (int column = 0; column < prevCltIdleCorrRow.length; ++column) {
                double value = Double.parseDouble(prevCltIdleCorrValues[row][column]);
                updatedCltIdleCorrRow[column] = Double.toString(manIdlePositionRatio * value);
            }
            result[row] = updatedCltIdleCorrRow;
        }
        return result;
    }

    private static Optional<ScalarIniField> getValidatedManIdlePositionIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ScalarIniField)) {
            callbacks.logLine(String.format("WARNING! `manIdlePosition` ini-field is expected to be `ScalarIniField` instead of `%s`", field.getClass().getName()));
            return Optional.empty();
        }
        ScalarIniField arrayField = (ScalarIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.FLOAT) {
            callbacks.logLine(String.format("WARNING! `manIdlePosition` ini-field is expected to be `FLOAT` instead of `%s`", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static Optional<ArrayIniField> getValidatedCltIdleCorrIniField(IniField field, UpdateOperationCallbacks callbacks) {
        if (!(field instanceof ArrayIniField)) {
            callbacks.logLine(String.format("WARNING! `cltIdleCorr` ini-field is expected to be `ArrayIniField` instead of `%s`", field.getClass().getName()));
            return Optional.empty();
        }
        ArrayIniField arrayField = (ArrayIniField)field;
        FieldType arrayFieldType = arrayField.getType();
        if (arrayFieldType != FieldType.FLOAT) {
            callbacks.logLine(String.format("WARNING! `cltIdleCorr` ini-field is expected to be `FLOAT` instead of `%s`", new Object[]{arrayFieldType}));
            return Optional.empty();
        }
        int arrayFieldRows = arrayField.getRows();
        if (arrayFieldRows != 16) {
            callbacks.logLine(String.format("WARNING! `cltIdleCorr` ini-field is expected to contain 16 rows instead of %d", arrayFieldRows));
            return Optional.empty();
        }
        int arrayFieldCols = arrayField.getCols();
        if (arrayFieldCols != 1) {
            callbacks.logLine(String.format("WARNING! `cltIdleCorr` ini-field is expected to contain 1 cols instead of %d", arrayFieldCols));
            return Optional.empty();
        }
        return Optional.of(arrayField);
    }

    private static void checkIfOverrideCrankingIacSettingHasDisappeared(TuneMigrationContext context) {
        Map<String, Constant> prevTune;
        Constant prevOverrideCrankingIacSettingConst;
        IniFileModel prevIniFile = context.getPrevIniFile();
        IniFileModel updatedIniFile = context.getUpdatedIniFile();
        if (prevIniFile.findIniField(OVERRIDE_CRANKING_IAC_SETTING_FIELD_NAME).isPresent() && !updatedIniFile.findIniField(OVERRIDE_CRANKING_IAC_SETTING_FIELD_NAME).isPresent() && (prevOverrideCrankingIacSettingConst = (prevTune = context.getPrevTune().getConstantsAsMap()).get(OVERRIDE_CRANKING_IAC_SETTING_FIELD_NAME)) != null) {
            String prevOverrideCrankingIacSettingValue = prevOverrideCrankingIacSettingConst.getValue();
            if (!"\"true\"".equals(prevOverrideCrankingIacSettingValue)) {
                context.getCallbacks().logLine(String.format("WARNING! `%s` ini-field with value `%s` cannot be migrated.", OVERRIDE_CRANKING_IAC_SETTING_FIELD_NAME, prevOverrideCrankingIacSettingValue));
            }
            context.addMigration(OVERRIDE_CRANKING_IAC_SETTING_FIELD_NAME, null);
        }
    }
}

