/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.output;

import com.devexperts.logging.Logging;
import com.rusefi.ReaderState;
import com.rusefi.ToolUtil;
import com.rusefi.VariableRegistry;
import com.rusefi.output.BaseCHeaderConsumer;
import com.rusefi.util.LazyFile;
import com.rusefi.util.LazyFileImpl;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class CHeaderConsumer
extends BaseCHeaderConsumer {
    private static final Logging log = Logging.getLogging(CHeaderConsumer.class);
    @NotNull
    private final ReaderState state;
    private final boolean withC_Defines;
    private final LazyFile cHeader;
    private final VariableRegistry variableRegistry;

    public CHeaderConsumer(ReaderState state, String destCHeader, boolean withC_Defines, LazyFile.LazyFileFactory fileFactory) {
        this.variableRegistry = state.getVariableRegistry();
        this.state = state;
        this.withC_Defines = withC_Defines;
        log.info("Writing C header to " + destCHeader);
        this.cHeader = fileFactory.create(destCHeader);
    }

    public static void writeDefinesToFile(VariableRegistry variableRegistry, String fileName, String headerComment) throws IOException {
        log.info("Writing to " + fileName);
        LazyFileImpl cHeader = new LazyFileImpl(fileName);
        cHeader.write("//\n// " + CHeaderConsumer.class.getSimpleName() + " " + ToolUtil.getGeneratedAutomaticallyTag() + headerComment + "\n//\n\n");
        cHeader.write(variableRegistry.getDefinesSection());
        cHeader.close();
    }

    @Override
    public void startFile() {
        this.cHeader.write("// this section " + this.state.getHeader() + "\n");
        this.cHeader.write("// by " + this.getClass() + "\n");
        this.cHeader.write("// begin\n");
        this.cHeader.write("#pragma once\n");
        this.cHeader.write("#include \"rusefi_types.h\"\n");
    }

    @Override
    public void endFile() throws IOException {
        if (this.withC_Defines) {
            this.cHeader.write(this.variableRegistry.getDefinesSection());
        }
        this.cHeader.write(this.getContent());
        this.cHeader.write("// end\n");
        this.cHeader.write("// this section " + this.state.getHeader() + "\n");
        this.cHeader.close();
    }
}

