/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.ui.ChartScrollControl;
import java.util.ArrayList;
import java.util.List;

public class ChartRepository {
    private static final ChartRepository instance = new ChartRepository();
    private final List<String> charts = new ArrayList<String>();

    private ChartRepository() {
    }

    public static ChartRepository getInstance() {
        return instance;
    }

    public String getChart(int index) {
        if (index < 0 || index >= this.charts.size()) {
            throw new IllegalArgumentException("No chart by index " + index);
        }
        return this.charts.get(index);
    }

    public int getSize() {
        return this.charts.size();
    }

    public void addChart(String value) {
        this.charts.add(value);
    }

    public void clear() {
        this.charts.clear();
    }

    public ChartScrollControl createControls(ChartRepositoryListener listener) {
        return new ChartScrollControl(listener);
    }

    public static interface ChartRepositoryListener {
        public void onDigitalChart(String var1);
    }
}

