/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.GradientWrapper;
import java.awt.Color;
import java.awt.Paint;
import java.awt.PaintContext;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.util.HashMap;
import java.util.Map;

public class EllipticGradientPaint
implements Paint {
    private final Point2D CENTER;
    private final Point2D RADIUS_X_Y;
    private final float[] FRACTIONS;
    private final Color[] COLORS;
    private final GradientWrapper COLOR_LOOKUP;

    public EllipticGradientPaint(Point2D GIVEN_CENTER, Point2D GIVEN_RADIUS_X_Y, float[] GIVEN_FRACTIONS, Color[] GIVEN_COLORS) {
        if (GIVEN_RADIUS_X_Y.distance(0.0, 0.0) <= 0.0) {
            throw new IllegalArgumentException("Radius must be greater than 0.");
        }
        if (GIVEN_FRACTIONS.length != GIVEN_COLORS.length) {
            throw new IllegalArgumentException("Fractions and colors must be equal in size");
        }
        this.CENTER = GIVEN_CENTER;
        this.RADIUS_X_Y = GIVEN_RADIUS_X_Y;
        this.FRACTIONS = (float[])GIVEN_FRACTIONS.clone();
        this.COLORS = (Color[])GIVEN_COLORS.clone();
        this.COLOR_LOOKUP = new GradientWrapper(new Point2D.Double(0.0, 0.0), new Point2D.Double(100.0, 0.0), this.FRACTIONS, this.COLORS);
    }

    @Override
    public PaintContext createContext(ColorModel COLOR_MODEL, Rectangle DEVICE_BOUNDS, Rectangle2D USER_BOUNDS, AffineTransform TRANSFORM, RenderingHints RENDERING_HINTS) {
        Point2D TRANSFORMED_CENTER = TRANSFORM.transform(this.CENTER, null);
        Point2D TRANSFORMED_RADIUS_XY = TRANSFORM.deltaTransform(this.RADIUS_X_Y, null);
        return new OvalGradientContext(TRANSFORMED_CENTER, TRANSFORMED_RADIUS_XY, this.FRACTIONS, this.COLORS);
    }

    @Override
    public int getTransparency() {
        return 3;
    }

    private final class OvalGradientContext
    implements PaintContext {
        private final Point2D CENTER;
        private final Ellipse2D.Double ELLIPSE;
        private final Line2D.Double LINE;
        private Map<Double, Double> lookup;
        private double R;

        public OvalGradientContext(Point2D CENTER, Point2D RADIUS_X_Y, float[] FRACTIONS, Color[] COLORS) {
            this.CENTER = CENTER;
            double X = CENTER.getX() - RADIUS_X_Y.getX();
            double Y = CENTER.getY() - RADIUS_X_Y.getY();
            double WIDTH = 2.0 * RADIUS_X_Y.getX();
            double HEIGHT = 2.0 * RADIUS_X_Y.getY();
            this.ELLIPSE = new Ellipse2D.Double(X, Y, WIDTH, HEIGHT);
            this.LINE = new Line2D.Double();
            this.R = Point2D.distance(0.0, 0.0, RADIUS_X_Y.getX(), RADIUS_X_Y.getY());
            this.initLookup();
        }

        @Override
        public void dispose() {
        }

        @Override
        public ColorModel getColorModel() {
            return ColorModel.getRGBdefault();
        }

        @Override
        public Raster getRaster(int X, int Y, int TILE_WIDTH, int TILE_HEIGHT) {
            WritableRaster RASTER = this.getColorModel().createCompatibleWritableRaster(TILE_WIDTH, TILE_HEIGHT);
            int[] data = new int[TILE_WIDTH * TILE_HEIGHT * 4];
            for (int tileY = 0; tileY < TILE_HEIGHT; ++tileY) {
                for (int tileX = 0; tileX < TILE_WIDTH; ++tileX) {
                    double dx;
                    double dy;
                    double alpha;
                    double roundDegrees;
                    double radius;
                    double distance = this.CENTER.distance(X + tileX, Y + tileY);
                    float ratio = (float)(distance / (radius = this.lookup.get(roundDegrees = (double)Math.round(Math.toDegrees(alpha = Math.atan2(dy = (double)(Y + tileY) - this.CENTER.getY(), dx = (double)(X + tileX) - this.CENTER.getX())))).doubleValue()));
                    if (Float.compare(ratio, 1.0f) > 0) {
                        ratio = 1.0f;
                    }
                    int BASE = (tileY * TILE_WIDTH + tileX) * 4;
                    data[BASE + 0] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(ratio).getRed();
                    data[BASE + 1] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(ratio).getGreen();
                    data[BASE + 2] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(ratio).getBlue();
                    data[BASE + 3] = EllipticGradientPaint.this.COLOR_LOOKUP.getColorAt(ratio).getAlpha();
                }
            }
            RASTER.setPixels(0, 0, TILE_WIDTH, TILE_HEIGHT, data);
            return RASTER;
        }

        private void initLookup() {
            this.lookup = new HashMap<Double, Double>(360);
            for (int angle = -180; angle <= 180; ++angle) {
                Double key = angle;
                double alpha = Math.toRadians(angle);
                double xp = this.CENTER.getX() + this.R * Math.cos(alpha);
                double yp = this.CENTER.getY() + this.R * Math.sin(alpha);
                this.LINE.setLine(this.CENTER.getX(), this.CENTER.getY(), xp, yp);
                Double value = this.getRadius();
                this.lookup.put(key, value);
            }
            this.lookup.put(0.0, this.getRadius());
        }

        private double getRadius() {
            double[] COORDINATES = new double[6];
            Point2D.Double P = new Point2D.Double();
            double minDistance = Double.MAX_VALUE;
            double FLATNESS = 0.005;
            PathIterator PATH_ITERATOR = this.ELLIPSE.getPathIterator(null, 0.005);
            while (!PATH_ITERATOR.isDone()) {
                int segment = PATH_ITERATOR.currentSegment(COORDINATES);
                switch (segment) {
                    case 0: 
                    case 1: 
                    case 4: {
                        break;
                    }
                }
                double DISTANCE = this.LINE.ptSegDist(COORDINATES[0], COORDINATES[1]);
                if (DISTANCE < minDistance) {
                    minDistance = DISTANCE;
                    P.x = COORDINATES[0];
                    P.y = COORDINATES[1];
                }
                PATH_ITERATOR.next();
            }
            return this.CENTER.distance(P);
        }
    }
}

