/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ts_plugin;

import com.devexperts.logging.Logging;
import com.rusefi.core.FileUtil;
import com.rusefi.core.net.ConnectionAndMeta;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.ts_plugin.TsPluginBody;
import com.rusefi.util.SwingUtilities2;
import java.awt.Color;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URLClassLoader;
import java.util.Date;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.jetbrains.annotations.Nullable;
import org.putgemin.VerticalFlowLayout;

public class Updater {
    private static final Logging log = Logging.getLogging(Updater.class);
    private static final String PLUGIN_ENTRY_CLASS = "com.rusefi.ts_plugin.PluginEntry";
    private static final String PLUGIN_BODY_JAR = "rusefi_plugin_body.jar";
    private static final String LOCAL_JAR_FILE_NAME = FileUtil.RUSEFI_SETTINGS_FOLDER + File.separator + "rusefi_plugin_body.jar";
    private static final String TITLE = "rusEFI plugin installer 2025.alpha.6";
    private final JPanel content = new JPanel(new VerticalFlowLayout());
    private static final ImageIcon LOGO = AutoupdateUtil.loadIcon("/rusefi_online_color_300.png");
    private final JLabel countDownLabel = new JLabel();
    private final Object lock = new Object();
    private final AtomicInteger autoStartCounter = new AtomicInteger(4);
    private TsPluginBody instance;
    private final Timer timer = new Timer(1000, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent e) {
            if (Updater.this.autoStartCounter.decrementAndGet() == 0) {
                Updater.this.timer.stop();
                try {
                    if (Updater.this.shouldAutoStart) {
                        Updater.this.shouldAutoStart = false;
                        log.info("Auto-starting startPlugin");
                        Updater.this.startPlugin();
                    }
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | InvocationTargetException | MalformedURLException ex) {
                    ex.printStackTrace();
                    JOptionPane.showMessageDialog(Updater.this.content, "Error " + ex);
                }
            } else {
                Updater.this.countDownLabel.setText("Will auto-start in " + Updater.this.autoStartCounter + " seconds");
            }
        }
    });
    private volatile boolean shouldAutoStart = true;

    public Updater() {
        this.content.add(new JLabel("2025.alpha.6"));
        this.content.add(new JLabel(LOGO));
        String version = null;
        File localFile = new File(LOCAL_JAR_FILE_NAME);
        if (localFile.exists()) {
            version = this.getVersion();
        }
        final JButton download = new JButton("Update plugin");
        final JButton run = this.createRunThisVersionButton(version);
        new Thread(new Runnable(){

            @Override
            public void run() {
                ConnectionAndMeta connectionAndMeta;
                try {
                    connectionAndMeta = new ConnectionAndMeta(Updater.PLUGIN_BODY_JAR).invoke(ConnectionAndMeta.getDefaultAutoUpdateUrl());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
                log.info("Server has " + connectionAndMeta.getCompleteFileSize() + " from " + new Date(connectionAndMeta.getLastModified()));
                if (AutoupdateUtil.hasExistingFile(LOCAL_JAR_FILE_NAME, connectionAndMeta.getCompleteFileSize(), connectionAndMeta.getLastModified())) {
                    log.info("We already have latest update " + new Date(connectionAndMeta.getLastModified()));
                    SwingUtilities.invokeLater(() -> {
                        download.setText("We have latest plugin version");
                        download.setEnabled(false);
                    });
                    return;
                }
            }
        }).start();
        download.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (run != null) {
                    run.setEnabled(false);
                }
                Updater.this.cancelAutoStart();
                new Thread(() -> Updater.this.startDownload(download)).start();
            }
        });
        this.content.add(download);
    }

    @Nullable
    private JButton createRunThisVersionButton(String version) {
        if (version == null) {
            return null;
        }
        final JButton run = new JButton("Run Version " + version);
        run.setBackground(new Color(0x90EE90));
        run.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    Updater.this.cancelAutoStart();
                    log.info("run startPlugin");
                    Updater.this.startPlugin();
                }
                catch (ClassNotFoundException | IllegalAccessException | InstantiationException | InterruptedException | InvocationTargetException | MalformedURLException ex) {
                    run.setText(e.toString());
                }
            }
        });
        this.content.add(run);
        this.content.add(this.countDownLabel);
        this.timer.start();
        return run;
    }

    private void cancelAutoStart() {
        this.timer.stop();
        this.shouldAutoStart = false;
    }

    private String getVersion() {
        try {
            Class clazz = Updater.getPluginClass();
            Method method = clazz.getMethod("getVersion", new Class[0]);
            return (String)method.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException | MalformedURLException e) {
            return null;
        }
    }

    private void startDownload(final JButton download) {
        log.info("startDownload");
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                download.setEnabled(false);
            }
        });
        try {
            ConnectionAndMeta connectionAndMeta = new ConnectionAndMeta(PLUGIN_BODY_JAR).invoke(ConnectionAndMeta.getDefaultAutoUpdateUrl());
            AutoupdateUtil.downloadAutoupdateFile(LOCAL_JAR_FILE_NAME, connectionAndMeta, TITLE);
            log.info("Downloaded, now startPlugin");
            this.startPlugin();
        }
        catch (Exception e) {
            e.printStackTrace();
            download.setEnabled(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startPlugin() throws MalformedURLException, ClassNotFoundException, InstantiationException, IllegalAccessException, InterruptedException, InvocationTargetException {
        log.info("Starting plugin " + this);
        Class clazz = Updater.getPluginClass();
        Object object = this.lock;
        synchronized (object) {
            if (this.instance != null) {
                log.info("Not starting second instance");
                return;
            }
            SwingUtilities2.invokeAndWait(() -> {
                try {
                    this.instance = (TsPluginBody)clazz.newInstance();
                    this.replaceWith(this.instance);
                }
                catch (InstantiationException e) {
                    throw new RuntimeException(e);
                }
                catch (IllegalAccessException e) {
                    throw new RuntimeException(e);
                }
            });
        }
    }

    private static Class getPluginClass() throws MalformedURLException, ClassNotFoundException {
        log.info("Using " + LOCAL_JAR_FILE_NAME);
        URLClassLoader jarClassLoader = AutoupdateUtil.getClassLoaderByJar(LOCAL_JAR_FILE_NAME);
        return Class.forName(PLUGIN_ENTRY_CLASS, true, jarClassLoader);
    }

    private void replaceWith(TsPluginBody instance) {
        this.content.removeAll();
        this.content.add(instance.getContent());
        AutoupdateUtil.trueLayout(this.content.getParent());
        Window windowAncestor = SwingUtilities.getWindowAncestor(this.content);
        AutoupdateUtil.pack(windowAncestor);
    }

    public JPanel getContent() {
        return this.content;
    }
}

