/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.rusefi.util.LazyFile;
import com.rusefi.util.LazyFileImpl;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class PerfTraceEnumGenerator {
    private static final String ENUM_START_TAG = "enum_start_tag";
    private static final String ENUM_END_TAG = "enum_end_tag";

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("Input and output file names expected");
            System.exit(-1);
        }
        String inputFileName = args[0];
        String outputFileName = args[1];
        List<String> enumNames = PerfTraceEnumGenerator.readEnums(inputFileName);
        System.out.println("Got enums: " + enumNames);
        PerfTraceEnumGenerator.writeClass(outputFileName, enumNames);
    }

    private static void writeClass(String outputFileName, List<String> enumNames) throws IOException {
        LazyFile writer = LazyFileImpl.REAL.create(outputFileName);
        writer.write("package com.rusefi.tracing;\n");
        writer.write("// " + new Date() + " " + "was generated automatically by rusEFI tool " + PerfTraceEnumGenerator.class + "\n");
        writer.write("public class EnumNames {\n");
        writer.write("\tpublic static final String[] TypeNames = {\n");
        for (String enumValue : enumNames) {
            writer.write("\t\"" + enumValue + "\",\n");
        }
        writer.write("\t};\n");
        writer.write("}\n");
        writer.close();
        System.out.println("Done writing to " + outputFileName);
    }

    private static List<String> readEnums(String inputFileName) throws IOException {
        String line;
        BufferedReader br = new BufferedReader(new FileReader(inputFileName));
        boolean weAreInBusiness = false;
        ArrayList<String> result = new ArrayList<String>();
        while ((line = br.readLine()) != null) {
            if (line.contains(ENUM_START_TAG)) {
                weAreInBusiness = true;
                continue;
            }
            if (line.contains(ENUM_END_TAG)) break;
            if (!weAreInBusiness || !(line = line.trim().replaceAll("\\s", "")).endsWith(",")) continue;
            result.add(line.substring(0, line.length() - 1));
        }
        return result;
    }
}

