/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import com.rusefi.ConsoleUI;
import com.rusefi.NamedThreadFactory;
import com.rusefi.SimulatorExecHelper;
import com.rusefi.StartupFrame;
import com.rusefi.core.ui.ErrorMessageHelper;
import com.rusefi.io.LinkManager;
import com.rusefi.io.tcp.TcpConnector;
import com.rusefi.ui.util.UiUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ThreadFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;

public class SimulatorHelper {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("SimulatorHelper");
    private static final String BINARY = "rusefi_simulator.exe";
    private static Process process;
    private static final Logging log;

    public static boolean isBinaryHere() {
        return new File(BINARY).exists();
    }

    private static void startSimulator(final Listener simulatorListener) {
        LinkManager.isSimulationMode = true;
        SimulatorHelper.launchSimulatorInADifferenceThread();
        THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                boolean isPortOpened = false;
                for (int i = 0; i < 60 && !isPortOpened; ++i) {
                    isPortOpened = TcpConnector.isTcpPortOpened();
                    try {
                        Thread.sleep(1000L);
                        log.info("Process " + process);
                        continue;
                    }
                    catch (InterruptedException e) {
                        throw new IllegalStateException("Unexpected", e);
                    }
                }
                if (!isPortOpened) {
                    simulatorListener.onSimulatorLaunched(false);
                } else {
                    log.info("Port 29001 is alive");
                    simulatorListener.onSimulatorLaunched(true);
                }
            }
        }).start();
    }

    private static void launchSimulatorInADifferenceThread() {
        log.info("Executing simulator rusefi_simulator.exe");
        THREAD_FACTORY.newThread(new Runnable(){

            @Override
            public void run() {
                try {
                    process = Runtime.getRuntime().exec(SimulatorHelper.BINARY);
                    log.info("Executing simulator rusefi_simulator.exe=" + process);
                    SimulatorExecHelper.dumpProcessOutput(process, new CountDownLatch(1));
                }
                catch (IOException e) {
                    log.warn("Error " + e, e);
                    throw new IllegalStateException(e);
                }
            }
        }).start();
    }

    public static JComponent createSimulatorComponent(final StartupFrame portSelector) {
        if (!SimulatorHelper.isBinaryHere()) {
            return new JLabel("rusefi_simulator.exe not found");
        }
        if (TcpConnector.isTcpPortOpened()) {
            return new JLabel("Port 29001 already busy. Simulator running?");
        }
        final JButton simulatorButton = new JButton("Start Virtual Simulator");
        simulatorButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                simulatorButton.setText("Launching...");
                simulatorButton.setEnabled(false);
                SimulatorHelper.startSimulator(isLaunchedOk -> SwingUtilities.invokeLater(() -> {
                    if (isLaunchedOk) {
                        portSelector.disposeFrameAndProceed();
                        new ConsoleUI("29001");
                    } else {
                        ErrorMessageHelper.showErrorDialog("Error starting simulator", "Error");
                        simulatorButton.setText("Failed");
                    }
                }));
            }
        });
        UiUtils.setToolTip(simulatorButton, "Connect to totally virtual simulator", "You do not need any hardware to try rusEfi", "This works via localhost: 29001 TCP/IP port");
        return simulatorButton;
    }

    public static void onWindowClosed() {
        if (process != null) {
            process.destroy();
        }
    }

    static {
        log = Logging.getLogging(SimulatorHelper.class);
    }

    public static interface Listener {
        public void onSimulatorLaunched(boolean var1);
    }
}

