/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.common;

import com.rusefi.IoUtil;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.Sensor;
import com.rusefi.core.SensorCentral;
import com.rusefi.enums.debug_mode_e;
import com.rusefi.enums.engine_type_e;
import com.rusefi.functional_tests.EcuTestHelper;

public class PwmHardwareTestLogic {
    private static final int FREQUENCY = 160;

    public static void runIdlePwmTest(EcuTestHelper ecu, String idlePin, String logicCapturePin) {
        ecu.setEngineType(engine_type_e.FRANKENSO_MIATA_NA6_MAP);
        ecu.changeRpm(1000);
        ecu.sendCommand("set_trigger_simulator_pin 0 none");
        ecu.sendCommand("set_trigger_simulator_pin 1 none");
        ecu.sendCommand("set_idle_pin " + idlePin);
        ecu.sendCommand("set_ignition_pin 1 none");
        ecu.sendCommand("set_ignition_pin 2 none");
        ecu.sendCommand("set_ignition_pin 3 none");
        ecu.sendCommand("set_trigger_input_pin 1 PA8");
        ecu.sendCommand("set debug_mode " + debug_mode_e.DBG_LOGIC_ANALYZER.ordinal());
        ecu.sendCommand("set idle_solenoid_freq 160");
        ecu.sendCommand("set_logic_input_pin 0 " + logicCapturePin);
        ecu.sendCommand("writeconfig");
        BinaryProtocol.sleep(2000L);
        ecu.sendCommand(IoUtil.getEnableCommand("self_stimulation"));
        BinaryProtocol.sleep(2000L);
        EcuTestHelper.assertSomewhatClose("Idle PWM freq", 160.0, SensorCentral.getInstance().getValue(Sensor.debugIntField1), 0.02);
    }
}

