/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.config;

import com.macfaq.io.LittleEndianOutputStream;
import com.opensr5.ConfigurationImage;
import com.rusefi.config.FieldType;
import com.rusefi.core.FileUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class Field {
    public static final int NO_BIT_OFFSET = -1;
    public static final int FIELD_PRECISION = 5;
    private final String name;
    private final int offset;
    private final int stringSize;
    private final FieldType type;
    private final int bitOffset;
    private final String[] options;
    private double scale = 1.0;
    private int baseOffset;

    public Field(String name, int offset, FieldType type) {
        this(name, offset, type, -1);
    }

    public Field(String name, int offset, FieldType type, String ... options) {
        this(name, offset, type, -1, options);
    }

    public Field(String name, int offset, FieldType type, int bitOffset) {
        this(name, offset, type, bitOffset, null);
    }

    public Field(String name, int offset, FieldType type, int bitOffset, String[] options) {
        this(name, offset, 0, type, bitOffset, options);
    }

    public Field(String name, int offset, int stringSize, FieldType type, int bitOffset, String ... options) {
        this.name = Objects.requireNonNull(name);
        if (name.trim().isEmpty()) {
            throw new IllegalStateException("Empty field name");
        }
        this.offset = offset;
        this.stringSize = stringSize;
        this.type = type;
        this.bitOffset = bitOffset;
        this.options = options;
    }

    public static Field findFieldOrNull(Collection<Field> values, String instancePrefix, String fieldName) {
        Objects.requireNonNull(fieldName);
        for (Field f : values) {
            if (!fieldName.equalsIgnoreCase(f.getName())) continue;
            return f;
        }
        if (!instancePrefix.isEmpty()) {
            fieldName = instancePrefix + "_" + fieldName;
            for (Field f : values) {
                if (!fieldName.equalsIgnoreCase(f.getName())) continue;
                return f;
            }
        }
        return null;
    }

    public static int getStructureSize(Field[] values) {
        Field last = values[values.length - 1];
        return last.offset + 4;
    }

    public static String niceToString(Number value) {
        return Field.niceToString(value, 5);
    }

    public static String niceToString(Number value, int precision) {
        Number number = value;
        if (number instanceof Float) {
            return Field.niceToString(number.floatValue(), precision);
        }
        if (number instanceof Double) {
            return Field.niceToString(number.doubleValue(), precision);
        }
        return number.toString();
    }

    public static String niceToString(double value, int precision) {
        int scale = (int)Math.log10(value);
        int places = 1 + Math.max(0, precision - scale);
        double toScale = Math.pow(10.0, places);
        return Double.toString((double)Math.round(value * toScale) / toScale);
    }

    public String getName() {
        return this.name;
    }

    public String setCommand() {
        if (this.type == FieldType.BIT) {
            return "set_bit " + this.getOffset() + " " + this.bitOffset;
        }
        return this.getType().getStoreCommand() + " " + this.getOffset();
    }

    public String getCommand() {
        if (this.type == FieldType.BIT) {
            return "get_bit " + this.getOffset() + " " + this.bitOffset;
        }
        return this.type.getLoadCommand() + " " + this.getOffset();
    }

    public int getOffset() {
        return this.offset;
    }

    public int getTotalOffset() {
        return this.baseOffset + this.offset;
    }

    public String[] getOptions() {
        return this.options;
    }

    public int getBitOffset() {
        return this.bitOffset;
    }

    public FieldType getType() {
        return this.type;
    }

    public String toString() {
        return "Field{" + this.name + ", o=" + this.offset + ", type=" + (Object)((Object)this.type) + '}';
    }

    public String getAnyValue(ConfigurationImage ci, double multiplier) {
        if (this.options == null) {
            return Field.niceToString(this.getValue(ci, multiplier));
        }
        if (this.type != FieldType.INT8) {
            throw new IllegalStateException("Unsupported enum " + (Object)((Object)this.type));
        }
        byte ordinal = ci.getByteBuffer(this.offset, this.type.getStorageSize()).get();
        return this.options[ordinal];
    }

    public void setValueU32(byte[] content, int value) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        LittleEndianOutputStream dout = new LittleEndianOutputStream(baos);
        try {
            dout.writeInt(value);
            byte[] src = baos.toByteArray();
            System.arraycopy(src, 0, content, this.getOffset(), 4);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(byte[] content, boolean value) {
        ByteBuffer wrapped = FileUtil.littleEndianWrap(content, 0, content.length);
        if (this.bitOffset != -1) {
            int packed = wrapped.getInt();
            int thisBit = (value ? 1 : 0) << this.bitOffset;
            int mask = 1 << this.bitOffset;
            int newValue = packed & ~mask | thisBit;
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            LittleEndianOutputStream dout = new LittleEndianOutputStream(baos);
            try {
                dout.writeInt(newValue);
                byte[] src = baos.toByteArray();
                System.arraycopy(src, 0, content, this.getOffset(), 4);
                baos.close();
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    @Deprecated
    @NotNull
    public Double getValue(ConfigurationImage ci) {
        return this.getValue(ci, 1.0);
    }

    @NotNull
    public Double getValue(ConfigurationImage ci, double multiplier) {
        Number value;
        ByteBuffer wrapped;
        Objects.requireNonNull(ci, "ConfigurationImage");
        try {
            wrapped = ci.getByteBuffer(this.getOffset(), this.type.getStorageSize());
        }
        catch (IndexOutOfBoundsException e) {
            throw new RuntimeException("while " + this.name + " at " + this.getOffset() + " from " + ci.getSize(), e);
        }
        if (this.bitOffset != -1) {
            int packed = wrapped.getInt();
            value = packed >> this.bitOffset & 1;
        } else if (this.type == FieldType.INT8) {
            value = wrapped.get();
        } else if (this.type == FieldType.UINT8) {
            byte signed = wrapped.get();
            value = signed & 0xFF;
        } else if (this.type == FieldType.INT) {
            value = wrapped.getInt();
        } else if (this.type == FieldType.INT16) {
            value = wrapped.getShort();
        } else if (this.type == FieldType.UINT16) {
            short signed = wrapped.getShort();
            value = signed & 0xFFFF;
        } else if (this.type == FieldType.FLOAT) {
            value = Float.valueOf(wrapped.getFloat());
        } else {
            throw new IllegalStateException("Unexpected " + (Object)((Object)this.type));
        }
        return ((Number)value).doubleValue() * multiplier;
    }

    @NotNull
    public ByteBuffer getByteBuffer(ConfigurationImage ci) {
        return ci.getByteBuffer(this.getOffset(), 4);
    }

    public static Field create(String name, int offset, FieldType type, int bitOffset) {
        return new Field(name, offset, type, bitOffset);
    }

    public static Field create(String name, int offset, FieldType type, String ... options) {
        return new Field(name, offset, type, options);
    }

    public static Field create(String name, int offset, int stringSize, FieldType type) {
        return new Field(name, offset, stringSize, type, 0, new String[0]);
    }

    public static Field create(String name, int offset, FieldType type) {
        return new Field(name, offset, type);
    }

    public String getStringValue(ConfigurationImage image) {
        Objects.requireNonNull(image, "image");
        if (this.type != FieldType.STRING) {
            throw new IllegalStateException("Not a string parameter " + this.name);
        }
        return Field.getString(image, this.offset, this.stringSize);
    }

    @NotNull
    public static String getString(ConfigurationImage image, int offset, int size) {
        ByteBuffer bb = image.getByteBuffer(offset, size);
        byte[] bytes = new byte[size];
        bb.get(bytes);
        return new String(bytes).trim();
    }

    public boolean getBooleanValue(ConfigurationImage ci) {
        return this.getValue(ci) != 0.0;
    }

    public Field setScale(double scale) {
        this.scale = scale;
        return this;
    }

    public Field setBaseOffset(int baseOffset) {
        this.baseOffset = baseOffset;
        return this;
    }

    public double getScale() {
        return this.scale;
    }
}

