/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core.net;

import com.devexperts.logging.Logging;
import com.rusefi.core.net.ConnectionAndMeta;
import java.net.URL;
import java.security.CodeSource;
import org.jetbrains.annotations.NotNull;

public class JarFileUtil {
    private static final Logging log = Logging.getLogging(JarFileUtil.class);

    public static String getJarFileNamePrefix() {
        CodeSource codeSource = ConnectionAndMeta.class.getProtectionDomain().getCodeSource();
        if (codeSource == null) {
            throw new IllegalStateException("No codeSource");
        }
        String jarFileName = JarFileUtil.getJarFileName(codeSource);
        int startOfSuffix = jarFileName.lastIndexOf(95);
        if (startOfSuffix == -1) {
            throw new IllegalStateException("Unexpected jar file name: " + jarFileName);
        }
        String jarFilePrefix = jarFileName.substring(0, startOfSuffix);
        log.info("jarFilePrefix = " + jarFilePrefix);
        return jarFilePrefix;
    }

    @NotNull
    private static String getJarFileName(CodeSource codeSource) {
        URL jarUrl = codeSource.getLocation();
        String jarPath = jarUrl.getPath();
        String jarFileName = jarPath.substring(jarPath.lastIndexOf(47) + 1);
        return jarFileName;
    }
}

