/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.f4discovery;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.ScalarIniField;
import com.rusefi.RusefiTestBase;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.LinkManager;
import com.rusefi.io.commands.BurnCommand;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class BurnCommandTest
extends RusefiTestBase {
    private static final Logging log = Logging.getLogging(BurnCommandTest.class);

    @Test
    public void executeBurnCommand() throws InterruptedException {
        LinkManager linkManager = this.ecu.getLinkManager();
        BurnCommandTest.assertWrite(linkManager);
        BurnCommandTest.assertWrite(linkManager);
        this.assertBurn(linkManager);
    }

    private static void assertWrite(final LinkManager linkManager) throws InterruptedException {
        final CountDownLatch latch = new CountDownLatch(1);
        Runnable action = new Runnable(){

            @Override
            public void run() {
                log.info("assertWrite run");
                BinaryProtocol bp = linkManager.getBinaryProtocol();
                ScalarIniField displacementField = (ScalarIniField)bp.getIniFile().getIniField("displacement");
                ByteBuffer bb = BurnCommandTest.wrap(new byte[4]);
                ScalarIniField.setValue(bb, displacementField.getType(), "3", -1, 1.0, 0.0);
                log.info("assertWrite writeData " + Arrays.toString(bb.array()) + " " + displacementField);
                bp.writeInBlocks(bb.array(), 0, displacementField.getOffset(), displacementField.getSize());
                log.info("assertWrite countDown");
                latch.countDown();
            }
        };
        linkManager.submit(action);
        boolean result = latch.await(30L, TimeUnit.SECONDS);
        log.info("assertWrite result " + result);
        Assert.assertTrue(result);
    }

    private static ByteBuffer wrap(byte[] bytes) {
        ByteBuffer wrapped = ByteBuffer.wrap(bytes, 0, bytes.length);
        wrapped.order(ByteOrder.LITTLE_ENDIAN);
        return wrapped;
    }

    private void assertBurn(LinkManager linkManager) throws InterruptedException {
        AtomicReference result = new AtomicReference();
        CountDownLatch latch = new CountDownLatch(1);
        Runnable action = () -> {
            result.set(BurnCommand.execute(this.ecu.getLinkManager().getBinaryProtocol()));
            latch.countDown();
        };
        linkManager.submit(action);
        latch.await(30L, TimeUnit.SECONDS);
        Assert.assertNotNull(result.get());
        Assert.assertTrue("burn command", (Boolean)result.get());
    }
}

