/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.io.tcp;

import com.opensr5.io.DataListener;
import com.rusefi.binaryprotocol.IncomingDataBuffer;
import com.rusefi.core.FileUtil;
import com.rusefi.io.ByteReader;
import com.rusefi.io.serial.AbstractIoStream;
import com.rusefi.io.tcp.TcpConnector;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.jetbrains.annotations.NotNull;

public class TcpIoStream
extends AbstractIoStream {
    private final InputStream input;
    private final OutputStream output;
    private final String loggingPrefix;
    private final DisconnectListener disconnectListener;
    @NotNull
    private final Socket socket;
    private final IncomingDataBuffer dataBuffer;

    public TcpIoStream(String loggingPrefix, Socket socket) throws IOException {
        this(loggingPrefix, socket, DisconnectListener.VOID);
    }

    public TcpIoStream(String loggingPrefix, Socket socket, DisconnectListener disconnectListener) throws IOException {
        this.loggingPrefix = loggingPrefix;
        this.disconnectListener = disconnectListener;
        if (socket == null) {
            throw new NullPointerException("socket");
        }
        this.socket = socket;
        this.input = new BufferedInputStream(socket.getInputStream());
        this.output = new BufferedOutputStream(socket.getOutputStream());
        this.dataBuffer = this.createDataBuffer();
    }

    @NotNull
    public static TcpIoStream open(String port) throws IOException {
        int portPart = TcpConnector.getTcpPort(port);
        String hostname = TcpConnector.getHostname(port);
        Socket socket = new Socket(hostname, portPart);
        return new TcpIoStream("[start] " + port + " ", socket);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        TcpIoStream tcpIoStream = this;
        synchronized (tcpIoStream) {
            if (!this.isClosed()) {
                super.close();
                this.disconnectListener.onDisconnect("on close");
            }
        }
        FileUtil.close(this.socket);
    }

    @Override
    public IncomingDataBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        super.write(bytes);
        this.output.write(bytes);
    }

    public String toString() {
        return "TcpIoStream{" + this.loggingPrefix + '}';
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        this.output.flush();
    }

    @Override
    public void setInputListener(DataListener listener) {
        ByteReader.runReaderLoop(this.loggingPrefix, listener, this.input::read, this);
    }

    public static interface DisconnectListener {
        public static final DisconnectListener VOID = message -> {};

        public void onDisconnect(String var1);
    }
}

