/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.devexperts.logging.Logging;
import com.fazecast.jSerialComm.SerialPort;
import com.rusefi.ConnectivityContext;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.io.LinkManager;
import com.rusefi.io.UpdateOperationCallbacks;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public class BinaryProtocolExecutor {
    private static final long JUST_IN_CASE = Integer.getInteger("BinaryProtocolExecutor.serial_jic", 300).intValue();
    private static final Logging log = Logging.getLogging(BinaryProtocolExecutor.class);

    public static <T> T execute(String port, UpdateOperationCallbacks callbacks, BinaryProtocolAction<T> bpAction, T failureResult, boolean isScanningForEcu, String msg) {
        AtomicReference executionResult;
        block12: {
            executionResult = new AtomicReference(failureResult);
            try (LinkManager linkManager = new LinkManager().setNeedPullText(false).setNeedPullLiveData(true);){
                callbacks.logLine(String.format(msg + ": Connecting to port `%s`...", port));
                try {
                    if (linkManager.connect(port, isScanningForEcu).await(1L, TimeUnit.MINUTES)) {
                        CountDownLatch latch = new CountDownLatch(1);
                        callbacks.logLine(String.format(msg + ": Performing action on port %s...", port));
                        linkManager.execute(() -> {
                            try {
                                executionResult.set(bpAction.doWithBinaryProtocol(linkManager.getBinaryProtocol()));
                            }
                            finally {
                                latch.countDown();
                            }
                        });
                        try {
                            if (!latch.await(1L, TimeUnit.MINUTES)) {
                                callbacks.logLine(String.format("Failed perform action on port %s in a minute", port));
                            }
                            break block12;
                        }
                        catch (InterruptedException e) {
                            callbacks.logLine(String.format("Action on port %s was interrupted", port));
                        }
                        break block12;
                    }
                    callbacks.logLine(String.format("Failed to connect to port %s in a minute", port));
                }
                catch (InterruptedException e) {
                    callbacks.logLine(String.format("Connection to port %s was interrupted", port));
                }
            }
        }
        return executionResult.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T executeWithSuspendedPortScanner(String port, UpdateOperationCallbacks callbacks, BinaryProtocolAction<T> bpAction, T failureResult, ConnectivityContext connectivityContext, String msg) {
        try {
            callbacks.logLine(msg + ": Suspending port scanning...");
            try {
                long start = System.currentTimeMillis();
                connectivityContext.getSerialPortScanner().suspend().await(1L, TimeUnit.MINUTES);
                callbacks.logLine(String.format("Port scanning is suspended in %dms.", System.currentTimeMillis() - start));
            }
            catch (InterruptedException e) {
                callbacks.logLine("Failed to suspend port scanning in a minute.");
                T t = failureResult;
                callbacks.logLine(msg + ": Resuming port scanning...");
                connectivityContext.getSerialPortScanner().resume();
                callbacks.logLine("Port scanning is resumed.");
                return t;
            }
            log.info(msg + ": Executing " + callbacks);
            if (LinkManager.isSpecialNotSerial(port)) {
                log.info("Special " + port);
            } else {
                BinaryProtocolExecutor.waitForPort(port);
            }
            T t = BinaryProtocolExecutor.execute(port, callbacks, bpAction, failureResult, false, msg);
            return t;
        }
        finally {
            callbacks.logLine(msg + ": Resuming port scanning...");
            connectivityContext.getSerialPortScanner().resume();
            callbacks.logLine("Port scanning is resumed.");
        }
    }

    private static void waitForPort(String port) {
        Object[] commPorts = SerialPort.getCommPorts();
        boolean portAvailable = BinaryProtocolExecutor.contains((SerialPort[])commPorts, port);
        log.info(port + ": Available right away? " + Arrays.toString(commPorts) + "; " + portAvailable);
        if (portAvailable) {
            log.info("Giving it " + JUST_IN_CASE + "ms just in case...");
            BinaryProtocol.sleep(JUST_IN_CASE);
            return;
        }
        long start = System.currentTimeMillis();
        while (!portAvailable && System.currentTimeMillis() - start < 60000L) {
            BinaryProtocol.sleep(200L);
            portAvailable = BinaryProtocolExecutor.contains(SerialPort.getCommPorts(), port);
        }
        log.info(port + ": Appeared: " + portAvailable + " in " + (System.currentTimeMillis() - start) + "ms");
        log.info("Giving it " + JUST_IN_CASE + "ms just in case...");
        BinaryProtocol.sleep(JUST_IN_CASE);
    }

    private static boolean contains(SerialPort[] commPorts, String port) {
        Objects.requireNonNull(port, "port");
        for (SerialPort p : commPorts) {
            if (!port.equals(p.getSystemPortName())) continue;
            return true;
        }
        return false;
    }

    @FunctionalInterface
    public static interface BinaryProtocolAction<T> {
        public T doWithBinaryProtocol(BinaryProtocol var1);
    }
}

