/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Locale;
import java.util.Optional;

public enum AfrMsqImportMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String STOICH_RATIO_NAME = "stoichRatioPrimary";
    public static final String AFR_TABLE_NAME = "lambdaTable";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        Optional<IniField> prevAfrTable = context.getPrevIniFile().findIniField(AFR_TABLE_NAME);
        Optional<IniField> updatedAfrTable = context.getUpdatedIniFile().findIniField(AFR_TABLE_NAME);
        Optional<IniField> prevStoichRatio = context.getPrevIniFile().findIniField(STOICH_RATIO_NAME);
        if (!(prevAfrTable.isPresent() && updatedAfrTable.isPresent() && prevStoichRatio.isPresent())) {
            return;
        }
        Constant prevAfrTableData = context.getPrevTune().getConstantsAsMap().get(AFR_TABLE_NAME);
        Constant updatedAfrTableData = context.getUpdatedTune().getConstantsAsMap().get(AFR_TABLE_NAME);
        Constant prevStoichRatioConstant = context.getPrevTune().getConstantsAsMap().get(STOICH_RATIO_NAME);
        if (prevAfrTableData != null && updatedAfrTableData != null && prevStoichRatioConstant != null) {
            String prevLambdaTableUnits = prevAfrTableData.getUnits();
            String updatedLambdaTableUnits = updatedAfrTableData.getUnits();
            if (prevLambdaTableUnits == null || updatedLambdaTableUnits == null) {
                return;
            }
            if (prevLambdaTableUnits.contains(updatedLambdaTableUnits)) {
                return;
            }
            ArrayIniField prevTableField = (ArrayIniField)prevAfrTable.get();
            ArrayIniField updatedTableField = (ArrayIniField)updatedAfrTable.get();
            String[][] migratedValues = prevTableField.getValues(prevAfrTableData.getValue());
            Double prevStoichRatioValue = Double.parseDouble(prevStoichRatioConstant.getValue());
            int prevRows = prevTableField.getRows();
            int prevCols = prevTableField.getCols();
            int updatedRows = updatedTableField.getRows();
            int updatedCols = updatedTableField.getCols();
            if (prevRows != updatedRows || prevCols != updatedCols) {
                migratedValues = prevRows < updatedRows || prevCols < updatedCols ? AfrMsqImportMigrator.upsampleTable(migratedValues, updatedCols, updatedRows, prevTableField.getDigits()) : AfrMsqImportMigrator.downsampleTable(migratedValues, updatedCols, updatedRows);
            }
            if (prevLambdaTableUnits.contains("afr")) {
                for (int row = 0; row < migratedValues.length; ++row) {
                    for (int column = 0; column < migratedValues[0].length; ++column) {
                        Double migratedLambda = Double.parseDouble(migratedValues[row][column]) / prevStoichRatioValue;
                        migratedValues[row][column] = AfrMsqImportMigrator.formatArrayValue(migratedLambda, prevTableField.getDigits());
                    }
                }
            } else {
                for (int row = 0; row < migratedValues.length; ++row) {
                    for (int column = 0; column < migratedValues[0].length; ++column) {
                        Double migratedAfr = Double.parseDouble(migratedValues[row][column]) * prevStoichRatioValue;
                        migratedValues[row][column] = AfrMsqImportMigrator.formatArrayValue(migratedAfr, prevTableField.getDigits());
                    }
                }
            }
            context.addMigration(updatedTableField.getName(), new Constant(updatedTableField.getName(), updatedTableField.getUnits(), updatedTableField.formatValue(migratedValues), updatedTableField.getDigits(), Integer.toString(updatedRows), Integer.toString(updatedCols)));
        }
    }

    private static String formatArrayValue(double value, String digits) {
        int numDigits = Integer.parseInt(digits);
        return String.format(Locale.US, "%." + numDigits + "f", value);
    }

    public static String[][] upsampleTable(String[][] prevValues, int columnSize, int rowSize, String digits) {
        String[][] migratedTableValues = new String[rowSize][columnSize];
        int prevRowSize = prevValues.length;
        int prevColSize = prevValues[0].length;
        double[][] prevDoubleValues = new double[prevRowSize][prevColSize];
        for (int row = 0; row < prevRowSize; ++row) {
            for (int col = 0; col < prevColSize; ++col) {
                prevDoubleValues[row][col] = Double.parseDouble(prevValues[row][col]);
            }
        }
        double colScale = (double)(prevColSize - 1) / (double)(columnSize - 1);
        double rowScale = (double)(prevRowSize - 1) / (double)(rowSize - 1);
        for (int row = 0; row < rowSize; ++row) {
            double rowPosition = (double)row * rowScale;
            int lowerRowIndex = (int)rowPosition;
            int upperRowIndex = Math.min(lowerRowIndex + 1, prevRowSize - 1);
            double rowFraction = rowPosition - (double)lowerRowIndex;
            for (int col = 0; col < columnSize; ++col) {
                double interpolatedValue;
                double colPosition = (double)col * colScale;
                int lowerColIndex = (int)colPosition;
                int upperColIndex = Math.min(lowerColIndex + 1, prevColSize - 1);
                double colFraction = colPosition - (double)lowerColIndex;
                if (lowerRowIndex == upperRowIndex && lowerColIndex == upperColIndex) {
                    interpolatedValue = prevDoubleValues[lowerRowIndex][lowerColIndex];
                } else if (lowerRowIndex == upperRowIndex) {
                    interpolatedValue = prevDoubleValues[lowerRowIndex][lowerColIndex] * (1.0 - colFraction) + prevDoubleValues[lowerRowIndex][upperColIndex] * colFraction;
                } else if (lowerColIndex == upperColIndex) {
                    interpolatedValue = prevDoubleValues[lowerRowIndex][lowerColIndex] * (1.0 - rowFraction) + prevDoubleValues[upperRowIndex][lowerColIndex] * rowFraction;
                } else {
                    double topInterpolated = prevDoubleValues[lowerRowIndex][lowerColIndex] * (1.0 - colFraction) + prevDoubleValues[lowerRowIndex][upperColIndex] * colFraction;
                    double bottomInterpolated = prevDoubleValues[upperRowIndex][lowerColIndex] * (1.0 - colFraction) + prevDoubleValues[upperRowIndex][upperColIndex] * colFraction;
                    interpolatedValue = topInterpolated * (1.0 - rowFraction) + bottomInterpolated * rowFraction;
                }
                migratedTableValues[row][col] = AfrMsqImportMigrator.formatArrayValue(interpolatedValue, digits);
            }
        }
        return migratedTableValues;
    }

    public static String[][] downsampleTable(String[][] prevValues, int columnSize, int rowSize) {
        int srcCol;
        int destCol;
        int srcRow;
        int prevRowSize = prevValues.length;
        int prevColSize = prevValues[0].length;
        String[][] migratedTableValues = new String[rowSize][columnSize];
        int newColStartSize = columnSize / 3;
        int newColEndSize = columnSize / 3;
        int newColMiddleSize = columnSize - newColStartSize - newColEndSize;
        int colMiddleStartIndex = (prevColSize - newColMiddleSize) / 2;
        int newRowStartSize = rowSize / 3;
        int newRowEndSize = rowSize / 3;
        int newRowMiddleSize = rowSize - newRowStartSize - newRowEndSize;
        int rowMiddleStartIndex = (prevRowSize - newRowMiddleSize) / 2;
        int destRow = 0;
        for (srcRow = 0; srcRow < newRowStartSize; ++srcRow) {
            destCol = 0;
            for (srcCol = 0; srcCol < newColStartSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[srcRow][srcCol];
            }
            for (srcCol = 0; srcCol < newColMiddleSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[srcRow][colMiddleStartIndex + srcCol];
            }
            for (srcCol = 0; srcCol < newColEndSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[srcRow][prevColSize - newColEndSize + srcCol];
            }
            ++destRow;
        }
        for (srcRow = 0; srcRow < newRowMiddleSize; ++srcRow) {
            destCol = 0;
            for (srcCol = 0; srcCol < newColStartSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[rowMiddleStartIndex + srcRow][srcCol];
            }
            for (srcCol = 0; srcCol < newColMiddleSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[rowMiddleStartIndex + srcRow][colMiddleStartIndex + srcCol];
            }
            for (srcCol = 0; srcCol < newColEndSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[rowMiddleStartIndex + srcRow][prevColSize - newColEndSize + srcCol];
            }
            ++destRow;
        }
        for (srcRow = 0; srcRow < newRowEndSize; ++srcRow) {
            destCol = 0;
            for (srcCol = 0; srcCol < newColStartSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[prevRowSize - newRowEndSize + srcRow][srcCol];
            }
            for (srcCol = 0; srcCol < newColMiddleSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[prevRowSize - newRowEndSize + srcRow][colMiddleStartIndex + srcCol];
            }
            for (srcCol = 0; srcCol < newColEndSize; ++srcCol) {
                migratedTableValues[destRow][destCol++] = prevValues[prevRowSize - newRowEndSize + srcRow][prevColSize - newColEndSize + srcCol];
            }
            ++destRow;
        }
        return migratedTableValues;
    }
}

