/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.core.net.PropertiesHolder;
import com.rusefi.core.ui.AutoupdateUtil;
import com.rusefi.core.ui.ErrorMessageHelper;
import com.rusefi.maintenance.jobs.ImportTuneJob;
import com.rusefi.tune_manifest.TuneManifestHelper;
import com.rusefi.tune_manifest.TuneModel;
import com.rusefi.ui.basic.SingleAsyncJobExecutor;
import com.rusefi.ui.table.ButtonEditor;
import com.rusefi.ui.table.ButtonRenderer;
import com.rusefi.ui.widgets.StatusPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;
import org.json.simple.parser.ParseException;

public class TuneManagementTab {
    private static final Logging log = Logging.getLogging(TuneManagementTab.class);
    private static final int MAP_ID_INDEX = 0;
    private static final int SIZE_INDEX = 2;
    private static final int BUTTON_COLUMN = 3;
    private final JPanel totalContent = new JPanel(new BorderLayout());
    private final JLabel status = new JLabel("Downloading tunes...");
    private final JTable table = new JTable(new MyTableModel());
    private List<TuneModel> tunes = new ArrayList<TuneModel>();

    public TuneManagementTab(final ConnectivityContext connectivityContext, final AtomicReference<Optional<PortResult>> ecuPortToUse, Component importTuneButton, final SingleAsyncJobExecutor singleAsyncJobExecutor, final StatusPanel statusPanelTuneTab) {
        final String tunesManifestUrl = TuneManagementTab.getTunesManifestUrl();
        if (tunesManifestUrl != null) {
            this.totalContent.add((Component)this.status, "North");
            JScrollPane tableScroll = new JScrollPane(this.table, 22, 30){

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(400, 200);
                }
            };
            JPanel centerPanel = new JPanel(new BorderLayout());
            centerPanel.add((Component)tableScroll, "Center");
            centerPanel.add((Component)statusPanelTuneTab, "South");
            this.totalContent.add((Component)centerPanel, "Center");
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        TuneManifestHelper.downloadAllTunes(tunesManifestUrl, new TuneManifestHelper.Callback(){

                            @Override
                            public void onDownloaded(List<TuneModel> tunes) {
                                SwingUtilities.invokeLater(() -> TuneManagementTab.this.displayTunes(tunes));
                            }
                        });
                    }
                    catch (IOException | ParseException e) {
                        SwingUtilities.invokeLater(() -> TuneManagementTab.this.status.setText("Error " + e));
                    }
                }
            }).start();
        }
        this.table.getColumnModel().getColumn(0).setPreferredWidth(50);
        this.table.getColumnModel().getColumn(1).setPreferredWidth(450);
        this.table.getColumnModel().getColumn(2).setPreferredWidth(40);
        TableColumn buttonColumn = this.table.getColumnModel().getColumn(3);
        buttonColumn.setPreferredWidth(100);
        buttonColumn.setCellRenderer(new ButtonRenderer());
        buttonColumn.setCellEditor(new ButtonEditor(new JButton(), "Import", this.table, new ButtonEditor.Clicked(){

            @Override
            public void clicked(int row) {
                TuneModel model = (TuneModel)TuneManagementTab.this.tunes.get(row);
                String localFolderForSpecificUrl = TuneManifestHelper.getLocalFolder(tunesManifestUrl);
                String tuneFileName = localFolderForSpecificUrl + model.getSaferLocalFileName();
                Optional portResult = (Optional)ecuPortToUse.get();
                if (!new File(tuneFileName).exists()) {
                    ErrorMessageHelper.showErrorDialog("Failed to load " + model.getUrl(), "Tune error");
                } else if (portResult.isPresent()) {
                    log.info("Let's load " + tuneFileName + " into " + portResult);
                    ImportTuneJob.importTuneIntoDevice((PortResult)portResult.get(), TuneManagementTab.this.status, connectivityContext, tuneFileName, singleAsyncJobExecutor);
                } else {
                    statusPanelTuneTab.logLine("Not connected?");
                }
            }
        }));
        this.totalContent.add(importTuneButton, "South");
    }

    private void displayTunes(List<TuneModel> tunes) {
        this.tunes = tunes;
        this.status.setText(tunes.size() + " tunes downloaded!");
        AutoupdateUtil.trueLayoutAndRepaint(this.table);
    }

    public Component getContent() {
        return this.totalContent;
    }

    public static String getTunesManifestUrl() {
        return PropertiesHolder.getProperty("tunes_manifest");
    }

    class MyTableModel
    extends AbstractTableModel {
        private final String[] columnNames = new String[]{"MapID", "Name", "Size", ""};

        MyTableModel() {
        }

        @Override
        public String getColumnName(int column) {
            return this.columnNames[column];
        }

        @Override
        public int getColumnCount() {
            return this.columnNames.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (rowIndex == 0) {
                return this.columnNames[columnIndex];
            }
            TuneModel model = (TuneModel)TuneManagementTab.this.tunes.get(rowIndex - 1);
            if (columnIndex == 0) {
                return model.getMapId();
            }
            if (columnIndex == 1) {
                return model.getFileName();
            }
            if (columnIndex == 2) {
                return model.getSize();
            }
            if (columnIndex == 3) {
                return model.isError() ? "Failed to Download" : "Load Tune";
            }
            return rowIndex + " " + columnIndex;
        }

        @Override
        public int getRowCount() {
            return TuneManagementTab.this.tunes.size() + 1;
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            if (row == 0) {
                return false;
            }
            return column == 3;
        }

        @Override
        public Class<?> getColumnClass(int column) {
            if (column == 3) {
                return JButton.class;
            }
            return Object.class;
        }
    }
}

