/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.basic;

import com.devexperts.logging.Logging;
import com.opensr5.ini.field.IniField;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.CalibrationsHelper;
import com.rusefi.maintenance.CalibrationsInfo;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import javax.swing.JOptionPane;

public enum UnitLabelPrinter {
    INSTANCE;

    private static final Logging log;
    public static final Set<String> UNIT_IDENTIFIER_FIELD_NAMES;

    public boolean printUnitLabel(JComponent parent, PortResult ecuPort, UpdateOperationCallbacks callbacks, ConnectivityContext connectivityContext) {
        boolean result = false;
        Optional<CalibrationsInfo> currentCalibrations = CalibrationsHelper.readCurrentCalibrations(ecuPort.port, callbacks, connectivityContext);
        if (currentCalibrations.isPresent()) {
            UnitIdentifiers unitIdentifiers = new UnitIdentifiers(currentCalibrations.get(), callbacks);
            if (!unitIdentifiers.isEmpty()) {
                if (JOptionPane.showConfirmDialog(parent, String.format("Connected unit has: \n\n%s\nWould you like to print unit label?", unitIdentifiers), "Unit identification", 0) == 0) {
                    try {
                        PrinterJob job = PrinterJob.getPrinterJob();
                        job.setPrintable(unitIdentifiers);
                        if (job.printDialog()) {
                            job.print();
                        } else {
                            callbacks.logLine("User closed `Print` dialog...");
                        }
                        result = true;
                    }
                    catch (PrinterException e) {
                        log.error("Failed to print unit identifiers:", e);
                        callbacks.logLine("Failed to print unit identifiers");
                    }
                } else {
                    callbacks.logLine("User selected not to print unit label...");
                    result = true;
                }
            } else {
                callbacks.logLine("No unit identifier ini-fields found in current calibrations...");
            }
        } else {
            callbacks.logLine("Failed to read current calibrations...");
        }
        return result;
    }

    static {
        log = Logging.getLogging(UnitLabelPrinter.class);
        UNIT_IDENTIFIER_FIELD_NAMES = Arrays.stream(new String[]{"uidSum", "shortUid", "hwRevision"}).collect(Collectors.toSet());
    }

    private static class UnitIdentifiers
    implements Printable {
        private static final String UID_SUM_FIELD_NAME = "uidSum";
        private static final String SHORT_UID_FIELD_NAME = "shortUid";
        private static final String HW_REVISION_FIELD_NAME = "hwRevision";
        private final LinkedHashMap<String, String> identifiers = new LinkedHashMap();

        UnitIdentifiers(CalibrationsInfo calibrationsInfo, UpdateOperationCallbacks callbacks) {
            Optional<String> uidSum = UnitIdentifiers.readFieldValue(UID_SUM_FIELD_NAME, calibrationsInfo, callbacks);
            uidSum.ifPresent(value -> {
                double doubleValue = Double.parseDouble(value);
                this.identifiers.put("", String.format("%.0f", doubleValue));
            });
            Optional<String> shortUid = UnitIdentifiers.readFieldValue(SHORT_UID_FIELD_NAME, calibrationsInfo, callbacks);
            shortUid.ifPresent(value -> {
                double doubleValue = Double.parseDouble(value);
                this.identifiers.put("Short", String.format("%.0f", doubleValue));
            });
            Optional<String> hwRevision = UnitIdentifiers.readFieldValue(HW_REVISION_FIELD_NAME, calibrationsInfo, callbacks);
            hwRevision.ifPresent(value -> this.identifiers.put("HW", (String)value));
        }

        boolean isEmpty() {
            return this.identifiers.isEmpty();
        }

        public String toString() {
            StringBuilder result = new StringBuilder();
            this.write(result::append, () -> result.append("\n"));
            return result.toString();
        }

        private void write(Consumer<String> stringWriter, Runnable endOfLineWriter) {
            for (Map.Entry<String, String> identifier : this.identifiers.entrySet()) {
                String idKey = identifier.getKey();
                String idValue = identifier.getValue();
                if (idKey.isEmpty()) {
                    stringWriter.accept(idValue);
                } else {
                    stringWriter.accept(String.format("%s: %s", idKey, idValue));
                }
                endOfLineWriter.run();
            }
        }

        private static Optional<String> readFieldValue(String fieldName, CalibrationsInfo calibrationsInfo, UpdateOperationCallbacks callbacks) {
            Optional<IniField> iniField = calibrationsInfo.getIniFile().findIniField(fieldName);
            if (!iniField.isPresent()) {
                callbacks.logLine(String.format("Calibrations don't contain `%s` field", fieldName));
            }
            return iniField.map(field -> field.getValue(calibrationsInfo.getImage().getConfigurationImage()));
        }

        @Override
        public int print(Graphics graphics, PageFormat pageFormat, int pageIndex) {
            if (pageIndex > 0) {
                return 1;
            }
            Graphics2D g2d = (Graphics2D)graphics;
            g2d.translate(pageFormat.getImageableX(), pageFormat.getImageableY());
            AtomicInteger intPosY = new AtomicInteger(10);
            this.write(line -> graphics.drawString((String)line, 0, intPosY.get()), () -> intPosY.addAndGet(10));
            return 0;
        }
    }
}

