/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;

public class ButtonEditor
extends AbstractCellEditor
implements TableCellEditor,
ActionListener {
    private final JTable table;
    private final Clicked clicked;
    private final JButton button;
    private String label;
    private boolean isPushed;

    public ButtonEditor(JButton button, String label, JTable table, Clicked clicked) {
        this.button = button;
        this.label = label;
        this.table = table;
        this.clicked = clicked;
        this.button.setOpaque(true);
        this.button.addActionListener(this);
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        if (isSelected) {
            this.button.setForeground(table.getSelectionForeground());
            this.button.setBackground(table.getSelectionBackground());
        } else {
            this.button.setForeground(table.getForeground());
            this.button.setBackground(table.getBackground());
        }
        this.label = value == null ? "" : value.toString();
        this.button.setText(this.label);
        this.isPushed = true;
        return this.button;
    }

    @Override
    public Object getCellEditorValue() {
        return this.label;
    }

    @Override
    public boolean stopCellEditing() {
        this.isPushed = false;
        return super.stopCellEditing();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.isPushed) {
            int selectedRow = this.table.getSelectedRow();
            int selectedCol = this.table.getSelectedColumn();
            this.clicked.clicked(selectedRow - 1);
        }
        this.fireEditingStopped();
    }

    @Override
    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public static interface Clicked {
        public void clicked(int var1);
    }
}

