/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.util;

import com.devexperts.logging.Logging;
import com.opensr5.ConfigurationImage;
import com.opensr5.ConfigurationImageWithMeta;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.field.OrdinalOutOfRangeException;
import com.opensr5.io.ConfigurationImageFile;
import com.rusefi.binaryprotocol.MsqFactory;
import com.rusefi.tune.xml.Msq;
import java.io.IOException;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TuneBackupUtil {
    private static final Logging log = Logging.getLogging(TuneBackupUtil.class);

    public static void saveConfigurationImageToFiles(ConfigurationImageWithMeta imageWithMeta, IniFileModel ini, @Nullable String binaryFileName, @Nullable String xmlFileName) throws JAXBException, IOException {
        if (binaryFileName != null) {
            ConfigurationImageFile.saveToFile(imageWithMeta, binaryFileName);
        }
        if (xmlFileName != null) {
            TuneBackupUtil.saveXmlFile(imageWithMeta, ini, xmlFileName);
        }
    }

    private static void saveXmlFile(ConfigurationImageWithMeta imageWithMeta, IniFileModel ini, @NotNull String xmlFileName) throws JAXBException, IOException {
        ConfigurationImage image = imageWithMeta.getConfigurationImage();
        if (image == null) {
            log.warn("No image for saveConfigurationImageToFiles");
            return;
        }
        try {
            Msq tune = MsqFactory.valueOf(image, ini);
            tune.writeXmlFile(xmlFileName);
        }
        catch (OrdinalOutOfRangeException e) {
            log.warn("OrdinalOutOfRangeException exception on saving .msq file:" + e, e);
            throw e;
        }
    }
}

