/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.wizard;

import com.devexperts.logging.Logging;
import com.efiAnalytics.plugin.ecu.ControllerAccess;
import com.efiAnalytics.plugin.ecu.ControllerException;
import com.efiAnalytics.plugin.ecu.ControllerParameter;
import com.efiAnalytics.plugin.ecu.OutputChannelClient;
import com.rusefi.binaryprotocol.BinaryProtocol;
import java.util.function.Supplier;

public class BackgroundWizard {
    private static final String ECU_VIN_KEY = "vinNumber";
    private static final Logging log = Logging.getLogging(BackgroundWizard.class);
    private static Supplier<ControllerAccess> controllerAccessSupplier;
    static OutputChannelClient onlineListener;
    private static int CURRENT_STATE_UNKNOWN;
    private static int CURRENT_STATE_OFFLINE;
    private static int CURRENT_STATE_ONLINE;
    private static int currentState;
    private static int lastState;
    private static boolean pluginEnabled;
    private static boolean ecuVinToogle;
    private static String ecuVin;

    public static void start(Supplier<ControllerAccess> controllerAccessSupplier) {
        BackgroundWizard.controllerAccessSupplier = controllerAccessSupplier;
        try {
            BackgroundWizard.controllerAccessSupplier.get().getOutputChannelServer().subscribe("AppEvent", "controllerOnline", onlineListener);
        }
        catch (Exception e) {
            log.error("error on onlineListener " + e, e);
        }
        Thread thread = new Thread(() -> {
            while (true) {
                try {
                    BackgroundWizard.periodicWizardLogic();
                }
                catch (Throwable e) {
                    log.error("error " + e, e);
                }
                BinaryProtocol.sleep(300L);
            }
        });
        thread.setName("wizard-thread");
        thread.setDaemon(true);
        thread.start();
    }

    private static void periodicWizardLogic() throws ControllerException {
        if (currentState != lastState) {
            if (currentState == CURRENT_STATE_UNKNOWN) {
                log.info("ECU is not connected / no updates from TS");
            } else if (currentState == CURRENT_STATE_OFFLINE) {
                log.info("ECU is offline");
            } else if (currentState == CURRENT_STATE_ONLINE) {
                log.info("ECU is online");
                ecuVinToogle = true;
            }
            lastState = currentState;
        }
        if (currentState == CURRENT_STATE_ONLINE && pluginEnabled && ecuVinToogle) {
            log.info("ECU is online and we can run the wizard");
            String mainConfigName = controllerAccessSupplier.get().getEcuConfigurationNames()[0];
            ControllerParameter currentVin = controllerAccessSupplier.get().getControllerParameterServer().getControllerParameter(mainConfigName, ECU_VIN_KEY);
            ecuVin = currentVin.getStringValue();
            log.info("ECU vin is " + ecuVin);
            ecuVinToogle = false;
        }
    }

    public static boolean displayPlugin(String serialSignature) {
        boolean signatureValid;
        boolean bl = signatureValid = serialSignature != null && !serialSignature.isEmpty();
        if (signatureValid) {
            pluginEnabled = serialSignature.contains("hd81");
        } else {
            log.info("ECU signature invalid for this plugin: " + serialSignature);
        }
        return pluginEnabled;
    }

    static {
        onlineListener = new EcuOnlineListener();
        CURRENT_STATE_UNKNOWN = -1;
        CURRENT_STATE_OFFLINE = 0;
        CURRENT_STATE_ONLINE = 1;
        currentState = -1;
        lastState = -1;
        pluginEnabled = false;
        ecuVinToogle = true;
        ecuVin = null;
    }

    static class EcuOnlineListener
    implements OutputChannelClient {
        EcuOnlineListener() {
        }

        @Override
        public void setCurrentOutputChannelValue(String string, double d) {
            int newState = (int)d;
            if (currentState == 0 ^ newState == 0) {
                currentState = newState;
            }
        }
    }
}

