/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;

public class Poi {
    private final Util UTIL = Util.INSTANCE;
    private final String NAME;
    private double lat = 0.0;
    private double lon = 0.0;
    private String latDirection = "N";
    private String lonDirection = "W";
    private final Rectangle WORLD_MAP = new Rectangle(0, 0, 40000, 20000);
    private final Point2D LOCATION = new Point2D.Double(this.lon, this.lat);
    private Point2D LOCATION_XY = new Point2D.Double(0.0, 0.0);
    private final BufferedImage POI_IMAGE = this.create_POI_Image(5);

    public Poi(String NAME) {
        this(NAME, 0.0, 0.0);
    }

    public Poi(String NAME, double LAT, double LON) {
        this.NAME = NAME;
        this.lat = LAT;
        this.lon = LON;
        this.setLocation(LAT, LON);
        this.adjustDirection();
    }

    public Poi(String NAME, int LAT_DEG, int LAT_MIN, int LAT_SEC, int LON_DEG, int LON_MIN, int LON_SEC) {
        this.NAME = NAME;
        this.lat = this.convert(LAT_DEG, LAT_MIN, LAT_SEC);
        this.lon = this.convert(LON_DEG, LON_MIN, LON_SEC);
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public Poi(String NAME, int LAT_DEG, double LAT_MIN, int LON_DEG, double LON_MIN) {
        this.NAME = NAME;
        this.lat = this.convert(LAT_DEG, LAT_MIN);
        this.lon = this.convert(LON_DEG, LON_MIN);
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public Poi(String NAME, String LAT_DIRECTION, int LAT_DEG, double LAT_MIN, String LON_DIRECTION, int LON_DEG, double LON_MIN) {
        this.NAME = NAME;
        this.lat = this.convert(LAT_DEG, LAT_MIN);
        this.lon = this.convert(LON_DEG, LON_MIN);
        if (LAT_DIRECTION.equalsIgnoreCase("S")) {
            this.lat *= -1.0;
        }
        if (LON_DIRECTION.equalsIgnoreCase("W")) {
            this.lon *= -1.0;
        }
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public Poi(String NAME, String LAT_DIRECTION, int LAT_DEG, int LAT_MIN, int LAT_SEC, String LON_DIRECTION, int LON_DEG, int LON_MIN, int LON_SEC) {
        this.NAME = NAME;
        this.lat = this.convert(LAT_DEG, LAT_MIN, LAT_SEC);
        this.lon = this.convert(LON_DEG, LON_MIN, LON_SEC);
        if (LAT_DIRECTION.equalsIgnoreCase("S")) {
            this.lat *= -1.0;
        }
        if (LON_DIRECTION.equalsIgnoreCase("W")) {
            this.lon *= -1.0;
        }
        this.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public String getName() {
        return this.NAME;
    }

    public BufferedImage getPoiImage() {
        return this.POI_IMAGE;
    }

    public double getLon() {
        return this.lon;
    }

    public void setLon(double LON) {
        this.lon = LON;
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLon(int LON_DEG, int LON_MIN, int LON_SEC) {
        this.lon = this.convert(LON_DEG, LON_MIN, LON_SEC);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLon(int LON_DEG, double LON_MIN) {
        this.lon = this.convert(LON_DEG, LON_MIN);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public double getLat() {
        return this.lat;
    }

    public void setLat(double LAT) {
        this.lat = LAT;
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLat(int LAT_DEG, int LAT_MIN, int LAT_SEC) {
        this.lat = this.convert(LAT_DEG, LAT_MIN, LAT_SEC);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public void setLat(int LAT_DEG, double LAT_MIN) {
        this.lat = this.convert(LAT_DEG, LAT_MIN);
        this.LOCATION.setLocation(this.lat, this.lon);
        this.adjustDirection();
    }

    public String getLonDirection() {
        return this.lonDirection;
    }

    public String getLatDirection() {
        return this.latDirection;
    }

    public Point2D getLocation() {
        return this.LOCATION;
    }

    public void setLocation(Point2D LOCATION) {
        this.lon = LOCATION.getX();
        this.lat = LOCATION.getY();
        this.LOCATION.setLocation(LOCATION);
        this.LOCATION_XY.setLocation(this.toXY(this.lat, this.lon));
        this.adjustDirection();
    }

    public final void setLocation(double LAT, double LON) {
        this.lon = LON;
        this.lat = LAT;
        this.LOCATION.setLocation(LON, LAT);
        this.LOCATION_XY.setLocation(this.toXY(LAT, LON));
        this.adjustDirection();
    }

    public Point2D getLocationXY() {
        return this.LOCATION_XY;
    }

    public double distanceTo(Poi POINT_OF_INTEREST) {
        return this.distanceTo(POINT_OF_INTEREST.getLat(), POINT_OF_INTEREST.getLon());
    }

    public double distanceTo(double LAT, double LON) {
        double EARTH_RADIUS = 6371000.0;
        return Math.abs(Math.acos(Math.sin(Math.toRadians(LAT)) * Math.sin(Math.toRadians(this.lat)) + Math.cos(Math.toRadians(LAT)) * Math.cos(Math.toRadians(this.lat)) * Math.cos(Math.toRadians(LON - this.lon))) * 6371000.0);
    }

    public Point2D shiftTo(double DISTANCE, double ANGLE) {
        double EARTH_RADIUS = 6371000.0;
        double LON1 = Math.toRadians(this.lon);
        double LAT1 = Math.toRadians(this.lat);
        double LAT2 = Math.asin(Math.sin(LAT1) * Math.cos(DISTANCE / 6371000.0) + Math.cos(LAT1) * Math.sin(DISTANCE / 6371000.0) * Math.cos(Math.toRadians(ANGLE)));
        double LON2 = LON1 + Math.atan2(Math.sin(Math.toRadians(ANGLE)) * Math.sin(DISTANCE / 6371000.0) * Math.cos(LAT1), Math.cos(DISTANCE / 6371000.0) - Math.sin(LAT1) * Math.sin(LAT2));
        double LON2_CORRECTED = (LON2 + Math.PI * 3) % (Math.PI * 2) - Math.PI;
        this.setLocation(Math.toDegrees(LAT2), Math.toDegrees(LON2_CORRECTED));
        return this.getLocation();
    }

    private void adjustDirection() {
        this.latDirection = this.lat > 0.0 ? "N" : "S";
        this.lonDirection = this.lon > 0.0 ? "E" : "W";
    }

    private double convert(int DEG, int MIN, int SEC) {
        return DEG + MIN / 60 + SEC / 3600;
    }

    private double convert(int DEG, double MIN) {
        return (double)DEG + MIN / 60.0;
    }

    public final Point2D toXY(double LAT, double LON) {
        double LATITUDE = LAT * -1.0 + 90.0;
        double LONGITUDE = LON + 180.0;
        double X = Math.round(LONGITUDE * (this.WORLD_MAP.getWidth() / 360.0));
        double Y = Math.round(LATITUDE * (this.WORLD_MAP.getHeight() / 180.0));
        return new Point2D.Double(X, Y);
    }

    private BufferedImage create_POI_Image(int WIDTH) {
        if (WIDTH <= 0) {
            return null;
        }
        BufferedImage IMAGE = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        Ellipse2D.Double BLIP = new Ellipse2D.Double(0.0, 0.0, WIDTH, WIDTH);
        Point2D.Double CENTER = new Point2D.Double(BLIP.getCenterX(), BLIP.getCenterY());
        float[] FRACTIONS = new float[]{0.0f, 1.0f};
        Color[] COLORS = new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.9f), new Color(1.0f, 1.0f, 1.0f, 0.0f)};
        RadialGradientPaint GRADIENT = new RadialGradientPaint(CENTER, (int)((double)WIDTH / 2.0), FRACTIONS, COLORS);
        G2.setPaint(GRADIENT);
        G2.fill(BLIP);
        G2.dispose();
        return IMAGE;
    }

    public String toString() {
        return this.getLat() + "," + this.getLon();
    }
}

