/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.gauges;

import eu.hansolo.steelseries.gauges.AbstractGauge;
import eu.hansolo.steelseries.gauges.Lcd;
import eu.hansolo.steelseries.tools.ColorDef;
import eu.hansolo.steelseries.tools.CustomColorDef;
import eu.hansolo.steelseries.tools.LcdColor;
import eu.hansolo.steelseries.tools.NumberSystem;
import eu.hansolo.steelseries.tools.Orientation;
import eu.hansolo.steelseries.tools.Util;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.font.FontRenderContext;
import java.awt.font.TextLayout;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import javax.swing.Timer;
import javax.swing.border.Border;
import org.pushingpixels.trident.Timeline;
import org.pushingpixels.trident.TimelineScenario;
import org.pushingpixels.trident.callback.TimelineCallback;
import org.pushingpixels.trident.ease.Sine;
import org.pushingpixels.trident.ease.Spline;
import org.pushingpixels.trident.ease.TimelineEase;

public abstract class AbstractLinear
extends AbstractGauge
implements Lcd,
ActionListener {
    private final Rectangle INNER_BOUNDS = new Rectangle(120, 300);
    private boolean startingFromZero = false;
    private boolean transparentSectionsEnabled = false;
    private boolean transparentAreasEnabled = false;
    private Point2D ledPosition;
    private Point2D userLedPosition;
    private String lcdUnitString;
    private double lcdValue;
    private String lcdInfoString;
    protected static final Font LCD_STANDARD_FONT = new Font("Verdana", 0, 24);
    protected static final Font LCD_DIGITAL_FONT = Util.INSTANCE.getDigitalFont().deriveFont(24);
    private Timeline lcdTimeline;
    private boolean lcdTextVisible;
    private Timer LCD_BLINKING_TIMER;
    private Timeline timeline;
    private final TimelineEase STANDARD_EASING;
    private final TimelineEase RETURN_TO_ZERO_EASING;
    private TimelineCallback timelineCallback;

    public AbstractLinear() {
        this.ledPosition = new Point2D.Double(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
        this.userLedPosition = new Point2D.Double(18.0 / (double)this.getInnerBounds().width, 0.453271028);
        this.lcdValue = 0.0;
        this.lcdTimeline = new Timeline(this);
        this.lcdUnitString = this.getUnitString();
        this.lcdInfoString = "";
        this.timeline = new Timeline(this);
        this.STANDARD_EASING = new Spline(0.5f);
        this.RETURN_TO_ZERO_EASING = new Sine();
        this.lcdTextVisible = true;
        this.LCD_BLINKING_TIMER = new Timer(500, this);
        this.addComponentListener(this);
    }

    public void setValueAnimated(double VALUE) {
        if (this.isEnabled()) {
            double TARGET_VALUE;
            if (this.timeline.getState() != Timeline.TimelineState.IDLE) {
                this.timeline.abort();
            }
            double d = VALUE < this.getMinValue() ? this.getMinValue() : (TARGET_VALUE = VALUE > this.getMaxValue() ? this.getMaxValue() : VALUE);
            if (!this.isAutoResetToZero()) {
                this.timeline.removeCallback(this.timelineCallback);
                this.timeline = new Timeline(this);
                this.timeline.addPropertyToInterpolate("value", this.getValue(), TARGET_VALUE);
                this.timeline.setEase(this.STANDARD_EASING);
                this.timeline.setDuration(this.getStdTimeToValue());
                this.timelineCallback = new TimelineCallback(){

                    @Override
                    public void onTimelineStateChanged(Timeline.TimelineState OLD_STATE, Timeline.TimelineState NEW_STATE, float OLD_VALUE, float NEW_VALUE) {
                        if (NEW_STATE == Timeline.TimelineState.IDLE) {
                            AbstractLinear.this.repaint(AbstractLinear.this.getInnerBounds());
                        }
                        if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                            AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                        }
                    }

                    @Override
                    public void onTimelinePulse(float OLD_VALUE, float NEW_VALUE) {
                        if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                            AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                        }
                        if (AbstractLinear.this.getValue() < AbstractLinear.this.getMinMeasuredValue()) {
                            AbstractLinear.this.setMinMeasuredValue(AbstractLinear.this.getValue());
                        }
                    }
                };
                this.timeline.addCallback(this.timelineCallback);
                this.timeline.play();
            } else {
                TimelineScenario.Sequence AUTOZERO_SCENARIO = new TimelineScenario.Sequence();
                Timeline TIMELINE_TO_VALUE = new Timeline(this);
                TIMELINE_TO_VALUE.addPropertyToInterpolate("value", this.getValue(), TARGET_VALUE);
                TIMELINE_TO_VALUE.setEase(this.RETURN_TO_ZERO_EASING);
                TIMELINE_TO_VALUE.setDuration(this.getRtzTimeToValue());
                TIMELINE_TO_VALUE.addCallback(new TimelineCallback(){

                    @Override
                    public void onTimelineStateChanged(Timeline.TimelineState oldState, Timeline.TimelineState newState, float oldValue, float newValue) {
                        if (oldState == Timeline.TimelineState.PLAYING_FORWARD && newState == Timeline.TimelineState.DONE) {
                            AbstractLinear.this.getModel().setPeakValue(AbstractLinear.this.getValue());
                            AbstractLinear.this.getModel().setPeakValueVisible(true);
                            if (AbstractLinear.this.getPeakTimer().isRunning()) {
                                AbstractLinear.this.stopPeakTimer();
                            }
                            AbstractLinear.this.startPeakTimer();
                            if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                                AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                            }
                        }
                    }

                    @Override
                    public void onTimelinePulse(float oldValue, float newValue) {
                        if (AbstractLinear.this.getValue() > AbstractLinear.this.getMaxMeasuredValue()) {
                            AbstractLinear.this.setMaxMeasuredValue(AbstractLinear.this.getValue());
                        }
                        if (AbstractLinear.this.getValue() < AbstractLinear.this.getMinMeasuredValue()) {
                            AbstractLinear.this.setMinMeasuredValue(AbstractLinear.this.getValue());
                        }
                    }
                });
                Timeline TIMELINE_TO_ZERO = new Timeline(this);
                TIMELINE_TO_ZERO.addPropertyToInterpolate("value", TARGET_VALUE, 0.0);
                TIMELINE_TO_ZERO.setEase(this.RETURN_TO_ZERO_EASING);
                TIMELINE_TO_ZERO.setDuration(this.getRtzTimeBackToZero());
                ((TimelineScenario)AUTOZERO_SCENARIO).addScenarioActor(TIMELINE_TO_VALUE);
                ((TimelineScenario)AUTOZERO_SCENARIO).addScenarioActor(TIMELINE_TO_ZERO);
                AUTOZERO_SCENARIO.play();
            }
        }
    }

    public ColorDef getValueColor() {
        return this.getModel().getValueColor();
    }

    public void setValueColor(ColorDef VALUE_COLOR) {
        this.getModel().setValueColor(VALUE_COLOR);
        this.repaint(this.getInnerBounds());
    }

    public CustomColorDef getCustomValueColorObject() {
        return this.getModel().getCustomValueColorObject();
    }

    public Color getCustomValueColor() {
        return this.getModel().getCustomValueColor();
    }

    public void setCustomValueColor(Color COLOR) {
        this.getModel().setCustomValueColorObject(new CustomColorDef(COLOR));
        this.repaint(this.getInnerBounds());
    }

    public boolean isStartingFromZero() {
        return this.startingFromZero;
    }

    public void setStartingFromZero(boolean STARTING_FROM_ZERO) {
        this.startingFromZero = STARTING_FROM_ZERO;
    }

    public int getMaxNoOfMinorTicks() {
        return this.getModel().getMaxNoOfMinorTicks();
    }

    public void setMaxNoOfMinorTicks(int MAX_NO_OF_MINOR_TICKS) {
        this.getModel().setMaxNoOfMinorTicks(MAX_NO_OF_MINOR_TICKS);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public int getMaxNoOfMajorTicks() {
        return this.getModel().getMaxNoOfMajorTicks();
    }

    public void setMaxNoOfMajorTicks(int MAX_NO_OF_MAJOR_TICKS) {
        this.getModel().setMaxNoOfMajorTicks(MAX_NO_OF_MAJOR_TICKS);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getLedPosition() {
        return this.ledPosition;
    }

    @Override
    public void setLedPosition(double X, double Y) {
        this.ledPosition.setLocation(X, Y);
        this.repaint(this.getInnerBounds());
    }

    public void setLedPosition(Point2D LED_POSITION) {
        this.ledPosition.setLocation(LED_POSITION);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Point2D getUserLedPosition() {
        return this.userLedPosition;
    }

    @Override
    public void setUserLedPosition(double X, double Y) {
        this.userLedPosition.setLocation(X, Y);
        this.repaint(this.getInnerBounds());
    }

    public void setUserLedPosition(Point2D USER_LED_POSITION) {
        this.userLedPosition.setLocation(USER_LED_POSITION);
        this.repaint(this.getInnerBounds());
    }

    protected void createLedImages() {
        if (this.getOrientation() == Orientation.VERTICAL) {
            this.recreateLedImages(this.getWidth());
        } else {
            this.recreateLedImages(this.getHeight());
        }
    }

    public boolean isLcdVisible() {
        return this.getModel().isLcdVisible();
    }

    public void setLcdVisible(boolean LCD_VISIBLE) {
        this.getModel().setLcdVisible(LCD_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isLcdTextVisible() {
        return this.lcdTextVisible;
    }

    @Override
    public boolean isValueCoupled() {
        return this.getModel().isValueCoupled();
    }

    @Override
    public void setValueCoupled(boolean VALUE_COUPLED) {
        this.getModel().setValueCoupled(VALUE_COUPLED);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public double getLcdValue() {
        return this.lcdValue;
    }

    @Override
    public void setLcdValue(double LCD_VALUE) {
        this.lcdValue = LCD_VALUE;
        if (this.getLcdNumberSystem() != NumberSystem.DEC && LCD_VALUE < 0.0) {
            this.setLcdNumberSystem(NumberSystem.DEC);
        }
        this.repaint(this.getLcdBounds());
    }

    @Override
    public void setLcdValueAnimated(double LCD_VALUE) {
        if (this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_FORWARD || this.lcdTimeline.getState() == Timeline.TimelineState.PLAYING_REVERSE) {
            this.lcdTimeline.abort();
        }
        this.lcdTimeline = new Timeline(this);
        this.lcdTimeline.addPropertyToInterpolate("lcdValue", this.lcdValue, LCD_VALUE);
        this.lcdTimeline.setEase(new Spline(0.5f));
        this.lcdTimeline.play();
    }

    @Override
    public double getLcdThreshold() {
        return this.getModel().getLcdThreshold();
    }

    @Override
    public void setLcdThreshold(double LCD_THRESHOLD) {
        this.getModel().setLcdThreshold(LCD_THRESHOLD);
        if (this.getModel().isLcdThresholdVisible()) {
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public boolean isLcdThresholdVisible() {
        return this.getModel().isLcdThresholdVisible();
    }

    @Override
    public void setLcdThresholdVisible(boolean LCD_THRESHOLD_VISIBLE) {
        this.getModel().setLcdThresholdVisible(LCD_THRESHOLD_VISIBLE);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdThresholdBehaviourInverted() {
        return this.getModel().isLcdThresholdBehaviourInverted();
    }

    @Override
    public void setLcdThresholdBehaviourInverted(boolean LCD_THRESHOLD_BEHAVIOUR_INVERTED) {
        this.getModel().setLcdThresholdBehaviourInverted(LCD_THRESHOLD_BEHAVIOUR_INVERTED);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBlinking() {
        return this.getModel().isLcdBlinking();
    }

    @Override
    public void setLcdBlinking(boolean LCD_BLINKING) {
        if (LCD_BLINKING) {
            this.LCD_BLINKING_TIMER.start();
        } else {
            this.LCD_BLINKING_TIMER.stop();
            this.lcdTextVisible = true;
        }
        this.getModel().setLcdBlinking(LCD_BLINKING);
    }

    @Override
    public String getLcdUnitString() {
        return this.lcdUnitString;
    }

    @Override
    public void setLcdUnitString(String UNIT_STRING) {
        this.lcdUnitString = UNIT_STRING;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdUnitStringVisible() {
        return this.getModel().isLcdUnitStringVisible();
    }

    @Override
    public void setLcdUnitStringVisible(boolean UNIT_STRING_VISIBLE) {
        this.getModel().setLcdUnitStringVisible(UNIT_STRING_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isDigitalFont() {
        return this.getModel().isDigitalFontEnabled();
    }

    @Override
    public void setDigitalFont(boolean DIGITAL_FONT) {
        this.getModel().setDigitalFontEnabled(DIGITAL_FONT);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isCustomLcdUnitFontEnabled() {
        return this.getModel().isCustomLcdUnitFontEnabled();
    }

    @Override
    public void setCustomLcdUnitFontEnabled(boolean USE_CUSTOM_LCD_UNIT_FONT) {
        this.getModel().setCustomLcdUnitFontEnabled(USE_CUSTOM_LCD_UNIT_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getCustomLcdUnitFont() {
        return this.getModel().getCustomLcdUnitFont();
    }

    @Override
    public void setCustomLcdUnitFont(Font CUSTOM_LCD_UNIT_FONT) {
        this.getModel().setCustomLcdUnitFont(CUSTOM_LCD_UNIT_FONT);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public int getLcdDecimals() {
        return this.getModel().getLcdDecimals();
    }

    @Override
    public void setLcdDecimals(int DECIMALS) {
        this.getModel().setLcdDecimals(DECIMALS);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public LcdColor getLcdColor() {
        return this.getModel().getLcdColor();
    }

    @Override
    public void setLcdColor(LcdColor COLOR) {
        this.getModel().setLcdColor(COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Paint getCustomLcdBackground() {
        return this.getModel().getCustomLcdBackground();
    }

    @Override
    public void setCustomLcdBackground(Paint CUSTOM_LCD_BACKGROUND) {
        this.getModel().setCustomLcdBackground(CUSTOM_LCD_BACKGROUND);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public boolean isLcdBackgroundVisible() {
        return this.getModel().isLcdBackgroundVisible();
    }

    @Override
    public void setLcdBackgroundVisible(boolean LCD_BACKGROUND_VISIBLE) {
        this.getModel().setLcdBackgroundVisible(LCD_BACKGROUND_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Color getCustomLcdForeground() {
        return this.getModel().getCustomLcdForeground();
    }

    @Override
    public void setCustomLcdForeground(Color CUSTOM_LCD_FOREGROUND) {
        this.getModel().setCustomLcdForeground(CUSTOM_LCD_FOREGROUND);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String formatLcdValue(double VALUE) {
        StringBuilder DEC_BUFFER = new StringBuilder(16);
        DEC_BUFFER.append("0");
        if (this.getModel().getLcdDecimals() > 0) {
            DEC_BUFFER.append(".");
        }
        for (int i = 0; i < this.getModel().getLcdDecimals(); ++i) {
            DEC_BUFFER.append("0");
        }
        if (this.getModel().isLcdScientificFormatEnabled()) {
            DEC_BUFFER.append("E0");
        }
        DEC_BUFFER.trimToSize();
        DecimalFormat DEC_FORMAT = new DecimalFormat(DEC_BUFFER.toString(), new DecimalFormatSymbols(Locale.US));
        return DEC_FORMAT.format(VALUE);
    }

    @Override
    public boolean isLcdScientificFormat() {
        return this.getModel().isLcdScientificFormatEnabled();
    }

    @Override
    public void setLcdScientificFormat(boolean LCD_SCIENTIFIC_FORMAT) {
        this.getModel().setLcdScientificFormatEnabled(LCD_SCIENTIFIC_FORMAT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdValueFont() {
        return this.getModel().getLcdValueFont();
    }

    @Override
    public void setLcdValueFont(Font LCD_VALUE_FONT) {
        this.getModel().setLcdValueFont(LCD_VALUE_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdUnitFont() {
        return this.getModel().getLcdUnitFont();
    }

    @Override
    public void setLcdUnitFont(Font LCD_UNIT_FONT) {
        this.getModel().setLcdUnitFont(LCD_UNIT_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public Font getLcdInfoFont() {
        return this.getModel().getLcdInfoFont();
    }

    @Override
    public void setLcdInfoFont(Font LCD_INFO_FONT) {
        this.getModel().setLcdInfoFont(LCD_INFO_FONT);
        this.repaint(this.getInnerBounds());
    }

    @Override
    public String getLcdInfoString() {
        return this.lcdInfoString;
    }

    @Override
    public void setLcdInfoString(String LCD_INFO_STRING) {
        this.lcdInfoString = LCD_INFO_STRING;
        this.repaint(this.getInnerBounds());
    }

    @Override
    public NumberSystem getLcdNumberSystem() {
        return this.getModel().getNumberSystem();
    }

    @Override
    public void setLcdNumberSystem(NumberSystem NUMBER_SYSTEM) {
        this.getModel().setNumberSystem(NUMBER_SYSTEM);
        switch (NUMBER_SYSTEM) {
            case HEX: {
                this.lcdInfoString = "hex";
                break;
            }
            case OCT: {
                this.lcdInfoString = "oct";
                break;
            }
            default: {
                this.lcdInfoString = "";
            }
        }
        this.repaint(this.getInnerBounds());
    }

    @Override
    public abstract Rectangle getLcdBounds();

    @Override
    public void toggleDesign() {
        if (this.getActiveDesign().equals(this.getDesign1())) {
            this.setActiveDesign(this.getDesign2());
        } else {
            this.setActiveDesign(this.getDesign1());
        }
    }

    @Override
    public boolean isGlowVisible() {
        return this.getModel().isGlowVisible();
    }

    public void setGlowVisible(boolean GLOW_VISIBLE) {
        this.getModel().setGlowVisible(GLOW_VISIBLE);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Color getGlowColor() {
        return this.getModel().getGlowColor();
    }

    public void setGlowColor(Color GLOW_COLOR) {
        this.getModel().setGlowColor(GLOW_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGlowing() {
        return this.getModel().isGlowing();
    }

    public void setGlowing(boolean GLOWING) {
        this.getModel().setGlowing(GLOWING);
        this.repaint(this.getInnerBounds());
    }

    public Paint getOuterFrameColor() {
        return FRAME_FACTORY.getOuterFrameColor();
    }

    public void setOuterFrameColor(Paint OUTER_FRAME_COLOR) {
        FRAME_FACTORY.setOuterFrameColor(OUTER_FRAME_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public Paint getInnerFrameColor() {
        return FRAME_FACTORY.getInnerFrameColor();
    }

    public void setInnerFrameColor(Paint INNER_FRAME_COLOR) {
        FRAME_FACTORY.setInnerFrameColor(INNER_FRAME_COLOR);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentSectionsEnabled() {
        return this.transparentSectionsEnabled;
    }

    public void setTransparentSectionsEnabled(boolean TRANSPARENT_SECTIONS_ENABLED) {
        this.transparentSectionsEnabled = TRANSPARENT_SECTIONS_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isTransparentAreasEnabled() {
        return this.transparentAreasEnabled;
    }

    public void setTransparentAreasEnabled(boolean TRANSPARENT_AREAS_ENABLED) {
        this.transparentAreasEnabled = TRANSPARENT_AREAS_ENABLED;
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    protected BufferedImage create_FRAME_Image(int WIDTH, int HEIGHT) {
        return FRAME_FACTORY.createLinearFrame(WIDTH, HEIGHT, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameEffect());
    }

    protected BufferedImage create_FRAME_Image(int WIDTH, int HEIGHT, BufferedImage IMAGE) {
        return FRAME_FACTORY.createLinearFrame(WIDTH, HEIGHT, this.getFrameDesign(), this.getCustomFrameDesign(), this.getFrameBaseColor(), this.isFrameBaseColorEnabled(), this.getFrameEffect(), IMAGE);
    }

    protected BufferedImage create_BACKGROUND_Image(int WIDTH, int HEIGHT) {
        return this.create_BACKGROUND_Image(WIDTH, HEIGHT, null);
    }

    protected BufferedImage create_BACKGROUND_Image(int WIDTH, int HEIGHT, BufferedImage image) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, HEIGHT, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        BACKGROUND_FACTORY.createLinearBackground(WIDTH, HEIGHT, this.getBackgroundColor(), this.getModel().getCustomBackground(), this.getModel().getTextureColor(), image);
        if (this.isCustomLayerVisible()) {
            G2.drawImage((Image)UTIL.getScaledInstance(this.getCustomLayer(), IMAGE_WIDTH, IMAGE_HEIGHT, RenderingHints.VALUE_INTERPOLATION_BICUBIC), 0, 0, null);
        }
        G2.dispose();
        return image;
    }

    protected BufferedImage create_GLOW_Image(int WIDTH, int HEIGHT, Color GLOW_COLOR, boolean ON) {
        return GLOW_FACTORY.createLinearGlow(WIDTH, HEIGHT, GLOW_COLOR, ON);
    }

    protected BufferedImage create_TRACK_Image(int WIDTH, int HEIGHT, double MIN_VALUE, double MAX_VALUE, double TRACK_START, double TRACK_SECTION, double TRACK_STOP, Color TRACK_START_COLOR, Color TRACK_SECTION_COLOR, Color TRACK_STOP_COLOR) {
        return this.create_TRACK_Image(WIDTH, HEIGHT, MIN_VALUE, MAX_VALUE, TRACK_START, TRACK_SECTION, TRACK_STOP, TRACK_START_COLOR, TRACK_SECTION_COLOR, TRACK_STOP_COLOR, null);
    }

    protected BufferedImage create_TRACK_Image(int WIDTH, int HEIGHT, double MIN_VALUE, double MAX_VALUE, double TRACK_START, double TRACK_SECTION, double TRACK_STOP, Color TRACK_START_COLOR, Color TRACK_SECTION_COLOR, Color TRACK_STOP_COLOR, BufferedImage image) {
        Point2D.Double TRACK_STOP_POINT;
        Point2D.Double TRACK_START_POINT;
        Rectangle2D.Double TRACK;
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (TRACK_STOP > MAX_VALUE) {
            throw new IllegalArgumentException("Please adjust track start and/or track stop values");
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, HEIGHT, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        if (this.getOrientation() == Orientation.VERTICAL) {
            TRACK = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.315, (double)IMAGE_HEIGHT * 0.1276, (double)IMAGE_WIDTH * 0.05, (double)IMAGE_HEIGHT * 0.728);
            TRACK_START_POINT = new Point2D.Double(0.0, TRACK.getMaxY());
            TRACK_STOP_POINT = new Point2D.Double(0.0, TRACK.getMinY());
        } else {
            TRACK = new Rectangle2D.Double((double)IMAGE_WIDTH * 0.139, (double)IMAGE_HEIGHT * 0.6285714285714286, (double)IMAGE_WIDTH * 0.735, (double)IMAGE_HEIGHT * 0.05);
            TRACK_START_POINT = new Point2D.Double(TRACK.getMinX(), 0.0);
            TRACK_STOP_POINT = new Point2D.Double(TRACK.getMaxX(), 0.0);
        }
        float TRACK_START_POSITION = (float)((TRACK_START - MIN_VALUE) / (MAX_VALUE - MIN_VALUE));
        float TRACK_STOP_POSITION = (float)((TRACK_STOP - MIN_VALUE) / (MAX_VALUE - MIN_VALUE));
        Color FULLY_TRANSPARENT = new Color(0.0f, 0.0f, 0.0f, 0.0f);
        float TRACK_SECTION_POSITION = (float)((TRACK_SECTION - MIN_VALUE) / (MAX_VALUE - MIN_VALUE));
        float[] TRACK_FRACTIONS = new float[]{0.0f, TRACK_START_POSITION + 0.001f, TRACK_START_POSITION + 0.002f, TRACK_SECTION_POSITION, TRACK_STOP_POSITION - 0.002f, TRACK_STOP_POSITION - 0.001f, 1.0f};
        Color[] TRACK_COLORS = new Color[]{FULLY_TRANSPARENT, FULLY_TRANSPARENT, TRACK_START_COLOR, TRACK_SECTION_COLOR, TRACK_STOP_COLOR, FULLY_TRANSPARENT, FULLY_TRANSPARENT};
        LinearGradientPaint TRACK_GRADIENT = new LinearGradientPaint(TRACK_START_POINT, TRACK_STOP_POINT, TRACK_FRACTIONS, TRACK_COLORS);
        G2.setPaint(TRACK_GRADIENT);
        G2.fill(TRACK);
        G2.dispose();
        return image;
    }

    protected BufferedImage create_TITLE_Image(int WIDTH, int HEIGHT, boolean UNIT_STRING_VISIBLE) {
        return this.create_TITLE_Image(WIDTH, HEIGHT, UNIT_STRING_VISIBLE, null);
    }

    protected BufferedImage create_TITLE_Image(int WIDTH, int HEIGHT, boolean UNIT_STRING_VISIBLE, BufferedImage image) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return UTIL.createImage(1, 1, 3);
        }
        if (image == null) {
            image = UTIL.createImage(WIDTH, HEIGHT, 3);
        }
        Graphics2D G2 = image.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        G2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        int IMAGE_WIDTH = image.getWidth();
        int IMAGE_HEIGHT = image.getHeight();
        FontRenderContext RENDER_CONTEXT = new FontRenderContext(null, true, true);
        if (this.isLabelColorFromThemeEnabled()) {
            G2.setColor(this.getBackgroundColor().LABEL_COLOR);
        } else {
            G2.setColor(this.getLabelColor());
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), this.getTitleAndUnitFont().getStyle(), this.getTitleAndUnitFont().getSize()));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.1 * (double)IMAGE_WIDTH)));
            }
            if (!this.getTitle().isEmpty()) {
                TextLayout LAYOUT_TITLE = new TextLayout(this.getTitle(), G2.getFont(), RENDER_CONTEXT);
                AffineTransform OLD_TRANSFORM = G2.getTransform();
                G2.translate(0.0, -0.05 * (double)IMAGE_HEIGHT);
                G2.rotate(1.5707963267948966, 0.67142856f * (float)IMAGE_WIDTH, 0.1375f * (float)IMAGE_HEIGHT + LAYOUT_TITLE.getAscent() - LAYOUT_TITLE.getDescent());
                G2.drawString(this.getTitle(), 0.67142856f * (float)IMAGE_WIDTH, 0.1375f * (float)IMAGE_HEIGHT + LAYOUT_TITLE.getAscent() - LAYOUT_TITLE.getDescent());
                G2.setTransform(OLD_TRANSFORM);
            }
            if (UNIT_STRING_VISIBLE && !this.getUnitString().isEmpty()) {
                if (this.isTitleAndUnitFontEnabled()) {
                    G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.07142857142857142 * (double)IMAGE_WIDTH)));
                } else {
                    G2.setFont(new Font("Verdana", 0, (int)(0.07142857142857142 * (double)IMAGE_WIDTH)));
                }
                TextLayout LAYOUT_UNIT = new TextLayout(this.getUnitString(), G2.getFont(), RENDER_CONTEXT);
                Rectangle2D UNIT_BOUNDARY = LAYOUT_UNIT.getBounds();
                G2.drawString(this.getUnitString(), (float)((double)IMAGE_WIDTH - UNIT_BOUNDARY.getWidth()) / 2.0f, 0.8875f * (float)IMAGE_HEIGHT + LAYOUT_UNIT.getAscent() - LAYOUT_UNIT.getDescent());
            }
        } else {
            if (this.isTitleAndUnitFontEnabled()) {
                G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.1 * (double)IMAGE_HEIGHT)));
            } else {
                G2.setFont(new Font("Verdana", 0, (int)(0.1 * (double)IMAGE_HEIGHT)));
            }
            if (!this.getTitle().isEmpty()) {
                TextLayout LAYOUT_TITLE = new TextLayout(this.getTitle(), G2.getFont(), RENDER_CONTEXT);
                G2.drawString(this.getTitle(), 0.15f * (float)IMAGE_WIDTH, 0.25f * (float)IMAGE_HEIGHT + LAYOUT_TITLE.getAscent() - LAYOUT_TITLE.getDescent());
            }
            if (UNIT_STRING_VISIBLE && !this.getUnitString().isEmpty()) {
                if (this.isTitleAndUnitFontEnabled()) {
                    G2.setFont(new Font(this.getTitleAndUnitFont().getFamily(), 0, (int)(0.025 * (double)IMAGE_WIDTH)));
                } else {
                    G2.setFont(new Font("Verdana", 0, (int)(0.025 * (double)IMAGE_WIDTH)));
                }
                TextLayout LAYOUT_UNIT = new TextLayout(this.getUnitString(), G2.getFont(), RENDER_CONTEXT);
                G2.drawString(this.getUnitString(), 0.0625f * (float)IMAGE_WIDTH, 0.7f * (float)IMAGE_HEIGHT + LAYOUT_UNIT.getAscent() - LAYOUT_UNIT.getDescent());
            }
        }
        G2.dispose();
        return image;
    }

    protected BufferedImage create_LCD_Image(int WIDTH, int HEIGHT, LcdColor LCD_COLOR, Paint CUSTOM_LCD_BACKGROUND) {
        return this.create_LCD_Image(new Rectangle2D.Double(0.0, 0.0, WIDTH, HEIGHT), LCD_COLOR, CUSTOM_LCD_BACKGROUND, null);
    }

    protected BufferedImage create_LCD_Image(Rectangle2D BOUNDS, LcdColor LCD_COLOR, Paint CUSTOM_LCD_BACKGROUND, BufferedImage IMAGE) {
        return LCD_FACTORY.create_LCD_Image(BOUNDS, LCD_COLOR, CUSTOM_LCD_BACKGROUND, IMAGE);
    }

    protected BufferedImage create_THRESHOLD_Image(int WIDTH, int HEIGHT) {
        Point2D.Double THRESHOLD_STOP;
        Point2D.Double THRESHOLD_START;
        int IMAGE_HEIGHT;
        int IMAGE_WIDTH;
        if (WIDTH <= 14 || HEIGHT <= 14) {
            return UTIL.createImage(1, 1, 3);
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            IMAGE_WIDTH = (int)((double)WIDTH * 0.0714285714);
            IMAGE_HEIGHT = (int)((double)IMAGE_WIDTH * 0.8);
        } else {
            IMAGE_HEIGHT = (int)((double)HEIGHT * 0.0714285714);
            IMAGE_WIDTH = (int)((double)IMAGE_HEIGHT * 0.8);
        }
        BufferedImage IMAGE = UTIL.createImage(IMAGE_WIDTH, IMAGE_HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.translate(0.0, (double)IMAGE_WIDTH * 0.005);
        GeneralPath THRESHOLD = new GeneralPath();
        THRESHOLD.setWindingRule(0);
        if (this.getOrientation() == Orientation.VERTICAL) {
            THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.1, (double)IMAGE_HEIGHT * 0.5);
            THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.9, (double)IMAGE_HEIGHT * 0.1);
            THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.9, (double)IMAGE_HEIGHT * 0.9);
            THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.1, (double)IMAGE_HEIGHT * 0.5);
            THRESHOLD.closePath();
            THRESHOLD_START = new Point2D.Double(THRESHOLD.getBounds2D().getMinX(), 0.0);
            THRESHOLD_STOP = new Point2D.Double(THRESHOLD.getBounds2D().getMaxX(), 0.0);
        } else {
            THRESHOLD.moveTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.9);
            THRESHOLD.lineTo((double)IMAGE_WIDTH * 1.0, (double)IMAGE_HEIGHT * 0.1);
            THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.1, (double)IMAGE_HEIGHT * 0.1);
            THRESHOLD.lineTo((double)IMAGE_WIDTH * 0.5, (double)IMAGE_HEIGHT * 0.9);
            THRESHOLD.closePath();
            THRESHOLD_START = new Point2D.Double(0.0, THRESHOLD.getBounds2D().getMaxY());
            THRESHOLD_STOP = new Point2D.Double(0.0, THRESHOLD.getBounds2D().getMinY());
        }
        float[] THRESHOLD_FRACTIONS = new float[]{0.0f, 0.3f, 0.59f, 1.0f};
        Color[] THRESHOLD_COLORS = new Color[]{this.getThresholdColor().DARK, this.getThresholdColor().MEDIUM, this.getThresholdColor().MEDIUM, this.getThresholdColor().DARK};
        LinearGradientPaint THRESHOLD_GRADIENT = new LinearGradientPaint(THRESHOLD_START, THRESHOLD_STOP, THRESHOLD_FRACTIONS, THRESHOLD_COLORS);
        G2.setPaint(THRESHOLD_GRADIENT);
        G2.fill(THRESHOLD);
        G2.setColor(Color.WHITE);
        G2.setStroke(new BasicStroke(1.0f, 0, 0));
        G2.draw(THRESHOLD);
        G2.dispose();
        return IMAGE;
    }

    protected BufferedImage create_MEASURED_VALUE_Image(int WIDTH, int HEIGHT, Color COLOR) {
        int IMAGE_HEIGHT;
        int IMAGE_WIDTH;
        if (WIDTH <= 20 || HEIGHT <= 20) {
            return UTIL.createImage(1, 1, 3);
        }
        if (this.getOrientation() == Orientation.VERTICAL) {
            IMAGE_HEIGHT = IMAGE_WIDTH = (int)((double)WIDTH * 0.05);
        } else {
            IMAGE_WIDTH = IMAGE_HEIGHT = (int)((double)HEIGHT * 0.05);
        }
        BufferedImage IMAGE = UTIL.createImage(IMAGE_WIDTH, IMAGE_HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        GeneralPath INDICATOR = new GeneralPath();
        INDICATOR.setWindingRule(0);
        if (this.getOrientation() == Orientation.VERTICAL) {
            INDICATOR.moveTo((double)IMAGE_WIDTH, (double)IMAGE_HEIGHT * 0.5);
            INDICATOR.lineTo(0.0, 0.0);
            INDICATOR.lineTo(0.0, (double)IMAGE_HEIGHT);
            INDICATOR.closePath();
        } else {
            INDICATOR.moveTo((double)IMAGE_WIDTH * 0.5, 0.0);
            INDICATOR.lineTo(IMAGE_WIDTH, IMAGE_HEIGHT);
            INDICATOR.lineTo(0.0, (double)IMAGE_HEIGHT);
            INDICATOR.closePath();
        }
        G2.setColor(COLOR);
        G2.fill(INDICATOR);
        G2.dispose();
        return IMAGE;
    }

    protected BufferedImage create_FOREGROUND_Image(int WIDTH, int HEIGHT) {
        return FOREGROUND_FACTORY.createLinearForeground(WIDTH, HEIGHT);
    }

    protected BufferedImage create_DISABLED_Image(int WIDTH, int HEIGHT) {
        return DISABLED_FACTORY.createLinearDisabled(WIDTH, HEIGHT);
    }

    @Override
    public void calcInnerBounds() {
        this.calcInnerBounds(this.getWidth(), this.getHeight());
    }

    public void calcInnerBounds(int WIDTH, int HEIGHT) {
        Insets INSETS = this.getInsets();
        if (!this.isFrameVisible()) {
            this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, WIDTH - INSETS.left - INSETS.right + 34, HEIGHT - INSETS.top - INSETS.bottom + 34);
        } else {
            this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, WIDTH - INSETS.left - INSETS.right, HEIGHT - INSETS.top - INSETS.bottom);
        }
    }

    @Override
    public final Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension dim = super.getMinimumSize();
        if (dim.width <= dim.height) {
            if (dim.width < 40 || dim.height < 60) {
                dim = new Dimension(40, 60);
            }
        } else if (dim.width < 60 || dim.height < 60) {
            dim = new Dimension(60, 40);
        }
        return dim;
    }

    @Override
    public void setMinimumSize(Dimension DIM) {
        int height;
        int width;
        if (this.getInnerBounds().width <= this.getInnerBounds().height) {
            width = DIM.width < 40 ? 40 : DIM.width;
            height = DIM.height < 60 ? 60 : DIM.height;
        } else {
            width = DIM.width < 60 ? 60 : DIM.width;
            height = DIM.height < 40 ? 40 : DIM.height;
        }
        super.setMinimumSize(new Dimension(width, height));
        this.calcInnerBounds(DIM.width, DIM.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension dim = super.getMaximumSize();
        if (dim.width <= dim.height) {
            if (dim.width > 1080 || dim.height > 1920) {
                dim = new Dimension(1080, 1920);
            }
        } else if (dim.width > 1920 || dim.height > 1080) {
            dim = new Dimension(1920, 1080);
        }
        return dim;
    }

    @Override
    public void setMaximumSize(Dimension DIM) {
        int height;
        int width;
        if (this.getInnerBounds().width <= this.getInnerBounds().height) {
            width = DIM.width > 1080 ? 1080 : DIM.width;
            height = DIM.height > 1920 ? 1920 : DIM.height;
        } else {
            width = DIM.width > 1920 ? 1920 : DIM.width;
            height = DIM.height > 1080 ? 1080 : DIM.height;
        }
        super.setMaximumSize(new Dimension(width, height));
        this.calcInnerBounds(DIM.width, DIM.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        super.setPreferredSize(DIM);
        this.calcInnerBounds(DIM.width, DIM.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
        this.invalidate();
        this.repaint();
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        super.setSize(WIDTH, HEIGHT);
        this.calcInnerBounds(WIDTH, HEIGHT);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setSize(Dimension DIM) {
        super.setSize(DIM);
        this.calcInnerBounds(DIM.width, DIM.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        super.setBounds(BOUNDS);
        this.calcInnerBounds(BOUNDS.width, BOUNDS.height);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        super.setBounds(X, Y, WIDTH, HEIGHT);
        this.calcInnerBounds(WIDTH, HEIGHT);
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.setInitialized(true);
    }

    @Override
    public void setBorder(Border BORDER) {
        super.setBorder(BORDER);
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void componentResized(ComponentEvent EVENT) {
        Container PARENT = this.getParent();
        if (PARENT != null && PARENT.getLayout() == null) {
            this.setSize(this.getWidth(), this.getHeight());
        } else {
            this.setPreferredSize(new Dimension(this.getWidth(), this.getHeight()));
        }
        this.calcInnerBounds();
        if (this.getWidth() >= this.getHeight()) {
            this.setOrientation(Orientation.HORIZONTAL);
            this.recreateLedImages(this.getInnerBounds().height);
            this.recreateUserLedImages(this.getInnerBounds().height);
            if (this.isLedOn()) {
                this.setCurrentLedImage(this.getLedImageOn());
            } else {
                this.setCurrentLedImage(this.getLedImageOff());
            }
            this.setLedPosition(((double)this.getInnerBounds().width - 20.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
            if (this.isUserLedOn()) {
                this.setCurrentUserLedImage(this.getUserLedImageOn());
            } else {
                this.setCurrentUserLedImage(this.getUserLedImageOff());
            }
            this.setUserLedPosition(18.0 / (double)this.getInnerBounds().width, 0.453271028);
        } else {
            this.setOrientation(Orientation.VERTICAL);
            this.recreateLedImages(this.getInnerBounds().width);
            this.recreateUserLedImages(this.getInnerBounds().width);
            if (this.isLedOn()) {
                this.setCurrentLedImage(this.getLedImageOn());
            } else {
                this.setCurrentLedImage(this.getLedImageOff());
            }
            this.setLedPosition(0.453271028, 20.0 / (double)this.getInnerBounds().height);
            if (this.isUserLedOn()) {
                this.setCurrentUserLedImage(this.getUserLedImageOn());
            } else {
                this.setCurrentUserLedImage(this.getUserLedImageOff());
            }
            this.setUserLedPosition(((double)this.getInnerBounds().width - 18.0 - 16.0) / (double)this.getInnerBounds().width, 0.453271028);
        }
        this.getModel().setSize(this.getLocation().x, this.getLocation().y, this.getWidth(), this.getHeight());
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.revalidate();
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        super.actionPerformed(EVENT);
        if (EVENT.getSource().equals(this.LCD_BLINKING_TIMER)) {
            this.lcdTextVisible ^= true;
            this.repaint(this.getInnerBounds());
        }
    }

    @Override
    public String toString() {
        return "AbstractLinear";
    }
}

