/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance;

import com.opensr5.ini.IniMemberNotFound;
import com.opensr5.ini.field.IniField;
import com.rusefi.ConnectivityContext;
import com.rusefi.PortResult;
import com.rusefi.binaryprotocol.BinaryProtocol;
import com.rusefi.core.SensorCentral;
import com.rusefi.io.UpdateOperationCallbacks;
import com.rusefi.maintenance.BinaryProtocolExecutor;
import com.rusefi.panama.PanamaHelper;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;

public class OutputChannelsHelper {
    private static final String MCUSERIAL = "MCUSERIAL";

    public static Optional<Integer> readMcuSerial(PortResult ecuPort, UpdateOperationCallbacks callbacks, ConnectivityContext connectivityContext) {
        return BinaryProtocolExecutor.executeWithSuspendedPortScanner(ecuPort.port, callbacks, binaryProtocol -> OutputChannelsHelper.readMcuSerial(binaryProtocol, callbacks), Optional.empty(), connectivityContext);
    }

    private static Optional<Integer> readMcuSerial(BinaryProtocol binaryProtocol, UpdateOperationCallbacks callbacks) {
        IniField mcuSerialField;
        callbacks.logLine("Reading `MCUSERIAL` output channel...");
        try {
            mcuSerialField = PanamaHelper.getIniField(binaryProtocol);
        }
        catch (IniMemberNotFound e) {
            callbacks.logLine("Please update firmware to use this feature...");
            return Optional.empty();
        }
        AtomicInteger mcuSerial = new AtomicInteger();
        SensorCentral.getInstance().addListener(() -> mcuSerial.set(PanamaHelper.getMcuSerial(mcuSerialField)));
        if (binaryProtocol.requestOutputChannels()) {
            callbacks.logLine(String.format("MCUSERIAL is %d", mcuSerial.get()));
            return Optional.of(mcuSerial.get());
        }
        callbacks.logLine("Failed to request output channels...");
        return Optional.empty();
    }
}

