/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.light;

import com.rusefi.NamedThreadFactory;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.ThreadFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;

public class InternetStatus {
    private static final ThreadFactory THREAD_FACTORY = new NamedThreadFactory("InternetStatus");
    private static final String GOOGLE = "http://google.com";
    private final JPanel panel = new JPanel();
    private final JLabel status = new JLabel();

    public InternetStatus() {
        this.panel.add(this.status);
        Font defaultFont = this.status.getFont();
        this.status.setFont(new Font(defaultFont.getName(), defaultFont.getStyle(), 2 * defaultFont.getSize()));
        THREAD_FACTORY.newThread(() -> {
            while (true) {
                final boolean isConnected = InternetStatus.isServerReachable();
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            if (isConnected) {
                                InternetStatus.this.status.setText("online");
                                InternetStatus.this.panel.setBackground(Color.green);
                            } else {
                                InternetStatus.this.status.setText("offline");
                                InternetStatus.this.panel.setBackground(Color.red);
                            }
                        }
                    });
                    Thread.sleep(1000L);
                }
                catch (InterruptedException | InvocationTargetException exception) {
                }
            }
        }).start();
    }

    private static boolean isServerReachable() {
        try {
            URL urlServer = new URL(GOOGLE);
            HttpURLConnection urlConn = (HttpURLConnection)urlServer.openConnection();
            urlConn.setConnectTimeout(3000);
            urlConn.connect();
            return urlConn.getResponseCode() == 200;
        }
        catch (IOException e1) {
            return false;
        }
    }

    public Component getContent() {
        return this.panel;
    }
}

