/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.extras;

import java.awt.Color;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Insets;
import java.awt.RadialGradientPaint;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.Timer;

public class TrafficLight2
extends JComponent
implements ActionListener {
    public static final String RED_PROPERTY = "red";
    public static final String YELLOW_PROPERTY = "yellow";
    public static final String GREEN_PROPERTY = "green";
    private boolean blink;
    private boolean blinking;
    private boolean redOn;
    private boolean redBlinkEnabled;
    private boolean yellowVisible;
    private boolean yellowOn;
    private boolean yellowBlinkEnabled;
    private boolean greenOn;
    private boolean greenBlinkEnabled;
    private PropertyChangeSupport propertySupport;
    private final Rectangle INNER_BOUNDS = new Rectangle(0, 0, 80, 200);
    private final Point2D CENTER;
    private BufferedImage housingImage;
    private BufferedImage greenOnImage;
    private BufferedImage greenOffImage;
    private BufferedImage yellowOnImage;
    private BufferedImage yellowOffImage;
    private BufferedImage redOnImage;
    private BufferedImage redOffImage;
    private boolean square;
    private final Timer TIMER;
    private int timerPeriod;
    private final transient ComponentListener COMPONENT_LISTENER = new ComponentAdapter(){

        @Override
        public void componentResized(ComponentEvent event) {
            int SIZE = TrafficLight2.this.getWidth() <= TrafficLight2.this.getHeight() ? TrafficLight2.this.getWidth() : TrafficLight2.this.getHeight();
            Container parent = TrafficLight2.this.getParent();
            if (parent != null && parent.getLayout() == null) {
                if (SIZE < TrafficLight2.this.getMinimumSize().width || SIZE < TrafficLight2.this.getMinimumSize().height) {
                    TrafficLight2.this.setSize(TrafficLight2.this.getMinimumSize());
                } else if (TrafficLight2.this.square) {
                    TrafficLight2.this.setSize(SIZE, SIZE);
                } else {
                    TrafficLight2.this.setSize(TrafficLight2.this.getWidth(), TrafficLight2.this.getHeight());
                }
            } else if (SIZE < TrafficLight2.this.getMinimumSize().width || SIZE < TrafficLight2.this.getMinimumSize().height) {
                TrafficLight2.this.setPreferredSize(TrafficLight2.this.getMinimumSize());
            } else if (TrafficLight2.this.square) {
                TrafficLight2.this.setPreferredSize(new Dimension(SIZE, SIZE));
            } else {
                TrafficLight2.this.setPreferredSize(new Dimension(TrafficLight2.this.getWidth(), TrafficLight2.this.getHeight()));
            }
            TrafficLight2.this.calcInnerBounds();
            TrafficLight2.this.init(((TrafficLight2)TrafficLight2.this).getInnerBounds().width, ((TrafficLight2)TrafficLight2.this).getInnerBounds().height);
        }
    };

    public TrafficLight2() {
        this.addComponentListener(this.COMPONENT_LISTENER);
        this.propertySupport = new PropertyChangeSupport(this);
        this.CENTER = new Point2D.Double();
        this.timerPeriod = 1000;
        this.TIMER = new Timer(this.timerPeriod, this);
        this.housingImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.greenOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.yellowOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOnImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.redOffImage = this.createImage(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height, 3);
        this.blink = false;
        this.blinking = false;
        this.redOn = false;
        this.redBlinkEnabled = false;
        this.yellowVisible = true;
        this.yellowOn = false;
        this.yellowBlinkEnabled = false;
        this.greenOn = false;
        this.greenBlinkEnabled = false;
        this.square = false;
    }

    public final void init(int WIDTH, int HEIGHT) {
        if (WIDTH <= 1 || HEIGHT <= 1) {
            return;
        }
        if (this.housingImage != null) {
            this.housingImage.flush();
        }
        BufferedImage bufferedImage = this.housingImage = this.yellowVisible ? this.create3LightsHousingImage(WIDTH, HEIGHT) : this.create2LightsHousingImage(WIDTH, HEIGHT);
        if (this.greenOnImage != null) {
            this.greenOnImage.flush();
        }
        BufferedImage bufferedImage2 = this.greenOnImage = this.yellowVisible ? this.create3LightsGreenImage(WIDTH, HEIGHT, true) : this.create2LightsGreenImage(WIDTH, HEIGHT, true);
        if (this.greenOffImage != null) {
            this.greenOffImage.flush();
        }
        BufferedImage bufferedImage3 = this.greenOffImage = this.yellowVisible ? this.create3LightsGreenImage(WIDTH, HEIGHT, false) : this.create2LightsGreenImage(WIDTH, HEIGHT, false);
        if (this.yellowOnImage != null) {
            this.yellowOnImage.flush();
        }
        this.yellowOnImage = this.create3LightsYellowImage(WIDTH, HEIGHT, true);
        if (this.yellowOffImage != null) {
            this.yellowOffImage.flush();
        }
        this.yellowOffImage = this.create3LightsYellowImage(WIDTH, HEIGHT, false);
        if (this.redOnImage != null) {
            this.redOnImage.flush();
        }
        BufferedImage bufferedImage4 = this.redOnImage = this.yellowVisible ? this.create3LightsRedImage(WIDTH, HEIGHT, true) : this.create2LightsRedImage(WIDTH, HEIGHT, true);
        if (this.redOffImage != null) {
            this.redOffImage.flush();
        }
        this.redOffImage = this.yellowVisible ? this.create3LightsRedImage(WIDTH, HEIGHT, false) : this.create2LightsRedImage(WIDTH, HEIGHT, false);
        this.CENTER.setLocation((double)WIDTH / 2.0, (double)HEIGHT / 2.0);
    }

    @Override
    protected void paintComponent(Graphics g) {
        Graphics2D G2 = (Graphics2D)g.create();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        G2.translate(this.getInnerBounds().x, this.getInnerBounds().y);
        G2.drawImage((Image)this.housingImage, 0, 0, null);
        if (this.greenOn) {
            G2.drawImage((Image)this.greenOnImage, 0, 0, null);
        } else {
            G2.drawImage((Image)this.greenOffImage, 0, 0, null);
        }
        if (this.yellowVisible) {
            if (this.yellowOn) {
                G2.drawImage((Image)this.yellowOnImage, 0, 0, null);
            } else {
                G2.drawImage((Image)this.yellowOffImage, 0, 0, null);
            }
        }
        if (this.redOn) {
            G2.drawImage((Image)this.redOnImage, 0, 0, null);
        } else {
            G2.drawImage((Image)this.redOffImage, 0, 0, null);
        }
        G2.dispose();
    }

    public boolean isBlinking() {
        return this.blinking;
    }

    public void setBlinking(boolean BLINKING) {
        this.blinking = BLINKING;
        if (this.blinking) {
            this.TIMER.start();
        } else {
            this.TIMER.stop();
        }
    }

    public boolean isRedOn() {
        return this.redOn;
    }

    public void setRedOn(boolean RED_ON) {
        boolean oldRedOn = this.redOn;
        this.redOn = RED_ON;
        this.propertySupport.firePropertyChange(RED_PROPERTY, oldRedOn, this.redOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isRedBlinkEnabled() {
        return this.redBlinkEnabled;
    }

    public void setRedBlinkEnabled(boolean RED_BLINK_ENABLED) {
        this.redOn = this.redBlinkEnabled = RED_BLINK_ENABLED;
    }

    public boolean isYellowVisible() {
        return this.yellowVisible;
    }

    public void setYellowVisible(boolean YELLOW_VISIBLE) {
        this.yellowVisible = YELLOW_VISIBLE;
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
        this.repaint(this.getInnerBounds());
    }

    public boolean isYellowOn() {
        return this.yellowOn;
    }

    public void setYellowOn(boolean YELLOW_ON) {
        boolean oldYellowOn = this.yellowOn;
        this.yellowOn = YELLOW_ON;
        this.propertySupport.firePropertyChange(YELLOW_PROPERTY, oldYellowOn, this.yellowOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isYellowBlinkEnabled() {
        return this.yellowBlinkEnabled;
    }

    public void setYellowBlinkEnabled(boolean YELLOW_BLINK_ENABLED) {
        this.yellowOn = this.yellowBlinkEnabled = YELLOW_BLINK_ENABLED;
    }

    public boolean isGreenOn() {
        return this.greenOn;
    }

    public void setGreenOn(boolean GREEN_ON) {
        boolean oldGreenOn = this.greenOn;
        this.greenOn = GREEN_ON;
        this.propertySupport.firePropertyChange(GREEN_PROPERTY, oldGreenOn, this.greenOn);
        this.repaint(this.getInnerBounds());
    }

    public boolean isGreenBlinkEnabled() {
        return this.greenBlinkEnabled;
    }

    public void setGreenBlinkEnabled(boolean GREEN_BLINK_ENABLED) {
        this.greenOn = this.greenBlinkEnabled = GREEN_BLINK_ENABLED;
    }

    public int getTimerPeriod() {
        return this.timerPeriod;
    }

    public void setTimerPeriod(int TIMER_PERIOD) {
        this.timerPeriod = TIMER_PERIOD < 100 ? 100 : (TIMER_PERIOD > 10000 ? 10000 : TIMER_PERIOD);
        this.TIMER.setDelay(this.timerPeriod);
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener LISTENER) {
        if (this.isShowing()) {
            this.propertySupport.addPropertyChangeListener(LISTENER);
        }
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener LISTENER) {
        this.propertySupport.removePropertyChangeListener(LISTENER);
    }

    private void calcInnerBounds() {
        Insets INSETS = this.getInsets();
        if (this.yellowVisible) {
            int PREF_HEIGHT = this.getWidth() < (int)((double)this.getHeight() * 0.4) ? (int)((double)this.getWidth() * 2.5) : this.getHeight();
            this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, (int)((double)PREF_HEIGHT * 0.4) - INSETS.left - INSETS.right, PREF_HEIGHT - INSETS.top - INSETS.bottom);
        } else {
            int PREF_HEIGHT = this.getWidth() < (int)((double)this.getHeight() * 0.5714285714) ? (int)((double)this.getWidth() * 1.75) : this.getHeight();
            this.INNER_BOUNDS.setBounds(INSETS.left, INSETS.top, (int)((double)PREF_HEIGHT * 0.5714285714) - INSETS.left - INSETS.right, PREF_HEIGHT - INSETS.top - INSETS.bottom);
        }
    }

    private Rectangle getInnerBounds() {
        return this.INNER_BOUNDS;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(this.INNER_BOUNDS.width, this.INNER_BOUNDS.height);
    }

    @Override
    public void setPreferredSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setPreferredSize(new Dimension(SIZE, SIZE));
        } else {
            super.setPreferredSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setSize(SIZE, SIZE);
        } else {
            super.setSize(WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setSize(Dimension DIM) {
        int SIZE;
        int n = SIZE = DIM.width <= DIM.height ? DIM.width : DIM.height;
        if (this.square) {
            super.setSize(new Dimension(SIZE, SIZE));
        } else {
            super.setSize(DIM);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(Rectangle BOUNDS) {
        int SIZE;
        int n = SIZE = BOUNDS.width <= BOUNDS.height ? BOUNDS.width : BOUNDS.height;
        if (this.square) {
            super.setBounds(BOUNDS.x, BOUNDS.y, SIZE, SIZE);
        } else {
            super.setBounds(BOUNDS);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    @Override
    public void setBounds(int X, int Y, int WIDTH, int HEIGHT) {
        int SIZE;
        int n = SIZE = WIDTH <= HEIGHT ? WIDTH : HEIGHT;
        if (this.square) {
            super.setBounds(X, Y, SIZE, SIZE);
        } else {
            super.setBounds(X, Y, WIDTH, HEIGHT);
        }
        this.calcInnerBounds();
        this.init(this.getInnerBounds().width, this.getInnerBounds().height);
    }

    private BufferedImage createImage(int WIDTH, int HEIGHT, int TRANSPARENCY) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, TRANSPARENCY);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, TRANSPARENCY);
        return IMAGE;
    }

    public BufferedImage create2LightsHousingImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        GeneralPath HOUSING_FRAME = new GeneralPath();
        HOUSING_FRAME.setWindingRule(0);
        HOUSING_FRAME.moveTo(0.125 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.125 * (double)IMAGE_WIDTH, 0.16428571428571428 * (double)IMAGE_HEIGHT, 0.2875 * (double)IMAGE_WIDTH, 0.07142857142857142 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.07142857142857142 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.7125 * (double)IMAGE_WIDTH, 0.07142857142857142 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.16428571428571428 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.875 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.875 * (double)IMAGE_WIDTH, 0.8357142857142857 * (double)IMAGE_HEIGHT, 0.7125 * (double)IMAGE_WIDTH, 0.9285714285714286 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.9285714285714286 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.2875 * (double)IMAGE_WIDTH, 0.9285714285714286 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.8357142857142857 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.125 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.closePath();
        HOUSING_FRAME.moveTo(0.0 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.0 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.0 * (double)IMAGE_WIDTH, 0.8714285714285714 * (double)IMAGE_HEIGHT, 0.225 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.775 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.8714285714285714 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(1.0 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(1.0 * (double)IMAGE_WIDTH, 0.12857142857142856 * (double)IMAGE_HEIGHT, 0.775 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.curveTo(0.225 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.12857142857142856 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT);
        HOUSING_FRAME.closePath();
        G2.setPaint(new Color(0.2f, 0.2f, 0.2f, 0.5f));
        G2.fill(HOUSING_FRAME);
        RoundRectangle2D.Double HOUSING_BACKGROUND = new RoundRectangle2D.Double(0.125 * (double)IMAGE_WIDTH, 0.07142857142857142 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.8571428571428571 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.42857142857142855 * (double)IMAGE_HEIGHT);
        G2.setPaint(new Color(0.8f, 0.8f, 0.8f, 0.5f));
        G2.fill(HOUSING_BACKGROUND);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create2LightsGreenImage(int WIDTH, int HEIGHT, boolean IS_ON) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        if (!IS_ON) {
            Ellipse2D.Double GREEN_OFF = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.5285714285714286 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.35714285714285715 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8214285714285714 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.09803922f, 0.3372549f, 0.0f, 1.0f), new Color(0.0f, 0.0039215684f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(GREEN_OFF);
            Ellipse2D.Double GREEN_HIGHLIGHT_OFF = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.5357142857142857 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.14285714285714285 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5642857142857143 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            G2.fill(GREEN_HIGHLIGHT_OFF);
        } else {
            Ellipse2D.Double GREEN_GLOW = new Ellipse2D.Double(0.0 * (double)IMAGE_WIDTH, 0.42857142857142855 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.5714285714285714 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.7142857142857143 * (double)IMAGE_HEIGHT), 0.5f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f)}));
            G2.fill(GREEN_GLOW);
            Ellipse2D.Double GREEN_ON = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.5285714285714286 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.35714285714285715 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8214285714285714 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.1254902f, 0.2784314f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f)}));
            G2.fill(GREEN_ON);
            Ellipse2D.Double GREEN_HIGHLIGHT_ON = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.5357142857142857 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.14285714285714285 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5642857142857143 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            G2.fill(GREEN_HIGHLIGHT_ON);
        }
        Ellipse2D.Double GREEN_INNER_SHADOW = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.5285714285714286 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.35714285714285715 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.7071428571428572 * (double)IMAGE_HEIGHT), 0.3125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(GREEN_INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create2LightsRedImage(int WIDTH, int HEIGHT, boolean IS_ON) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        if (!IS_ON) {
            Ellipse2D.Double RED_OFF = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.11428571428571428 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.35714285714285715 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.40714285714285714 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.3019608f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(RED_OFF);
            Ellipse2D.Double RED_HIGHLIGHT_OFF = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.12142857142857143 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.14285714285714285 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.15 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            G2.fill(RED_HIGHLIGHT_OFF);
        } else {
            Ellipse2D.Double RED_GLOW = new Ellipse2D.Double(0.0 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.5714285714285714 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.2857142857142857 * (double)IMAGE_HEIGHT), 0.5f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f)}));
            G2.fill(RED_GLOW);
            Ellipse2D.Double RED_ON = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.11428571428571428 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.35714285714285715 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.40714285714285714 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.25490198f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(RED_ON);
            GeneralPath RED_HIGHLIGHT_ON = new GeneralPath();
            RED_HIGHLIGHT_ON.setWindingRule(0);
            RED_HIGHLIGHT_ON.moveTo(0.2625 * (double)IMAGE_WIDTH, 0.18571428571428572 * (double)IMAGE_HEIGHT);
            RED_HIGHLIGHT_ON.curveTo(0.2625 * (double)IMAGE_WIDTH, 0.17142857142857143 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.12142857142857143 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.12142857142857143 * (double)IMAGE_HEIGHT);
            RED_HIGHLIGHT_ON.curveTo(0.625 * (double)IMAGE_WIDTH, 0.12142857142857143 * (double)IMAGE_HEIGHT, 0.725 * (double)IMAGE_WIDTH, 0.16428571428571428 * (double)IMAGE_HEIGHT, 0.725 * (double)IMAGE_WIDTH, 0.18571428571428572 * (double)IMAGE_HEIGHT);
            RED_HIGHLIGHT_ON.curveTo(0.725 * (double)IMAGE_WIDTH, 0.22857142857142856 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.2642857142857143 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.2642857142857143 * (double)IMAGE_HEIGHT);
            RED_HIGHLIGHT_ON.curveTo(0.375 * (double)IMAGE_WIDTH, 0.2642857142857143 * (double)IMAGE_HEIGHT, 0.2625 * (double)IMAGE_WIDTH, 0.2357142857142857 * (double)IMAGE_HEIGHT, 0.2625 * (double)IMAGE_WIDTH, 0.18571428571428572 * (double)IMAGE_HEIGHT);
            RED_HIGHLIGHT_ON.closePath();
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.15 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            G2.fill(RED_HIGHLIGHT_ON);
        }
        Ellipse2D.Double RED_INNER_SHADOW = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.11428571428571428 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.35714285714285715 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.29285714285714287 * (double)IMAGE_HEIGHT), 0.3125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(RED_INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create3LightsHousingImage(int WIDTH, int HEIGHT) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(0.125 * (double)IMAGE_WIDTH, 0.055 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.9 * (double)IMAGE_HEIGHT, 0.75 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT);
        G2.setPaint(new Color(0.8f, 0.8f, 0.8f, 0.5f));
        G2.fill(BACKGROUND);
        GeneralPath FRAME = new GeneralPath();
        FRAME.setWindingRule(0);
        FRAME.moveTo(0.125 * (double)IMAGE_WIDTH, 0.205 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.125 * (double)IMAGE_WIDTH, 0.12 * (double)IMAGE_HEIGHT, 0.2875 * (double)IMAGE_WIDTH, 0.055 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.055 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.7125 * (double)IMAGE_WIDTH, 0.055 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.12 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.205 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.875 * (double)IMAGE_WIDTH, 0.205 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.805 * (double)IMAGE_HEIGHT, 0.875 * (double)IMAGE_WIDTH, 0.805 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.875 * (double)IMAGE_WIDTH, 0.89 * (double)IMAGE_HEIGHT, 0.7125 * (double)IMAGE_WIDTH, 0.955 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.955 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.2875 * (double)IMAGE_WIDTH, 0.955 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.89 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.805 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.125 * (double)IMAGE_WIDTH, 0.805 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.205 * (double)IMAGE_HEIGHT, 0.125 * (double)IMAGE_WIDTH, 0.205 * (double)IMAGE_HEIGHT);
        FRAME.closePath();
        FRAME.moveTo(0.0 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.0 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.8 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.8 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.0 * (double)IMAGE_WIDTH, 0.91 * (double)IMAGE_HEIGHT, 0.225 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.775 * (double)IMAGE_WIDTH, 1.0 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.91 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.8 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(1.0 * (double)IMAGE_WIDTH, 0.8 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(1.0 * (double)IMAGE_WIDTH, 0.09 * (double)IMAGE_HEIGHT, 0.775 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT);
        FRAME.curveTo(0.225 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.09 * (double)IMAGE_HEIGHT, 0.0 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_HEIGHT);
        FRAME.closePath();
        G2.setPaint(new Color(0.2f, 0.2f, 0.2f, 0.5f));
        G2.fill(FRAME);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create3LightsGreenImage(int WIDTH, int HEIGHT, boolean IS_ON) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        if (!IS_ON) {
            Ellipse2D.Double OFF = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.68 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.885 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.09803922f, 0.3372549f, 0.0f, 1.0f), new Color(0.0f, 0.0039215684f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(OFF);
            Ellipse2D.Double HIGHLIGHT_OFF = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.685 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.1 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.705 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            G2.fill(HIGHLIGHT_OFF);
        } else {
            Ellipse2D.Double GLOW = new Ellipse2D.Double(0.0 * (double)IMAGE_WIDTH, 0.6 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.4 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.8 * (double)IMAGE_HEIGHT), 0.5f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f), new Color(0.0f, 1.0f, 0.0f, 0.0f)}));
            G2.fill(GLOW);
            Ellipse2D.Double ON = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.68 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.885 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.0f, 1.0f, 0.0f, 1.0f), new Color(0.1254902f, 0.2784314f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f), new Color(0.1254902f, 0.27058825f, 0.14117648f, 1.0f)}));
            G2.fill(ON);
            Ellipse2D.Double HIGHLIGHT_ON = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.685 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.1 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.705 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            G2.fill(HIGHLIGHT_ON);
        }
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.68 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.805 * (double)IMAGE_HEIGHT), 0.3125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create3LightsYellowImage(int WIDTH, int HEIGHT, boolean IS_ON) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        if (!IS_ON) {
            Ellipse2D.Double OFF = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.38 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.585 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.3254902f, 0.33333334f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0039215684f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(OFF);
            Ellipse2D.Double HIGHLIGHT_OFF = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.385 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.1 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.405 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            G2.fill(HIGHLIGHT_OFF);
        } else {
            Ellipse2D.Double GLOW = new Ellipse2D.Double(0.0 * (double)IMAGE_WIDTH, 0.3 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.4 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.5 * (double)IMAGE_HEIGHT), 0.5f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(1.0f, 1.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f, 0.0f), new Color(1.0f, 1.0f, 0.0f, 0.0f)}));
            G2.fill(GLOW);
            Ellipse2D.Double ON = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.38 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.585 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 0.0f, 1.0f), new Color(0.33333334f, 0.34117648f, 0.0f, 1.0f), new Color(0.3254902f, 0.33333334f, 0.0f, 1.0f), new Color(0.3254902f, 0.33333334f, 0.0f, 1.0f)}));
            G2.fill(ON);
            Ellipse2D.Double HIGHLIGHT_ON = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.385 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.1 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.405 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            G2.fill(HIGHLIGHT_ON);
        }
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.38 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.505 * (double)IMAGE_HEIGHT), 0.3125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    public BufferedImage create3LightsRedImage(int WIDTH, int HEIGHT, boolean IS_ON) {
        GraphicsConfiguration GFX_CONF = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice().getDefaultConfiguration();
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return GFX_CONF.createCompatibleImage(1, 1, 3);
        }
        BufferedImage IMAGE = GFX_CONF.createCompatibleImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = IMAGE.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        G2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        G2.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_NORMALIZE);
        int IMAGE_WIDTH = IMAGE.getWidth();
        int IMAGE_HEIGHT = IMAGE.getHeight();
        if (!IS_ON) {
            Ellipse2D.Double OFF = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.08 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.285 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(0.3019608f, 0.0f, 0.0f, 1.0f), new Color(0.0039215684f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f), new Color(0.0f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(OFF);
            Ellipse2D.Double HIGHLIGHT_OFF = new Ellipse2D.Double(0.2625 * (double)IMAGE_WIDTH, 0.085 * (double)IMAGE_HEIGHT, 0.4625 * (double)IMAGE_WIDTH, 0.1 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.105 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.22352941f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f), new Color(1.0f, 1.0f, 1.0f, 0.02745098f)}));
            G2.fill(HIGHLIGHT_OFF);
        } else {
            Ellipse2D.Double GLOW = new Ellipse2D.Double(0.0 * (double)IMAGE_WIDTH, 0.0 * (double)IMAGE_HEIGHT, 1.0 * (double)IMAGE_WIDTH, 0.4 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.2 * (double)IMAGE_HEIGHT), 0.5f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f), new Color(1.0f, 0.0f, 0.0f, 0.0f)}));
            G2.fill(GLOW);
            Ellipse2D.Double ON = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.08 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.285 * (double)IMAGE_HEIGHT), 0.59375f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 0.99f, 1.0f}, new Color[]{new Color(1.0f, 0.0f, 0.0f, 1.0f), new Color(0.25490198f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f), new Color(0.24705882f, 0.0f, 0.0f, 1.0f)}));
            G2.fill(ON);
            GeneralPath HIGHLIGHT_ON = new GeneralPath();
            HIGHLIGHT_ON.setWindingRule(0);
            HIGHLIGHT_ON.moveTo(0.2625 * (double)IMAGE_WIDTH, 0.13 * (double)IMAGE_HEIGHT);
            HIGHLIGHT_ON.curveTo(0.2625 * (double)IMAGE_WIDTH, 0.12 * (double)IMAGE_HEIGHT, 0.375 * (double)IMAGE_WIDTH, 0.085 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.085 * (double)IMAGE_HEIGHT);
            HIGHLIGHT_ON.curveTo(0.625 * (double)IMAGE_WIDTH, 0.085 * (double)IMAGE_HEIGHT, 0.725 * (double)IMAGE_WIDTH, 0.115 * (double)IMAGE_HEIGHT, 0.725 * (double)IMAGE_WIDTH, 0.13 * (double)IMAGE_HEIGHT);
            HIGHLIGHT_ON.curveTo(0.725 * (double)IMAGE_WIDTH, 0.16 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.185 * (double)IMAGE_HEIGHT, 0.5 * (double)IMAGE_WIDTH, 0.185 * (double)IMAGE_HEIGHT);
            HIGHLIGHT_ON.curveTo(0.375 * (double)IMAGE_WIDTH, 0.185 * (double)IMAGE_HEIGHT, 0.2625 * (double)IMAGE_WIDTH, 0.165 * (double)IMAGE_HEIGHT, 0.2625 * (double)IMAGE_WIDTH, 0.13 * (double)IMAGE_HEIGHT);
            HIGHLIGHT_ON.closePath();
            G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.105 * (double)IMAGE_HEIGHT), 0.2125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.98f, 1.0f}, new Color[]{new Color(1.0f, 1.0f, 1.0f, 0.6745098f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f), new Color(1.0f, 1.0f, 1.0f, 0.08627451f)}));
            G2.fill(HIGHLIGHT_ON);
        }
        Ellipse2D.Double INNER_SHADOW = new Ellipse2D.Double(0.1875 * (double)IMAGE_WIDTH, 0.08 * (double)IMAGE_HEIGHT, 0.625 * (double)IMAGE_WIDTH, 0.25 * (double)IMAGE_HEIGHT);
        G2.setPaint(new RadialGradientPaint(new Point2D.Double(0.5 * (double)IMAGE_WIDTH, 0.205 * (double)IMAGE_HEIGHT), 0.3125f * (float)IMAGE_WIDTH, new float[]{0.0f, 0.55f, 0.5501f, 0.78f, 0.79f, 1.0f}, new Color[]{new Color(0.0039215684f, 0.0039215684f, 0.0039215684f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.0f), new Color(0.0f, 0.0f, 0.0f, 0.12156863f), new Color(0.0f, 0.0f, 0.0f, 0.12941177f), new Color(0.0f, 0.0f, 0.0f, 0.49803922f)}));
        G2.fill(INNER_SHADOW);
        G2.dispose();
        return IMAGE;
    }

    @Override
    public void actionPerformed(ActionEvent EVENT) {
        this.blink ^= true;
        this.redOn = this.redBlinkEnabled ? this.blink : this.redOn;
        this.yellowOn = this.yellowBlinkEnabled ? this.blink : this.yellowOn;
        this.greenOn = this.greenBlinkEnabled ? this.blink : this.greenOn;
        this.repaint(this.INNER_BOUNDS);
    }

    @Override
    public String toString() {
        return "Trafficlight2";
    }
}

