/*
 * Decompiled with CFR 0.152.
 */
package neoe.util;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FileUtil {
    public static void copy(File from, File to) throws IOException {
        FileInputStream in = new FileInputStream(from);
        FileOutputStream out = new FileOutputStream(to);
        FileUtil.copy(in, out);
        in.close();
        out.close();
    }

    public static void copy(InputStream in, OutputStream outstream) throws IOException {
        int len;
        BufferedOutputStream out = new BufferedOutputStream(outstream);
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        in.close();
        out.close();
    }

    public static void copy2(InputStream in, OutputStream outstream) throws IOException {
        int len;
        BufferedOutputStream out = new BufferedOutputStream(outstream);
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    public static BufferedReader getBufferedReader(String fn, String enc) throws IOException {
        InputStream in = FileUtil.getFileInputStream(fn);
        return new BufferedReader(new InputStreamReader(in, enc));
    }

    public static InputStream getFileInputStream(String fn) {
        System.out.println("getFileInputStream:in " + FileUtil.class.getClassLoader() + ":" + fn);
        InputStream in = FileUtil.class.getClassLoader().getResourceAsStream(fn);
        if (in == null) {
            in = fn.startsWith("/") ? FileUtil.class.getClassLoader().getResourceAsStream(fn.substring(1)) : FileUtil.class.getClassLoader().getResourceAsStream("/" + fn);
        }
        return in;
    }

    public static BufferedReader getRawBufferedReader(String fn, String enc) throws UnsupportedEncodingException, FileNotFoundException {
        FileInputStream in = new FileInputStream(fn);
        return new BufferedReader(new InputStreamReader((InputStream)in, enc));
    }

    public static void pass(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
        out.flush();
    }

    public static void pass(InputStream in, OutputStream out, long total) throws IOException {
        int len;
        byte[] buf = new byte[16384];
        long sum = 0L;
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
            if ((sum += (long)len) < total) continue;
        }
        out.flush();
    }

    public static String readString(InputStream ins, String enc) throws IOException {
        int len;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(ins, enc));
        char[] buf = new char[1000];
        StringBuffer sb = new StringBuffer();
        while ((len = in.read(buf)) > 0) {
            sb.append(buf, 0, len);
        }
        in.close();
        return sb.toString();
    }

    public static List<String> readStringBig(File f, String enc) throws IOException {
        String line;
        if (enc == null) {
            enc = "UTF-8";
        }
        BufferedReader in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(f), enc));
        ArrayList<String> ret = new ArrayList<String>();
        while ((line = in.readLine()) != null) {
            ret.add(line);
        }
        in.close();
        return ret;
    }

    public static byte[] read(InputStream in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        FileUtil.copy(in, baos);
        return baos.toByteArray();
    }

    public static void save(byte[] bs, String fn) throws IOException {
        File f = new File(fn);
        f.getAbsoluteFile().getParentFile().mkdirs();
        File ftmp = new File(fn + "." + System.currentTimeMillis());
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(ftmp));
        out.write(bs);
        out.close();
        if (f.exists()) {
            f.delete();
        }
        Files.move(ftmp.toPath(), f.toPath(), new CopyOption[0]);
    }

    public static Iterable<CharSequence> split(final CharSequence src, final char sep) {
        return new Iterable<CharSequence>(){

            @Override
            public Iterator<CharSequence> iterator() {
                return new Iterator<CharSequence>(){
                    int p1;

                    @Override
                    public CharSequence next() {
                        int p2 = -1;
                        for (int i = this.p1; i < src.length(); ++i) {
                            if (src.charAt(i) != sep) continue;
                            p2 = i;
                            break;
                        }
                        if (p2 == -1) {
                            CharSequence r = src.subSequence(this.p1, src.length());
                            this.p1 = src.length();
                            return r;
                        }
                        CharSequence r = src.subSequence(this.p1, p2);
                        this.p1 = p2 + 1;
                        return r;
                    }

                    @Override
                    public boolean hasNext() {
                        if (src == null) {
                            return false;
                        }
                        return this.p1 < src.length();
                    }
                };
            }
        };
    }

    public static byte[] readBs(InputStream in, int len) throws IOException {
        int count;
        byte[] b = new byte[len];
        int off = 0;
        for (int n = 0; n < len; n += count) {
            count = in.read(b, off + n, len - n);
            if (count >= 0) continue;
            throw new EOFException();
        }
        return b;
    }
}

