/*
 * Decompiled with CFR 0.152.
 */
package eu.hansolo.steelseries.tools;

import eu.hansolo.steelseries.tools.Util;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Ellipse2D;
import java.awt.geom.RectangularShape;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;

public enum DisabledImageFactory {
    INSTANCE;

    private final Util UTIL = Util.INSTANCE;
    private int radWidth = 0;
    private BufferedImage radDisabledImage = this.UTIL.createImage(1, 1, 3);
    private int linWidth = 0;
    private int linHeight = 0;
    private BufferedImage linDisabledImage = this.UTIL.createImage(1, 1, 3);
    private final Color DISABLED_COLOR = new Color(102, 102, 102, 178);

    public BufferedImage createRadialDisabled(int WIDTH) {
        if (WIDTH <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.radWidth == WIDTH) {
            return this.radDisabledImage;
        }
        this.radDisabledImage.flush();
        this.radDisabledImage = this.UTIL.createImage(WIDTH, WIDTH, 3);
        Graphics2D G2 = this.radDisabledImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = this.radDisabledImage.getWidth();
        int IMAGE_HEIGHT = this.radDisabledImage.getHeight();
        Ellipse2D.Double BACKGROUND = new Ellipse2D.Double((double)IMAGE_WIDTH * 0.08411215245723724, (double)IMAGE_HEIGHT * 0.08411215245723724, (double)IMAGE_WIDTH * 0.8317756652832031, (double)IMAGE_HEIGHT * 0.8317756652832031);
        G2.setColor(this.DISABLED_COLOR);
        G2.fill(BACKGROUND);
        G2.dispose();
        this.radWidth = WIDTH;
        return this.radDisabledImage;
    }

    public BufferedImage createLinearDisabled(int WIDTH, int HEIGHT) {
        if (WIDTH <= 0 || HEIGHT <= 0) {
            return this.UTIL.createImage(1, 1, 3);
        }
        if (this.linWidth == WIDTH && this.linHeight == HEIGHT) {
            return this.linDisabledImage;
        }
        this.linDisabledImage.flush();
        this.linDisabledImage = this.UTIL.createImage(WIDTH, HEIGHT, 3);
        Graphics2D G2 = this.linDisabledImage.createGraphics();
        G2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int IMAGE_WIDTH = this.linDisabledImage.getWidth();
        int IMAGE_HEIGHT = this.linDisabledImage.getHeight();
        double OUTER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.05 : (double)IMAGE_WIDTH * 0.05;
        RoundRectangle2D.Double OUTER_FRAME = new RoundRectangle2D.Double(0.0, 0.0, IMAGE_WIDTH, IMAGE_HEIGHT, OUTER_FRAME_CORNER_RADIUS, OUTER_FRAME_CORNER_RADIUS);
        double FRAME_MAIN_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? OUTER_FRAME_CORNER_RADIUS - (((RectangularShape)OUTER_FRAME).getHeight() - (double)IMAGE_HEIGHT - 2.0) / 2.0 : OUTER_FRAME_CORNER_RADIUS - (((RectangularShape)OUTER_FRAME).getWidth() - (double)IMAGE_WIDTH - 2.0) / 2.0;
        RoundRectangle2D.Double FRAME_MAIN = new RoundRectangle2D.Double(1.0, 1.0, IMAGE_WIDTH - 2, IMAGE_HEIGHT - 2, FRAME_MAIN_CORNER_RADIUS, FRAME_MAIN_CORNER_RADIUS);
        double INNER_FRAME_CORNER_RADIUS = IMAGE_WIDTH >= IMAGE_HEIGHT ? (double)IMAGE_HEIGHT * 0.02857143 : (double)IMAGE_WIDTH * 0.02857143;
        RoundRectangle2D.Double INNER_FRAME = new RoundRectangle2D.Double(((RectangularShape)FRAME_MAIN).getX() + 16.0, ((RectangularShape)FRAME_MAIN).getY() + 16.0, ((RectangularShape)FRAME_MAIN).getWidth() - 32.0, ((RectangularShape)FRAME_MAIN).getHeight() - 32.0, INNER_FRAME_CORNER_RADIUS, INNER_FRAME_CORNER_RADIUS);
        double BACKGROUND_CORNER_RADIUS = INNER_FRAME_CORNER_RADIUS - 1.0;
        RoundRectangle2D.Double BACKGROUND = new RoundRectangle2D.Double(((RectangularShape)INNER_FRAME).getX() + 1.0, ((RectangularShape)INNER_FRAME).getY() + 1.0, ((RectangularShape)INNER_FRAME).getWidth() - 2.0, ((RectangularShape)INNER_FRAME).getHeight() - 2.0, BACKGROUND_CORNER_RADIUS, BACKGROUND_CORNER_RADIUS);
        G2.setColor(this.DISABLED_COLOR);
        G2.fill(BACKGROUND);
        G2.dispose();
        this.linWidth = WIDTH;
        this.linHeight = HEIGHT;
        return this.linDisabledImage;
    }

    public String toString() {
        return "DisabledImageFactory";
    }
}

