/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextarea;

import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.HashMap;
import javax.swing.text.StyleContext;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;

public final class FontUtil {
    private FontUtil() {
    }

    public static Font createFont(String family, int style, int size) {
        StyleContext sc = StyleContext.getDefaultStyleContext();
        return sc.getFont(family, style, size);
    }

    public static Font deriveFont(Font baseFont, String newFamily) {
        return FontUtil.deriveFont(baseFont, newFamily, null, null);
    }

    public static Font deriveFont(Font baseFont, String newFamily, Integer newStyle, Number newSize) {
        HashMap<TextAttribute, Object> newAttrs = new HashMap<TextAttribute, Object>();
        if (newFamily != null) {
            newAttrs.put(TextAttribute.FAMILY, newFamily);
        }
        if (newSize != null) {
            newAttrs.put(TextAttribute.SIZE, newSize);
        }
        Font font = newAttrs.isEmpty() ? baseFont : baseFont.deriveFont(newAttrs);
        return newStyle == null ? font : font.deriveFont(newStyle);
    }

    public static Font getDefaultMonospacedFont() {
        int os = RSyntaxUtilities.getOS();
        if (os == 2) {
            return FontUtil.getDefaultMonospaceFontMacOS();
        }
        if (os == 1) {
            return FontUtil.getDefaultMonospaceFontWindows();
        }
        if (os == 4) {
            return FontUtil.getDefaultMonospaceFontLinux();
        }
        return FontUtil.getDefaultMonospaceFontOther();
    }

    private static Font getDefaultMonospaceFontLinux() {
        Font font = FontUtil.createFont("Ubuntu Mono", 0, 12);
        if (!"Ubuntu Mono".equals(font.getFamily()) && !"DejaVu Sans Mono".equals((font = FontUtil.createFont("DejaVu Sans Mono", 0, 12)).getFamily())) {
            font = FontUtil.getDefaultMonospaceFontOther();
        }
        return font;
    }

    private static Font getDefaultMonospaceFontMacOS() {
        Font font = FontUtil.createFont("Menlo", 0, 12);
        if (!"Menlo".equals(font.getFamily()) && !"Monaco".equals((font = FontUtil.createFont("Monaco", 0, 12)).getFamily())) {
            font = FontUtil.getDefaultMonospaceFontOther();
        }
        return font;
    }

    private static Font getDefaultMonospaceFontOther() {
        return FontUtil.createFont("Monospaced", 0, 13);
    }

    private static Font getDefaultMonospaceFontWindows() {
        Font font = FontUtil.createFont("Cascadia Code", 0, 13);
        if (!"Cascadia Code".equals(font.getFamily()) && !"Consolas".equals((font = FontUtil.createFont("Consolas", 0, 13)).getFamily())) {
            font = FontUtil.getDefaultMonospaceFontOther();
        }
        return font;
    }
}

