/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.newparse;

import com.rusefi.EnumsReader;
import com.rusefi.VariableRegistry;
import com.rusefi.enum_reader.Value;
import com.rusefi.newparse.DefinitionsState;
import com.rusefi.newparse.parsing.Definition;
import java.util.HashMap;
import java.util.Map;

public class DefinitionsStateImpl
implements DefinitionsState {
    private final Map<String, Definition> definitions = new HashMap<String, Definition>();
    private final Definition.OverwritePolicy definitionOverwritePolicy = Definition.OverwritePolicy.NotAllowed;

    public DefinitionsStateImpl(EnumsReader enumsReader) {
        for (Map.Entry<String, EnumsReader.EnumState> enumType : enumsReader.getEnums().entrySet()) {
            String name = enumType.getKey();
            for (Value enumValue : enumType.getValue().values()) {
                try {
                    int value = enumValue.getIntValue();
                    this.handleIntDefinition(name + "_" + enumValue.getName(), value);
                }
                catch (Exception exception) {}
            }
        }
    }

    private void handleIntDefinition(String name, int value) {
        this.addDefinition(name, value);
        this.addDefinition(name + "_16_hex", String.format("\\x%02x\\x%02x", value >> 8 & 0xFF, value & 0xFF));
    }

    @Override
    public void addDefinition(VariableRegistry variableRegistry, String name, String value, Definition.OverwritePolicy overwritePolicy) {
        variableRegistry.register(name, value);
        this.addDefinition(name, value, overwritePolicy);
    }

    public void addDefinition(String name, Object value, Definition.OverwritePolicy overwritePolicy) {
        Definition existingDefinition = this.definitions.getOrDefault(name, null);
        if (existingDefinition != null) {
            switch (existingDefinition.overwritePolicy) {
                case NotAllowed: {
                    throw new IllegalStateException("Tried to add definition for " + name + ", but one already existed.");
                }
                case IgnoreNew: {
                    return;
                }
            }
        }
        this.definitions.put(name, new Definition(value, overwritePolicy));
    }

    private void addDefinition(String name, Object value) {
        this.addDefinition(name, value, this.definitionOverwritePolicy);
    }
}

