/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.libopenblt.transport;

import com.rusefi.libopenblt.transport.IXcpTransport;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class XcpNet
implements IXcpTransport {
    private final Object mLock = new Object();
    private final String mHostname;
    private final int mPort;
    private TransportImpl mTransport;

    private void checkTransport() {
        if (this.mTransport == null) {
            throw new IllegalStateException("Transport is invalid");
        }
    }

    public XcpNet(String hostname, int port) {
        this.mHostname = hostname;
        this.mPort = port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTransport != null) {
                throw new IllegalStateException("Cannot connect when already connected");
            }
            this.mTransport = new TransportImpl(this.mHostname, this.mPort);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void disconnect() throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mTransport != null) {
                this.mTransport.close();
                this.mTransport = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] sendPacket(byte[] request, int timeoutMs, int expectResponseBytes) throws IOException {
        Object object = this.mLock;
        synchronized (object) {
            this.checkTransport();
            this.mTransport.write(request);
            return this.mTransport.read(expectResponseBytes, timeoutMs);
        }
    }

    private static class TransportImpl
    implements Closeable {
        private final Socket mSocket;
        private final InputStream mReader;
        private final OutputStream mWriter;

        TransportImpl(@NotNull String hostname, int port) throws IOException {
            this.mSocket = new Socket(hostname, port);
            this.mReader = this.mSocket.getInputStream();
            this.mWriter = this.mSocket.getOutputStream();
        }

        @Override
        public void close() throws IOException {
            this.mSocket.close();
        }

        void write(byte[] data) throws IOException {
            byte[] dataWithHeader = new byte[data.length + 1];
            dataWithHeader[0] = (byte)data.length;
            System.arraycopy(data, 0, dataWithHeader, 1, data.length);
            this.mWriter.write(dataWithHeader);
            this.mWriter.flush();
        }

        byte[] read(int len, int timeoutMs) throws IOException {
            byte[] readBuffer = new byte[len + 1];
            this.mSocket.setSoTimeout(timeoutMs);
            int actualRead = this.mReader.read(readBuffer);
            if (actualRead != readBuffer.length) {
                throw new IllegalStateException("Unexpected bytes read, requested " + readBuffer.length + " but got " + actualRead);
            }
            if (len != readBuffer[0]) {
                throw new IllegalStateException("Unexpected length of return packet, expected " + len + " but target returned " + (readBuffer[0] & 0xFF));
            }
            return Arrays.copyOfRange(readBuffer, 1, 1 + len);
        }
    }
}

