/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.FileLog;
import com.rusefi.core.Sensor;
import com.rusefi.core.preferences.storage.Node;
import com.rusefi.ui.GaugesGrid;
import com.rusefi.ui.GaugesGridElement;
import com.rusefi.ui.MessagesPanel;
import com.rusefi.ui.RpmLabel;
import com.rusefi.ui.SizeSelectorPanel;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.WarningPanel;
import com.rusefi.ui.util.UiUtils;
import com.rusefi.ui.widgets.AnyCommand;
import com.rusefi.ui.widgets.DetachedSensor;
import com.rusefi.ui.widgets.PopupMenuButton;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;

public class GaugesPanel {
    private static final Sensor[] DEFAULT_LAYOUT = new Sensor[]{Sensor.RPMValue, Sensor.MAFMEASURED, Sensor.COOLANT, Sensor.INTAKE, Sensor.TPSVALUE, Sensor.MAPVALUE, Sensor.lastErrorCode, Sensor.LAMBDAVALUE, Sensor.VBATT, Sensor.VEHICLESPEEDKPH};
    private static final String GAUGES_ROWS = "gauges_rows";
    private static final String GAUGES_COLUMNS = "gauges_cols";
    private static final String SHOW_MESSAGES = "show_messages";
    private static final String SHOW_RPM = "show_rpm";
    private static final String SPLIT_LOCATION = "SPLIT_LOCATION";
    public static final String DISABLE_LOGS = "DISABLE_LOGS";
    private static final int DEFAULT_ROWS = 3;
    private static final int DEFAULT_COLUMNS = 3;
    public static boolean IS_PAUSED;
    private final JPanel content = new JPanel(new BorderLayout());
    private final GaugesGrid gauges;
    private final Node config;
    private final UIContext uiContext;
    private boolean showRpmPanel;
    private boolean showMessagesPanel;
    private final JPanel lowerRpmPanel = new JPanel(new FlowLayout(1, 0, 0));
    private final JPanel messagesPanel = new JPanel(new BorderLayout());
    private final JSplitPane middleSplitPanel;

    public GaugesPanel(UIContext uiContext, final Node config) {
        this.uiContext = uiContext;
        this.gauges = new GaugesGrid(3, 3);
        this.config = config;
        this.showRpmPanel = config.getBoolProperty(SHOW_RPM, true);
        this.showMessagesPanel = config.getBoolProperty(SHOW_MESSAGES, true);
        this.prepareMessagesPanel();
        this.lowerRpmPanel.add(new RpmLabel(uiContext, 15, false).getContent());
        int rows = config.getIntProperty(GAUGES_ROWS, 3);
        int columns = config.getIntProperty(GAUGES_COLUMNS, 3);
        this.setSensorGridDimensions(rows, columns);
        this.middleSplitPanel = new JSplitPane(1, this.createMiddleLeftPanel(), this.messagesPanel);
        this.content.add((Component)this.createTopPanel(config), "North");
        this.content.add((Component)this.middleSplitPanel, "Center");
        this.content.add((Component)new WarningPanel(config).getPanel(config), "South");
        this.applyShowFlags();
        int splitLocation = config.getIntProperty(SPLIT_LOCATION, -1);
        if (splitLocation != -1) {
            this.middleSplitPanel.setDividerLocation(splitLocation);
        }
        this.middleSplitPanel.addPropertyChangeListener("dividerLocation", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent pce) {
                config.setProperty(GaugesPanel.SPLIT_LOCATION, GaugesPanel.this.middleSplitPanel.getDividerLocation());
            }
        });
    }

    @NotNull
    private JPanel createMiddleLeftPanel() {
        JPanel middleLeftPanel = new JPanel(new BorderLayout());
        middleLeftPanel.add((Component)this.gauges.panel, "Center");
        middleLeftPanel.add((Component)this.lowerRpmPanel, "South");
        return middleLeftPanel;
    }

    @NotNull
    private JPanel createTopPanel(Node config) {
        JPanel upperPanel = new JPanel(new BorderLayout());
        upperPanel.add((Component)this.createLeftTopPanel(), "Center");
        upperPanel.add((Component)this.createRightTopPanel(config), "East");
        return upperPanel;
    }

    @NotNull
    private JPanel createRightTopPanel(Node config) {
        JPanel rightUpperPanel = new JPanel(new FlowLayout(2, 5, 0));
        JPopupMenu selectorMenu = new JPopupMenu();
        selectorMenu.add(new SizeSelectorPanel((row, column) -> {
            System.out.println("new size " + row + "/" + column);
            this.setSensorGridDimensions(row, column);
        }));
        JButton selector = new JButton("O");
        selector.addActionListener(e -> {
            Component c = (Component)e.getSource();
            selectorMenu.show(c, -1, c.getHeight());
        });
        rightUpperPanel.add(selector);
        PopupMenuButton menuButton = new PopupMenuButton("#", this.createMenu(config));
        rightUpperPanel.add(menuButton);
        return rightUpperPanel;
    }

    @NotNull
    private JPopupMenu createMenu(Node config) {
        JPopupMenu menu = new JPopupMenu();
        JCheckBoxMenuItem showRpmItem = new JCheckBoxMenuItem("Show RPM");
        JCheckBoxMenuItem showCommandsItem = new JCheckBoxMenuItem("Show Commands");
        showRpmItem.setSelected(this.showRpmPanel);
        ActionListener showCheckboxListener = e -> {
            this.showRpmPanel = showRpmItem.isSelected();
            this.showMessagesPanel = showCommandsItem.isSelected();
            config.setProperty(SHOW_RPM, this.showRpmPanel);
            config.setProperty(SHOW_MESSAGES, this.showMessagesPanel);
            this.applyShowFlags();
            this.middleSplitPanel.setDividerLocation(0.5);
        };
        showRpmItem.addActionListener(showCheckboxListener);
        showCommandsItem.addActionListener(showCheckboxListener);
        menu.add(showRpmItem);
        showCommandsItem.setSelected(this.showMessagesPanel);
        menu.add(showCommandsItem);
        menu.add(new JPopupMenu.Separator());
        menu.add(new JPopupMenu("Reset Config"));
        return menu;
    }

    private void prepareMessagesPanel() {
        MessagesPanel mp = new MessagesPanel(null, this.config);
        this.messagesPanel.add("North", mp.getButtonPanel());
        this.messagesPanel.add("Center", mp.getMessagesScroll());
    }

    @NotNull
    private JPanel createLeftTopPanel() {
        JPanel leftUpperPanel = new JPanel(new FlowLayout(0, 5, 0));
        leftUpperPanel.add(this.createPauseButton());
        leftUpperPanel.add(this.createSaveImageButton());
        leftUpperPanel.add(new RpmLabel(this.uiContext, 2).getContent());
        AnyCommand command = AnyCommand.createField(this.uiContext, this.config, false, false);
        leftUpperPanel.add(command.getContent());
        return leftUpperPanel;
    }

    private Component createPauseButton() {
        String suffix = " Gauges";
        JButton pauseButton = UiUtils.createPauseButton(suffix);
        pauseButton.addActionListener(e -> {
            IS_PAUSED = !IS_PAUSED;
            UiUtils.setPauseButtonText(pauseButton, IS_PAUSED, suffix);
        });
        return pauseButton;
    }

    @NotNull
    private JButton createSaveImageButton() {
        JButton saveImageButton = UiUtils.createSaveImageButton();
        saveImageButton.addActionListener(e -> {
            String fileName = FileLog.getDate() + "_gauges.png";
            UiUtils.saveImageWithPrompt(fileName, this.content, this.gauges.panel);
        });
        return saveImageButton;
    }

    private void setSensorGridDimensions(int rows, int columns) {
        this.gauges.setLayout(rows, columns);
        for (int i = 0; i < rows * columns; ++i) {
            Sensor defaultSensor = DEFAULT_LAYOUT[Math.min(i, DEFAULT_LAYOUT.length - 1)];
            JComponent element = GaugesGridElement.read(this.uiContext, this.config.getChild("element_" + i), defaultSensor);
            this.gauges.panel.add(element);
        }
        this.saveConfig(rows, columns);
    }

    private void saveConfig(int rows, int columns) {
        this.config.setProperty(GAUGES_ROWS, rows);
        this.config.setProperty(GAUGES_COLUMNS, columns);
    }

    private void applyShowFlags() {
        this.lowerRpmPanel.setVisible(this.showRpmPanel);
        this.messagesPanel.setVisible(this.showMessagesPanel);
    }

    public JComponent getContent() {
        return this.content;
    }

    public static class DetachedRepository {
        public static final String COUNT = "count";
        public static final String DETACHED = "detached";
        private final UIContext uiContext;
        private List<DetachedSensor> list = new ArrayList<DetachedSensor>();
        private Node config;

        public DetachedRepository(UIContext uiContext) {
            this.uiContext = uiContext;
        }

        public void add(DetachedSensor detachedSensor) {
            this.list.add(detachedSensor);
            this.saveConfig();
        }

        public void remove(DetachedSensor detachedSensor) {
            this.list.remove(detachedSensor);
            this.saveConfig();
        }

        public void load() {
            int count = this.config.getIntProperty(COUNT, 0);
            for (int i = 0; i < count; ++i) {
                DetachedSensor.create(this.uiContext, this.config.getChild(DETACHED + i));
            }
        }

        public void saveConfig() {
            this.config.setProperty(COUNT, this.list.size());
            int index = 0;
            for (DetachedSensor sensor : this.list) {
                sensor.saveConfig(this.config.getChild(DETACHED + index++));
            }
        }

        public void init(Node config) {
            this.config = config;
        }
    }
}

