/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.config;

import com.opensr5.ConfigurationImage;
import com.rusefi.config.Field;
import com.rusefi.config.FieldCommandResponse;
import com.rusefi.core.MessagesCentral;
import com.rusefi.core.Pair;
import com.rusefi.ui.UIContext;
import com.rusefi.ui.config.BaseConfigField;
import com.rusefi.ui.util.JTextFieldWithWidth;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.DecimalFormat;
import javax.swing.JTextField;

public class ConfigUiField
extends BaseConfigField {
    private final JTextField view = new JTextFieldWithWidth(200);
    private static final DecimalFormat df = new DecimalFormat("0.0000");

    public ConfigUiField(UIContext uiContext, final Field field, String topLabel) {
        super(uiContext, field);
        this.createUi(topLabel, this.view);
        this.requestInitialValue(field);
        MessagesCentral.getInstance().addListener(new MessagesCentral.MessageListener(){

            @Override
            public void onMessage(Class clazz, String message) {
                Pair<Integer, ?> p;
                if ((FieldCommandResponse.isIntValueMessage(message) || FieldCommandResponse.isFloatValueMessage(message)) && (p = FieldCommandResponse.parseResponse(message)) != null && ((Integer)p.first).intValue() == field.getOffset()) {
                    Object value = p.second;
                    ConfigUiField.this.setValue(value);
                }
            }
        });
        this.view.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    ConfigUiField.this.sendValue(field, ConfigUiField.this.view.getText());
                }
            }
        });
    }

    private void setValue(Object value) {
        this.view.setEnabled(true);
        this.view.setText("" + value);
        this.onValueArrived();
    }

    @Override
    protected void loadValue(ConfigurationImage ci) {
        Double value = this.field.getValue(ci);
        this.setValue(value);
    }

    public static int getIntValue(ConfigurationImage ci, Field field) {
        return field.getValue(ci).intValue();
    }
}

