/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi;

import com.devexperts.logging.Logging;
import java.util.concurrent.CountDownLatch;

public class RecurringStep {
    private static final Logging log = Logging.getLogging(RecurringStep.class);
    private final Runnable initialStep;
    private final Runnable stepToRepeat;
    private final String threadName;
    private volatile boolean isStopped = false;
    private volatile boolean isSuspended = false;
    private volatile CountDownLatch suspendedCountDownLatch = RecurringStep.createSuspendedCountDownLatch();

    public RecurringStep(Runnable initialStep, Runnable stepToRecur, String threadName) {
        this.initialStep = initialStep;
        this.stepToRepeat = stepToRecur;
        this.threadName = threadName;
    }

    public void start() {
        Thread workerThread = new Thread(() -> {
            boolean isFirstTime = true;
            while (!this.isStopped) {
                if (!this.checkSuspended()) {
                    if (isFirstTime) {
                        this.initialStep.run();
                        isFirstTime = false;
                    } else {
                        this.stepToRepeat.run();
                    }
                }
                try {
                    Thread.sleep(300L);
                }
                catch (InterruptedException e) {
                    log.error("sleep interrupted", e);
                }
            }
        }, this.threadName);
        workerThread.setDaemon(true);
        workerThread.start();
    }

    public void stop() {
        this.isStopped = true;
    }

    synchronized void resume() {
        this.isSuspended = false;
    }

    synchronized CountDownLatch suspend() {
        if (!this.isSuspended) {
            this.isSuspended = true;
            this.suspendedCountDownLatch = RecurringStep.createSuspendedCountDownLatch();
        }
        return this.suspendedCountDownLatch;
    }

    private synchronized boolean checkSuspended() {
        if (this.isSuspended) {
            this.suspendedCountDownLatch.countDown();
        }
        return this.isSuspended;
    }

    private static CountDownLatch createSuspendedCountDownLatch() {
        return new CountDownLatch(1);
    }
}

