/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui;

import com.rusefi.core.preferences.storage.Node;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class LogSizeControl {
    private static final String BYTES = "SCREEN_LOG_BYTES";
    private final JPanel content = new JPanel(new FlowLayout());

    public LogSizeControl(final Node config) {
        this.content.add(new JLabel("On screen bytes: "));
        final JTextField lines = new JTextField(8);
        this.content.add(lines);
        lines.setText(Integer.toString(LogSizeControl.getValue(config)));
        lines.addActionListener(new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent ev) {
                int value;
                try {
                    value = Integer.parseInt(lines.getText());
                }
                catch (NumberFormatException ex) {
                    return;
                }
                config.setProperty(LogSizeControl.BYTES, Integer.toString(value));
            }
        });
    }

    public static int getValue(Node config) {
        return config.getIntProperty(BYTES, 50000);
    }

    public Component getContent() {
        return this.content;
    }
}

