/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.binaryprotocol;

import com.devexperts.logging.Logging;
import com.opensr5.ini.IniFileModel;
import com.opensr5.ini.IniFileModelImpl;
import com.opensr5.ini.PrimeTunerStudioCache;
import com.rusefi.binaryprotocol.IniFileProvider;
import com.rusefi.core.SignatureHelper;
import java.io.FileNotFoundException;

public class RealIniFileProvider
implements IniFileProvider {
    private static final Logging log = Logging.getLogging(RealIniFileProvider.class);

    @Override
    public IniFileModel provide(String signature) {
        String localIniFile = SignatureHelper.downloadIfNotAvailable(SignatureHelper.getUrl(signature));
        if (localIniFile == null) {
            log.info("Failed to download " + signature + " maybe custom board?");
            localIniFile = IniFileModelImpl.findIniFile(".");
        }
        if (localIniFile == null) {
            localIniFile = IniFileModelImpl.findIniFile(IniFileModelImpl.INI_FILE_PATH);
        }
        if (localIniFile == null) {
            throw new IllegalStateException("Failed to locate .ini file in five different places!");
        }
        IniFileModelImpl iniFileModel = null;
        try {
            iniFileModel = IniFileModelImpl.readIniFile(localIniFile);
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException(e);
        }
        PrimeTunerStudioCache.prime(iniFileModel, localIniFile);
        return iniFileModel;
    }
}

