/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.core;

import com.devexperts.logging.Logging;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.SwingUtilities;

public class MessagesCentral {
    private static final Logging log = Logging.getLogging(MessagesCentral.class);
    private static final MessagesCentral INSTANCE = new MessagesCentral();
    private final List<MessageListener> listeners = new CopyOnWriteArrayList<MessageListener>();

    private MessagesCentral() {
    }

    public static MessagesCentral getInstance() {
        return INSTANCE;
    }

    public void addListener(MessageListener listener) {
        this.listeners.add(listener);
    }

    public void postMessage(final Class clazz, final String message) {
        log.info("postMessage " + clazz.getSimpleName() + ": " + message);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                for (MessageListener listener : MessagesCentral.this.listeners) {
                    listener.onMessage(clazz, message);
                }
            }
        });
    }

    public static interface MessageListener {
        public void onMessage(Class var1, String var2);
    }
}

