/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.ui.engine;

import com.rusefi.ui.engine.UpDownImage;
import com.rusefi.waves.EngineReport;
import com.rusefi.waves.RevolutionLog;
import com.rusefi.waves.TimeAxisTranslator;
import java.awt.FlowLayout;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class EngineSnifferStatusPanel {
    public final JPanel infoPanel = new JPanel(new FlowLayout(0, 0, 0));
    private final JLabel xLabel = new JLabel();
    private final JLabel timeLabel = new JLabel();
    private final JLabel angleLabel = new JLabel();
    private final JLabel rpmLabel = new JLabel();
    private TimeAxisTranslator translator = EngineReport.MOCK.getTimeAxisTranslator();
    private RevolutionLog time2rpm = RevolutionLog.parseRevolutions(null);
    public final MouseMotionAdapter motionAdapter = new MouseMotionAdapter(){

        @Override
        public void mouseMoved(MouseEvent event) {
            int x = event.getX();
            EngineSnifferStatusPanel.this.xLabel.setText("" + x);
            UpDownImage s = (UpDownImage)event.getSource();
            double time = EngineSnifferStatusPanel.this.translator.screenToTime(x, s.getWidth());
            EngineSnifferStatusPanel.this.timeLabel.setText("" + String.format("%.5f sec", time));
            String text = EngineSnifferStatusPanel.this.time2rpm == null ? "n/a" : EngineSnifferStatusPanel.this.time2rpm.getCrankAngleByTimeString(time);
            EngineSnifferStatusPanel.this.angleLabel.setText(text);
            Map.Entry<Integer, Integer> e = EngineSnifferStatusPanel.this.time2rpm.getTimeAndRpm(time);
            if (e == null) {
                EngineSnifferStatusPanel.this.rpmLabel.setText("n/a");
            } else {
                EngineSnifferStatusPanel.this.rpmLabel.setText("" + e.getValue());
            }
        }
    };

    public EngineSnifferStatusPanel() {
        this.infoPanel.add(new JLabel("X: "));
        this.infoPanel.add(this.xLabel);
        this.infoPanel.add(new JLabel(" time: "));
        this.infoPanel.add(this.timeLabel);
        this.infoPanel.add(new JLabel(" angle: "));
        this.infoPanel.add(this.angleLabel);
        this.infoPanel.add(new JLabel(" RPM: "));
        this.infoPanel.add(this.rpmLabel);
        JLabel green = new JLabel("  Green line is engine cycle");
        green.setForeground(UpDownImage.ENGINE_CYCLE_COLOR);
        this.infoPanel.add(green);
        JLabel red = new JLabel("  Red line is every 20ms");
        red.setForeground(UpDownImage.TIME_SCALE_COLOR);
        this.infoPanel.add(red);
    }

    public void setTimeAxisTranslator(TimeAxisTranslator translator) {
        this.translator = translator;
    }

    public void setRevolutions(StringBuilder revolutions) {
        this.time2rpm = RevolutionLog.parseRevolutions(revolutions);
    }
}

