/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.maintenance.migration.migrators;

import com.opensr5.ini.field.ArrayIniField;
import com.opensr5.ini.field.IniField;
import com.rusefi.maintenance.migration.IniFieldMigrationUtils;
import com.rusefi.maintenance.migration.TuneMigrationContext;
import com.rusefi.maintenance.migration.migrators.TuneMigrator;
import com.rusefi.tune.xml.Constant;
import java.util.Locale;
import java.util.Optional;

public enum AfrMsqImportMigrator implements TuneMigrator
{
    INSTANCE;

    public static final String STOICH_RATIO_NAME = "stoichRatioPrimary";
    public static final String AFR_TABLE_NAME = "lambdaTable";

    @Override
    public void migrateTune(TuneMigrationContext context) {
        Optional<IniField> prevAfrTable = context.getPrevIniFile().findIniField(AFR_TABLE_NAME);
        Optional<IniField> updatedAfrTable = context.getUpdatedIniFile().findIniField(AFR_TABLE_NAME);
        Optional<IniField> prevStoichRatio = context.getPrevIniFile().findIniField(STOICH_RATIO_NAME);
        if (!(prevAfrTable.isPresent() && updatedAfrTable.isPresent() && prevStoichRatio.isPresent())) {
            return;
        }
        Constant prevAfrTableData = context.getPrevTune().getConstantsAsMap().get(AFR_TABLE_NAME);
        Constant updatedAfrTableData = context.getUpdatedTune().getConstantsAsMap().get(AFR_TABLE_NAME);
        Constant prevStoichRatioConstant = context.getPrevTune().getConstantsAsMap().get(STOICH_RATIO_NAME);
        if (prevAfrTableData != null && updatedAfrTableData != null && prevStoichRatioConstant != null) {
            String prevLambdaTableUnits = prevAfrTableData.getUnits();
            String updatedLambdaTableUnits = updatedAfrTableData.getUnits();
            if (prevLambdaTableUnits == null || updatedLambdaTableUnits == null) {
                return;
            }
            if (prevLambdaTableUnits.contains(updatedLambdaTableUnits)) {
                return;
            }
            ArrayIniField prevTableField = (ArrayIniField)prevAfrTable.get();
            ArrayIniField updatedTableField = (ArrayIniField)updatedAfrTable.get();
            String[][] migratedValues = prevTableField.getValues(prevAfrTableData.getValue());
            Double prevStoichRatioValue = Double.parseDouble(prevStoichRatioConstant.getValue());
            if (prevLambdaTableUnits.contains("afr")) {
                for (int row = 0; row < migratedValues.length; ++row) {
                    for (int column = 0; column < migratedValues[0].length; ++column) {
                        Double migratedLambda = Double.parseDouble(migratedValues[row][column]) / prevStoichRatioValue;
                        migratedValues[row][column] = AfrMsqImportMigrator.formatArrayValue(migratedLambda, prevTableField.getDigits());
                    }
                }
            } else {
                for (int row = 0; row < migratedValues.length; ++row) {
                    for (int column = 0; column < migratedValues[0].length; ++column) {
                        Double migratedAfr = Double.parseDouble(migratedValues[row][column]) * prevStoichRatioValue;
                        migratedValues[row][column] = AfrMsqImportMigrator.formatArrayValue(migratedAfr, prevTableField.getDigits());
                    }
                }
            }
            context.addMigration(AFR_TABLE_NAME, IniFieldMigrationUtils.generateConstant(updatedTableField, updatedTableField.formatValue(migratedValues)));
        }
    }

    private static String formatArrayValue(double value, String digits) {
        int numDigits = Integer.parseInt(digits);
        return String.format(Locale.US, "%." + numDigits + "f", value);
    }
}

