/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.server;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class rusEFISSLContext {
    private static final String TLS = "TLS";
    private static boolean isJenkins = true;
    private static TrustManager[] trustAllCerts = new TrustManager[]{new X509TrustManager(){

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return new X509Certificate[0];
        }

        @Override
        public void checkClientTrusted(X509Certificate[] certs, String authType) {
        }

        @Override
        public void checkServerTrusted(X509Certificate[] certs, String authType) {
        }
    }};

    public static void init(String fileName, String password) throws MalformedURLException {
        if (!isJenkins) {
            rusEFISSLContext.setupCertificates(new File(fileName), password);
        }
    }

    public static ServerSocket getSSLServerSocket(int port) {
        try {
            if (isJenkins) {
                return new ServerSocket(port);
            }
            return SSLServerSocketFactory.getDefault().createServerSocket(port);
        }
        catch (IOException e) {
            throw new IllegalStateException("Error binding secure server socket " + port, e);
        }
    }

    public static Socket getSSLSocket(String host, int port) throws IOException {
        if (isJenkins) {
            Socket socket = new Socket(host, port);
            socket.setTcpNoDelay(true);
            return socket;
        }
        return rusEFISSLContext.getSSLSocketFactory(null, TLS).createSocket(host, port);
    }

    private static SSLSocketFactory getSSLSocketFactory(KeyStore trustKey, String sslAlgorithm) {
        try {
            SSLContext context = SSLContext.getInstance(sslAlgorithm);
            context.init(null, trustAllCerts, null);
            return context.getSocketFactory();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    public static void setupCertificates(File certificate, String password) throws MalformedURLException {
        if (!certificate.exists()) {
            throw new IllegalStateException("Certificate not found " + certificate);
        }
        Objects.requireNonNull(password, "password");
        String file = certificate.toURI().toURL().getFile();
        System.setProperty("javax.net.ssl.keyStore", file);
        System.setProperty("javax.net.ssl.keyStorePassword", password);
        System.setProperty("javax.net.ssl.trustStore", file);
        System.setProperty("javax.net.ssl.trustStorePassword", password);
        System.setProperty("javax.net.ssl.keyStoreType", "PKCS12");
    }
}

