/*
 * Decompiled with CFR 0.152.
 */
package com.rusefi.tune_manifest;

import com.rusefi.tune_manifest.TuneManifestHelper;
import org.jetbrains.annotations.NotNull;
import org.json.simple.JSONObject;

public class TuneModel {
    private final String notes;
    private final int size;
    private final String url;
    private final String mapId;
    private final String fileName;
    private boolean error;

    public TuneModel(String notes, String url, int size, String mapId, String fileName) {
        this.notes = notes;
        this.size = size;
        this.url = url;
        this.mapId = mapId;
        this.fileName = fileName;
    }

    static TuneModel parse(JSONObject object) {
        String mapId = (String)object.get("MapID");
        String notes = (String)object.get("Notes");
        String url = (String)object.get("Url");
        int size = Integer.valueOf((String)object.get("EngineSize"));
        String fileName = (String)object.get("FileName");
        return new TuneModel(notes, url, size, mapId, fileName);
    }

    @NotNull
    public String getSaferLocalFileName() {
        return TuneManifestHelper.trimUrlToLocalName(this.getUrl());
    }

    public String getNotes() {
        return this.notes;
    }

    public String getFileName() {
        return this.fileName;
    }

    public int getSize() {
        return this.size;
    }

    public String getMapId() {
        return this.mapId;
    }

    public String getUrl() {
        return this.url;
    }

    public String toString() {
        return "TuneModel{notes='" + this.notes + '\'' + ", url='" + this.url + '\'' + '}';
    }

    public void setError(boolean error) {
        this.error = error;
    }

    public boolean isError() {
        return this.error;
    }
}

