/*
 * Decompiled with CFR 0.152.
 */
package etch.util;

import etch.util.ByteBuffer;
import java.io.EOFException;
import java.nio.BufferOverflowException;
import net.jcip.annotations.NotThreadSafe;

@NotThreadSafe
public class CircularByteBuffer
extends ByteBuffer {
    private final int size;
    private final byte[] buf;
    private int length;
    private int nextGet;
    private int nextPut;

    public CircularByteBuffer(int size) {
        this.size = size;
        this.buf = new byte[size];
    }

    public CircularByteBuffer(byte[] buf) {
        this.length = this.size = buf.length;
        this.buf = buf;
    }

    @Override
    public void clear() {
        this.length = 0;
        this.nextGet = 0;
        this.nextPut = 0;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int length() {
        return this.length;
    }

    @Override
    public byte get() throws EOFException {
        if (this.isEmpty()) {
            throw new EOFException();
        }
        --this.length;
        byte b = this.buf[this.nextGet++];
        if (this.nextGet >= this.size) {
            this.nextGet = 0;
        }
        return b;
    }

    @Override
    public void put(byte b) throws BufferOverflowException {
        if (this.isFull()) {
            throw new BufferOverflowException();
        }
        ++this.length;
        this.buf[this.nextPut++] = b;
        if (this.nextPut >= this.size) {
            this.nextPut = 0;
        }
    }
}

