/*
 * Decompiled with CFR 0.152.
 */
package tel.schich.javacan.util;

import java.nio.ByteBuffer;

public class CanUtils {
    private static final byte[] paddedDataLengthLookup = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 8, 12, 12, 12, 12, 16, 16, 16, 16, 20, 20, 20, 20, 24, 24, 24, 24, 32, 32, 32, 32, 32, 32, 32, 32, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48, 48};

    private CanUtils() {
    }

    public static String hexDump(ByteBuffer data) {
        return CanUtils.hexDump(data, data.position(), data.remaining());
    }

    public static String hexDump(ByteBuffer data, int offset, int length) {
        StringBuilder s = new StringBuilder(length * 2);
        if (length > 0) {
            s.append(String.format("%02X", data.get(offset)));
            for (int i = 1; i < length; ++i) {
                s.append('.').append(String.format("%02X", data.get(offset + i)));
            }
        }
        return s.toString();
    }

    public static byte padDataLength(byte length) {
        if (length > 48) {
            return 64;
        }
        return paddedDataLengthLookup[length];
    }
}

