/*
 * Decompiled with CFR 0.152.
 */
package com.devexperts.util;

import com.devexperts.util.IntComparator;
import com.devexperts.util.LongComparator;
import java.util.Comparator;
import java.util.List;

public class QuickSort {
    private static final int BINARY_INSERT_LIST = 20;
    private static final int BINARY_INSERT_ARRAY = 40;
    private static final int MOM_START = 400;
    private static final int MOM_BASE = 15;

    public static <T extends Comparable<? super T>> void sort(List<T> list) {
        QuickSort.quickSort(list, 0, list.size() - 1, null);
    }

    public static <T extends Comparable<? super T>> void sort(List<T> list, int fromIndex, int toIndex) {
        QuickSort.rangeCheck(list.size(), fromIndex, toIndex);
        QuickSort.quickSort(list, fromIndex, toIndex - 1, null);
    }

    public static <T> void sort(List<T> list, Comparator<? super T> c) {
        QuickSort.quickSort(list, 0, list.size() - 1, c);
    }

    public static <T> void sort(List<T> list, int fromIndex, int toIndex, Comparator<? super T> c) {
        QuickSort.rangeCheck(list.size(), fromIndex, toIndex);
        QuickSort.quickSort(list, fromIndex, toIndex - 1, c);
    }

    public static void sort(Object[] a) {
        QuickSort.quickSort(a, 0, a.length - 1, null);
    }

    public static void sort(Object[] a, int fromIndex, int toIndex) {
        QuickSort.rangeCheck(a.length, fromIndex, toIndex);
        QuickSort.quickSort(a, fromIndex, toIndex - 1, null);
    }

    public static <T> void sort(T[] a, Comparator<? super T> c) {
        QuickSort.quickSort(a, 0, a.length - 1, c);
    }

    public static <T> void sort(T[] a, int fromIndex, int toIndex, Comparator<? super T> c) {
        QuickSort.rangeCheck(a.length, fromIndex, toIndex);
        QuickSort.quickSort(a, fromIndex, toIndex - 1, c);
    }

    public static void sort(int[] a, IntComparator c) {
        QuickSort.quickSort(a, 0, a.length - 1, c);
    }

    public static void sort(int[] a, int fromIndex, int toIndex, IntComparator c) {
        QuickSort.rangeCheck(a.length, fromIndex, toIndex);
        QuickSort.quickSort(a, fromIndex, toIndex - 1, c);
    }

    public static void sort(long[] a, LongComparator c) {
        QuickSort.quickSort(a, 0, a.length - 1, c);
    }

    public static void sort(long[] a, int fromIndex, int toIndex, LongComparator c) {
        QuickSort.rangeCheck(a.length, fromIndex, toIndex);
        QuickSort.quickSort(a, fromIndex, toIndex - 1, c);
    }

    private static <T> void quickSort(List<T> x, int lo, int hi, Comparator<? super T> comparator) {
        while (hi - lo > 20) {
            int hiScan;
            int loScan;
            T pivot;
            if (hi - lo > 400) {
                pivot = x.get(QuickSort.medianOfMedians(comparator, x, QuickSort.momStep(lo, hi), lo, hi));
                loScan = lo;
                hiScan = hi;
            } else {
                pivot = x.get(QuickSort.medianOfFive(comparator, x, lo, lo + 1, lo + hi >>> 1, hi - 1, hi));
                loScan = lo + 2;
                hiScan = hi - 2;
            }
            while (loScan <= hiScan) {
                while (loScan <= hiScan && QuickSort.compare(x.get(loScan), pivot, comparator) < 0) {
                    ++loScan;
                }
                while (loScan <= hiScan && QuickSort.compare(x.get(hiScan), pivot, comparator) > 0) {
                    --hiScan;
                }
                if (loScan > hiScan) break;
                T tmp = x.get(loScan);
                x.set(loScan, x.get(hiScan));
                x.set(hiScan, tmp);
                ++loScan;
                --hiScan;
            }
            if (hiScan - lo < hi - loScan) {
                QuickSort.quickSort(x, lo, hiScan, comparator);
                lo = Math.max(loScan, lo + 1);
                continue;
            }
            QuickSort.quickSort(x, loScan, hi, comparator);
            hi = Math.min(hiScan, hi - 1);
        }
        QuickSort.binaryInsertionSort(x, lo, hi, comparator);
    }

    private static <T> void quickSort(T[] x, int lo, int hi, Comparator<? super T> comparator) {
        while (hi - lo > 40) {
            int hiScan;
            int loScan;
            T pivot;
            if (hi - lo > 400) {
                pivot = x[QuickSort.medianOfMedians(comparator, x, QuickSort.momStep(lo, hi), lo, hi)];
                loScan = lo;
                hiScan = hi;
            } else {
                pivot = x[QuickSort.medianOfFive(comparator, x, lo, lo + 1, lo + hi >>> 1, hi - 1, hi)];
                loScan = lo + 2;
                hiScan = hi - 2;
            }
            while (loScan <= hiScan) {
                while (loScan <= hiScan && QuickSort.compare(x[loScan], pivot, comparator) < 0) {
                    ++loScan;
                }
                while (loScan <= hiScan && QuickSort.compare(x[hiScan], pivot, comparator) > 0) {
                    --hiScan;
                }
                if (loScan > hiScan) break;
                T tmp = x[loScan];
                x[loScan] = x[hiScan];
                x[hiScan] = tmp;
                ++loScan;
                --hiScan;
            }
            if (hiScan - lo < hi - loScan) {
                QuickSort.quickSort(x, lo, hiScan, comparator);
                lo = Math.max(loScan, lo + 1);
                continue;
            }
            QuickSort.quickSort(x, loScan, hi, comparator);
            hi = Math.min(hiScan, hi - 1);
        }
        QuickSort.binaryInsertionSort(x, lo, hi, comparator);
    }

    private static void quickSort(int[] x, int lo, int hi, IntComparator comparator) {
        while (hi - lo > 40) {
            int hiScan;
            int loScan;
            int pivot;
            if (hi - lo > 400) {
                pivot = x[QuickSort.medianOfMedians(comparator, x, QuickSort.momStep(lo, hi), lo, hi)];
                loScan = lo;
                hiScan = hi;
            } else {
                pivot = x[QuickSort.medianOfFive(comparator, x, lo, lo + 1, lo + hi >>> 1, hi - 1, hi)];
                loScan = lo + 2;
                hiScan = hi - 2;
            }
            while (loScan <= hiScan) {
                while (loScan <= hiScan && QuickSort.compare(x[loScan], pivot, comparator) < 0) {
                    ++loScan;
                }
                while (loScan <= hiScan && QuickSort.compare(x[hiScan], pivot, comparator) > 0) {
                    --hiScan;
                }
                if (loScan > hiScan) break;
                int tmp = x[loScan];
                x[loScan] = x[hiScan];
                x[hiScan] = tmp;
                ++loScan;
                --hiScan;
            }
            if (hiScan - lo < hi - loScan) {
                QuickSort.quickSort(x, lo, hiScan, comparator);
                lo = Math.max(loScan, lo + 1);
                continue;
            }
            QuickSort.quickSort(x, loScan, hi, comparator);
            hi = Math.min(hiScan, hi - 1);
        }
        QuickSort.binaryInsertionSort(x, lo, hi, comparator);
    }

    private static void quickSort(long[] x, int lo, int hi, LongComparator comparator) {
        while (hi - lo > 40) {
            int hiScan;
            int loScan;
            long pivot;
            if (hi - lo > 400) {
                pivot = x[QuickSort.medianOfMedians(comparator, x, QuickSort.momStep(lo, hi), lo, hi)];
                loScan = lo;
                hiScan = hi;
            } else {
                pivot = x[QuickSort.medianOfFive(comparator, x, lo, lo + 1, lo + hi >>> 1, hi - 1, hi)];
                loScan = lo + 2;
                hiScan = hi - 2;
            }
            while (loScan <= hiScan) {
                while (loScan <= hiScan && QuickSort.compare(x[loScan], pivot, comparator) < 0) {
                    ++loScan;
                }
                while (loScan <= hiScan && QuickSort.compare(x[hiScan], pivot, comparator) > 0) {
                    --hiScan;
                }
                if (loScan > hiScan) break;
                long tmp = x[loScan];
                x[loScan] = x[hiScan];
                x[hiScan] = tmp;
                ++loScan;
                --hiScan;
            }
            if (hiScan - lo < hi - loScan) {
                QuickSort.quickSort(x, lo, hiScan, comparator);
                lo = Math.max(loScan, lo + 1);
                continue;
            }
            QuickSort.quickSort(x, loScan, hi, comparator);
            hi = Math.min(hiScan, hi - 1);
        }
        QuickSort.binaryInsertionSort(x, lo, hi, comparator);
    }

    private static <T> void binaryInsertionSort(List<T> x, int lo, int hi, Comparator<? super T> comparator) {
        int i = lo;
        while (++i <= hi) {
            T pivot = x.get(i);
            int left = lo;
            int right = i;
            while (left < right) {
                int mid = left + right >>> 1;
                if (QuickSort.compare(pivot, x.get(mid), comparator) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            if (left >= i) continue;
            for (int k = i; k > left; --k) {
                x.set(k, x.get(k - 1));
            }
            x.set(left, pivot);
        }
    }

    private static <T> void binaryInsertionSort(T[] x, int lo, int hi, Comparator<? super T> comparator) {
        int i = lo;
        while (++i <= hi) {
            T pivot = x[i];
            int left = lo;
            int right = i;
            while (left < right) {
                int mid = left + right >>> 1;
                if (QuickSort.compare(pivot, x[mid], comparator) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            if (left >= i) continue;
            System.arraycopy(x, left, x, left + 1, i - left);
            x[left] = pivot;
        }
    }

    private static void binaryInsertionSort(int[] x, int lo, int hi, IntComparator comparator) {
        int i = lo;
        while (++i <= hi) {
            int pivot = x[i];
            int left = lo;
            int right = i;
            while (left < right) {
                int mid = left + right >>> 1;
                if (QuickSort.compare(pivot, x[mid], comparator) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            if (left >= i) continue;
            System.arraycopy(x, left, x, left + 1, i - left);
            x[left] = pivot;
        }
    }

    private static void binaryInsertionSort(long[] x, int lo, int hi, LongComparator comparator) {
        int i = lo;
        while (++i <= hi) {
            long pivot = x[i];
            int left = lo;
            int right = i;
            while (left < right) {
                int mid = left + right >>> 1;
                if (QuickSort.compare(pivot, x[mid], comparator) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            if (left >= i) continue;
            System.arraycopy(x, left, x, left + 1, i - left);
            x[left] = pivot;
        }
    }

    private static int momStep(int lo, int hi) {
        int mult = 5;
        for (int k = (int)(((long)(hi - lo) + 1L) / 400L); k > 0; k /= 15) {
            mult *= 5;
        }
        while (hi - lo < mult - 1 && mult > 5) {
            mult /= 5;
        }
        return (hi - lo) / (mult - 1);
    }

    private static <T> int medianOfMedians(Comparator<? super T> comparator, List<T> x, int step, int lo, int hi) {
        int ns = (hi - lo - step * 4) / 5;
        if (ns < step * 4) {
            return QuickSort.medianOfFive(comparator, x, lo, lo + step, lo + hi >>> 1, hi - step, hi);
        }
        int bs = ns + step;
        return QuickSort.medianOfFive(comparator, x, QuickSort.medianOfMedians(comparator, x, step, lo, lo + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs, lo + bs + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs + bs, hi - bs - bs), QuickSort.medianOfMedians(comparator, x, step, hi - bs - ns, hi - bs), QuickSort.medianOfMedians(comparator, x, step, hi - ns, hi));
    }

    private static <T> int medianOfMedians(Comparator<? super T> comparator, T[] x, int step, int lo, int hi) {
        int ns = (hi - lo - step * 4) / 5;
        if (ns < step * 4) {
            return QuickSort.medianOfFive(comparator, x, lo, lo + step, lo + hi >>> 1, hi - step, hi);
        }
        int bs = ns + step;
        return QuickSort.medianOfFive(comparator, x, QuickSort.medianOfMedians(comparator, x, step, lo, lo + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs, lo + bs + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs + bs, hi - bs - bs), QuickSort.medianOfMedians(comparator, x, step, hi - bs - ns, hi - bs), QuickSort.medianOfMedians(comparator, x, step, hi - ns, hi));
    }

    private static int medianOfMedians(IntComparator comparator, int[] x, int step, int lo, int hi) {
        int ns = (hi - lo - step * 4) / 5;
        if (ns < step * 4) {
            return QuickSort.medianOfFive(comparator, x, lo, lo + step, lo + hi >>> 1, hi - step, hi);
        }
        int bs = ns + step;
        return QuickSort.medianOfFive(comparator, x, QuickSort.medianOfMedians(comparator, x, step, lo, lo + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs, lo + bs + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs + bs, hi - bs - bs), QuickSort.medianOfMedians(comparator, x, step, hi - bs - ns, hi - bs), QuickSort.medianOfMedians(comparator, x, step, hi - ns, hi));
    }

    private static int medianOfMedians(LongComparator comparator, long[] x, int step, int lo, int hi) {
        int ns = (hi - lo - step * 4) / 5;
        if (ns < step * 4) {
            return QuickSort.medianOfFive(comparator, x, lo, lo + step, lo + hi >>> 1, hi - step, hi);
        }
        int bs = ns + step;
        return QuickSort.medianOfFive(comparator, x, QuickSort.medianOfMedians(comparator, x, step, lo, lo + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs, lo + bs + ns), QuickSort.medianOfMedians(comparator, x, step, lo + bs + bs, hi - bs - bs), QuickSort.medianOfMedians(comparator, x, step, hi - bs - ns, hi - bs), QuickSort.medianOfMedians(comparator, x, step, hi - ns, hi));
    }

    private static <T> int medianOfFive(Comparator<? super T> comparator, List<T> x, int ai, int bi, int ci, int di, int ei) {
        T t;
        T a = x.get(ai);
        T b = x.get(bi);
        T c = x.get(ci);
        T d = x.get(di);
        T e = x.get(ei);
        if (QuickSort.compare(a, b, comparator) > 0) {
            t = a;
            a = b;
            b = t;
        }
        if (QuickSort.compare(d, e, comparator) > 0) {
            t = d;
            d = e;
            e = t;
        }
        if (QuickSort.compare(a, d, comparator) > 0) {
            t = a;
            a = d;
            d = t;
            t = b;
            b = e;
            e = t;
        }
        if (QuickSort.compare(b, c, comparator) > 0) {
            t = b;
            b = c;
            c = t;
        }
        if (QuickSort.compare(b, d, comparator) > 0) {
            t = b;
            b = d;
            d = t;
            t = c;
            c = e;
            e = t;
        }
        if (QuickSort.compare(c, d, comparator) > 0) {
            t = c;
            c = d;
            d = t;
        }
        x.set(ai, a);
        x.set(bi, b);
        x.set(ci, c);
        x.set(di, d);
        x.set(ei, e);
        return ci;
    }

    private static <T> int medianOfFive(Comparator<? super T> comparator, T[] x, int ai, int bi, int ci, int di, int ei) {
        T t;
        T a = x[ai];
        T b = x[bi];
        T c = x[ci];
        T d = x[di];
        T e = x[ei];
        if (QuickSort.compare(a, b, comparator) > 0) {
            t = a;
            a = b;
            b = t;
        }
        if (QuickSort.compare(d, e, comparator) > 0) {
            t = d;
            d = e;
            e = t;
        }
        if (QuickSort.compare(a, d, comparator) > 0) {
            t = a;
            a = d;
            d = t;
            t = b;
            b = e;
            e = t;
        }
        if (QuickSort.compare(b, c, comparator) > 0) {
            t = b;
            b = c;
            c = t;
        }
        if (QuickSort.compare(b, d, comparator) > 0) {
            t = b;
            b = d;
            d = t;
            t = c;
            c = e;
            e = t;
        }
        if (QuickSort.compare(c, d, comparator) > 0) {
            t = c;
            c = d;
            d = t;
        }
        x[ai] = a;
        x[bi] = b;
        x[ci] = c;
        x[di] = d;
        x[ei] = e;
        return ci;
    }

    private static int medianOfFive(IntComparator comparator, int[] x, int ai, int bi, int ci, int di, int ei) {
        int t;
        int a = x[ai];
        int b = x[bi];
        int c = x[ci];
        int d = x[di];
        int e = x[ei];
        if (QuickSort.compare(a, b, comparator) > 0) {
            t = a;
            a = b;
            b = t;
        }
        if (QuickSort.compare(d, e, comparator) > 0) {
            t = d;
            d = e;
            e = t;
        }
        if (QuickSort.compare(a, d, comparator) > 0) {
            t = a;
            a = d;
            d = t;
            t = b;
            b = e;
            e = t;
        }
        if (QuickSort.compare(b, c, comparator) > 0) {
            t = b;
            b = c;
            c = t;
        }
        if (QuickSort.compare(b, d, comparator) > 0) {
            t = b;
            b = d;
            d = t;
            t = c;
            c = e;
            e = t;
        }
        if (QuickSort.compare(c, d, comparator) > 0) {
            t = c;
            c = d;
            d = t;
        }
        x[ai] = a;
        x[bi] = b;
        x[ci] = c;
        x[di] = d;
        x[ei] = e;
        return ci;
    }

    private static int medianOfFive(LongComparator comparator, long[] x, int ai, int bi, int ci, int di, int ei) {
        long t;
        long a = x[ai];
        long b = x[bi];
        long c = x[ci];
        long d = x[di];
        long e = x[ei];
        if (QuickSort.compare(a, b, comparator) > 0) {
            t = a;
            a = b;
            b = t;
        }
        if (QuickSort.compare(d, e, comparator) > 0) {
            t = d;
            d = e;
            e = t;
        }
        if (QuickSort.compare(a, d, comparator) > 0) {
            t = a;
            a = d;
            d = t;
            t = b;
            b = e;
            e = t;
        }
        if (QuickSort.compare(b, c, comparator) > 0) {
            t = b;
            b = c;
            c = t;
        }
        if (QuickSort.compare(b, d, comparator) > 0) {
            t = b;
            b = d;
            d = t;
            t = c;
            c = e;
            e = t;
        }
        if (QuickSort.compare(c, d, comparator) > 0) {
            t = c;
            c = d;
            d = t;
        }
        x[ai] = a;
        x[bi] = b;
        x[ci] = c;
        x[di] = d;
        x[ei] = e;
        return ci;
    }

    private static int compare(Object o1, Object o2, Comparator c) {
        if (o1 == o2) {
            return 0;
        }
        return c != null ? c.compare(o1, o2) : ((Comparable)o1).compareTo(o2);
    }

    private static int compare(int i1, int i2, IntComparator c) {
        if (i1 == i2) {
            return 0;
        }
        return c.compare(i1, i2);
    }

    private static int compare(long i1, long i2, LongComparator c) {
        if (i1 == i2) {
            return 0;
        }
        return c.compare(i1, i2);
    }

    private static void rangeCheck(int length, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex " + fromIndex + " > toIndex " + toIndex);
        }
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex " + fromIndex + " < 0");
        }
        if (toIndex > length) {
            throw new IndexOutOfBoundsException("toIndex " + toIndex + " > length " + length);
        }
    }

    private QuickSort() {
    }
}

